/*
 * Decompiled with CFR 0.152.
 */
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class StatementLexikon {
    private String m_Databasetype = "";
    private List m_lstEntries = null;
    private Iterator m_itEntries = null;
    private static final String cstrNotDefined = "notdefined";
    private static final String cstrOracle = "oracle";
    private static final String cstrMySQL = "mysql";
    private static final String cstrPostgreSQL = "pgsql";

    public StatementLexikon() {
        this.readStatements();
    }

    private void readStatements() {
        try {
            SAXBuilder sax = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
            Document doc = sax.build("sqlcommands.xml");
            Element Command = doc.getRootElement();
            this.m_itEntries = null;
            if (Command != null) {
                this.m_lstEntries = Command.getChildren();
                this.m_itEntries = this.m_lstEntries.iterator();
            }
        }
        catch (Exception unhandled) {
            System.out.println("E " + unhandled.getMessage());
        }
    }

    public String GetFirst() {
        String strReturn = null;
        if (this.m_itEntries != null) {
            this.m_itEntries = this.m_lstEntries.iterator();
            if (this.m_itEntries.hasNext()) {
                Element Entry2 = (Element)this.m_itEntries.next();
                strReturn = Entry2.getAttribute("name").getValue().toString();
            }
        }
        return strReturn;
    }

    public String GetNext() {
        String strReturn = null;
        if (this.m_itEntries != null && this.m_itEntries.hasNext()) {
            Element Entry2 = (Element)this.m_itEntries.next();
            strReturn = Entry2.getAttribute("name").getValue().toString();
        }
        return strReturn;
    }

    public int GetCount() {
        int nRet = 0;
        if (this.m_itEntries != null) {
            this.m_itEntries = this.m_lstEntries.iterator();
            while (this.m_itEntries.hasNext()) {
                this.m_itEntries.next();
                ++nRet;
            }
        }
        return nRet;
    }

    public String GetStatement(String strDBType, String strName) {
        String strReturn = "";
        String strDatabaseType = "";
        strDatabaseType = strDBType.equalsIgnoreCase(cstrOracle) ? cstrOracle : (strDBType.equalsIgnoreCase("oracle9i") ? cstrOracle : (strDBType.equalsIgnoreCase(cstrMySQL) ? cstrMySQL : (strDBType.equalsIgnoreCase("postgresql") ? cstrPostgreSQL : cstrNotDefined)));
        Iterator itEntries = this.m_lstEntries.iterator();
        while (itEntries.hasNext()) {
            Element Entry2 = (Element)itEntries.next();
            String strEntryName = Entry2.getAttribute("name").getValue().toString();
            if (!strEntryName.equalsIgnoreCase(strName)) continue;
            strReturn = Entry2.getAttribute(strDatabaseType).getValue().toString();
            break;
        }
        return strReturn;
    }
}

