#!/usr/bin/bash

if [ "$1" = "--help" ] || [ "$1" = "-h" ]
then
    echo IP-address or resolved name can be given as
    echo parameter to this batch. If no address is given to the script
    echo it tries to determine the address on its own.
    echo Three examples:
    echo startsqlfreeRMIServerLinux
    echo startsqlfreeRMIServerLinux 133.133.3.1
    echo startsqlfreeRMIServerLinux test.adress.com

    exit 0
fi

source ../cfg/setpath

export LOGFILE=../log/dblogRMI.sqlFree


h="0.0.0.0"

if [ "$1" = "" ]
then
   h=`hostname -i | tr -d " "`
else
   h="$1"
fi


#*****************************************************************
# Start RMI-Registry. All RMI-Objects of this local machine are
# saved in here.
#*****************************************************************
rmiregistry &
sleep 3

#***************************************************************
# Start serverobject. It registers itself at the registry.
#***************************************************************
echo Working with ip-address **$h** 
echo ...
echo Output is redirected to $LOGFILE
java -Dsqlfree.home=.. -Djava.security.policy=../lib/sqlFree.policy -Djava.rmi.server.codebase=http://$h/ javak.zs.DBjavakFactory 1>$LOGFILE 2>&1
