/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.VariableSubstitutor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class XInfoPanel
extends IzPanel {
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints gbConstraints = new GridBagConstraints();
    private JLabel infoLabel;
    private JTextArea textArea;
    private String info;

    public XInfoPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        this.setLayout(this.layout);
        this.infoLabel = new JLabel(installerFrame.langpack.getString("InfoPanel.info"), installerFrame.icons.getImageIcon("edit"), 11);
        installerFrame.buildConstraints(this.gbConstraints, 0, 0, 1, 1, 1.0, 0.0);
        this.gbConstraints.insets = new Insets(5, 5, 5, 5);
        this.gbConstraints.fill = 1;
        this.gbConstraints.anchor = 16;
        this.layout.addLayoutComponent(this.infoLabel, this.gbConstraints);
        this.add(this.infoLabel);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        installerFrame.buildConstraints(this.gbConstraints, 0, 1, 1, 1, 1.0, 0.9);
        this.gbConstraints.anchor = 10;
        this.layout.addLayoutComponent(jScrollPane, this.gbConstraints);
        this.add(jScrollPane);
    }

    private void loadInfo() {
        try {
            this.info = ResourceManager.getInstance().getTextResource("XInfoPanel.info");
        }
        catch (Exception exception) {
            this.info = "Error : could not load the info text !";
        }
    }

    private void parseText() {
        try {
            VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.idata.getVariables());
            this.info = variableSubstitutor.substitute(this.info, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void panelActivate() {
        this.loadInfo();
        this.parseText();
        this.textArea.setText(this.info.toString());
        this.textArea.setCaretPosition(0);
    }

    public boolean isValidated() {
        return true;
    }
}

