/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;

class PictureCanvas
extends Canvas
implements MouseListener {
    public static final int zWHeight = 660;
    Image picture = null;

    PictureCanvas(boolean bl) {
        if (bl) {
            this.addMouseListener(this);
        }
    }

    public synchronized void setPicture(Image image) {
        if (image != this.picture) {
            this.picture = image;
            this.repaint();
        }
    }

    public void setPicture(PictureCanvas pictureCanvas) {
        this.setPicture(pictureCanvas.picture);
    }

    public synchronized void paint(Graphics graphics) {
        if (this.picture != null) {
            int n;
            Dimension dimension = this.getSize();
            int n2 = this.picture.getWidth(this);
            if ((double)dimension.width / (double)dimension.height >= (double)n2 / (double)(n = this.picture.getHeight(this))) {
                n2 = (int)((double)n2 * ((double)dimension.height / (double)n));
                n = dimension.height;
            } else {
                n = (int)((double)n * ((double)dimension.width / (double)n2));
                n2 = dimension.width;
            }
            graphics.drawImage(this.picture, (dimension.width - n2) / 2, (dimension.height - n) / 2, n2, n, this);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.picture != null && mouseEvent.getButton() == 1) {
            JFrame jFrame = new JFrame("Zoom window");
            PictureCanvas pictureCanvas = new PictureCanvas(false);
            pictureCanvas.setPicture(this.picture);
            jFrame.getContentPane().add(pictureCanvas);
            jFrame.setSize(850, 660);
            jFrame.setDefaultCloseOperation(2);
            jFrame.setVisible(true);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (this.picture != null && mouseEvent.isPopupTrigger()) {
            SelectorControls.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
            SelectorControls.popupSource = (Vignette)this.getParent();
        }
    }
}

