/*
 * Decompiled with CFR 0.152.
 */
import fr.free.palbou.infowin.InfoWin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class SelectorControls
extends JPanel
implements ActionListener,
ChangeListener,
canRotate {
    static final int oWidth = 133;
    static final int oHeight = 108;
    static final int iHWidth = 580;
    static final int iHHeight = 640;
    static final int pbLength = 80;
    static final String[] AdbOptions = new String[]{"Ok", "Display help"};
    static final String[] Cs = new String[]{"default", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    MainPicture target;
    Frame frame;
    String dir;
    String dest;
    Vector files;
    int curF;
    ImageReader refReader;
    ImageWriter writer;
    int compression;
    boolean turned;
    BufferedImage uprightPicture;
    File audio;
    File prev_audio;
    File audio_src;
    AudioInputStream ais;
    SourceDataLine sadl;
    JButton bprv;
    JButton bnxt;
    JButton copy;
    JButton copy_nxt;
    JButton remove;
    JButton bt90d;
    JButton bt_90d;
    JButton quality;
    JButton play;
    JToggleButton straighten;
    JProgressBar ilpb;
    PictureCanvas origin;
    JLabel indic;
    JLabel comp_level;
    JCheckBox auto_play;
    JCheckBox cpWav;
    JCheckBox cpPrevWav;
    MenuItem pusmi;
    PopupMenu popup;
    int crop_mode;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    SelectorControls(MainPicture mainPicture, Frame frame) {
        this.target = mainPicture;
        this.frame = frame;
        this.files = new Vector();
        this.compression = -1;
        this.turned = false;
        this.audio = null;
        JButton jButton = new JButton("Go to...");
        this.add(jButton);
        jButton.addActionListener(this);
        this.bprv = new JButton("<<<");
        this.bprv.addActionListener(this);
        this.bprv.setEnabled(false);
        this.bnxt = new JButton(">>>");
        this.bnxt.addActionListener(this);
        this.bnxt.setEnabled(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.bprv);
        jPanel.add((Component)this.bnxt, "South");
        this.add(jPanel);
        this.bt90d = new JButton("+90\u00b0");
        this.bt_90d = new JButton("-90\u00b0");
        URL uRL = this.getClass().getClassLoader().getResource("images/bt90d.gif");
        URL uRL2 = this.getClass().getClassLoader().getResource("images/bt_90d.gif");
        if (uRL == null || uRL2 == null) {
            System.err.println("Couldn't reach icons");
        } else {
            this.bt90d = new JButton(new ImageIcon(uRL, "+90\u00b0"));
            this.bt_90d = new JButton(new ImageIcon(uRL2, "-90\u00b0"));
            this.bt90d.setActionCommand("+90\u00b0");
            this.bt_90d.setActionCommand("-90\u00b0");
        }
        this.bt90d.setToolTipText("90\u00b0 counterclockwise");
        this.bt_90d.setToolTipText("90\u00b0 clockwise");
        this.bt90d.addActionListener(this);
        this.bt_90d.addActionListener(this);
        this.bt90d.setEnabled(false);
        this.bt_90d.setEnabled(false);
        URL uRL3 = this.getClass().getClassLoader().getResource("images/btstraighten.gif");
        if (uRL3 == null) {
            this.straighten = new JToggleButton("Straighten");
        } else {
            this.straighten = new JToggleButton(new ImageIcon(uRL3));
            this.straighten.setActionCommand("Straighten");
        }
        this.straighten.setToolTipText("straighten picture");
        this.straighten.addActionListener(this);
        this.straighten.setEnabled(false);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.bt90d, "North");
        jPanel2.add(this.bt_90d);
        jPanel2.add((Component)this.straighten, "South");
        this.add(jPanel2);
        this.copy = new JButton("Copy");
        this.copy.addActionListener(this);
        this.copy.setEnabled(false);
        this.copy_nxt = new JButton("Copy >>>");
        this.copy_nxt.addActionListener(this);
        this.copy_nxt.setEnabled(false);
        this.remove = new JButton("Remove");
        this.remove.addActionListener(this);
        this.remove.setEnabled(false);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.copy, "North");
        jPanel3.add(this.copy_nxt);
        jPanel3.add((Component)this.remove, "South");
        this.add(jPanel3);
        this.cpWav = new JCheckBox("copy", true);
        this.cpWav.setEnabled(false);
        this.cpWav.addChangeListener(this);
        this.cpPrevWav = new JCheckBox("previous", false);
        this.cpPrevWav.setEnabled(false);
        this.cpPrevWav.addChangeListener(this);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)new JLabel("Sound:"), "North");
        jPanel4.add(this.cpWav);
        jPanel4.add((Component)this.cpPrevWav, "South");
        this.add(jPanel4);
        this.origin = new PictureCanvas();
        this.origin.addMouseListener(new PopupListener());
        this.indic = new JLabel("", 0);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add(this.origin);
        jPanel5.add("South", this.indic);
        jPanel5.setBorder(new LineBorder(Color.black));
        jPanel5.setPreferredSize(new Dimension(133, 108));
        this.add(jPanel5);
        this.quality = new JButton("C");
        this.quality.addActionListener(this);
        this.quality.setEnabled(false);
        this.quality.setToolTipText("compression level (rotated pictures)");
        this.comp_level = new JLabel(Cs[0], 0);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add(this.quality);
        jPanel6.add((Component)this.comp_level, "South");
        this.add(jPanel6);
        uRL3 = this.getClass().getClassLoader().getResource("images/btplay.gif");
        if (uRL3 == null) {
            this.play = new JButton("Play");
        } else {
            this.play = new JButton(new ImageIcon(uRL3));
            this.play.setActionCommand("Play");
        }
        this.play.addActionListener(this);
        this.play.setEnabled(false);
        this.auto_play = new JCheckBox("auto", true);
        this.auto_play.setEnabled(false);
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.add(this.play);
        jPanel7.add((Component)this.auto_play, "South");
        this.add(jPanel7);
        JButton jButton2 = new JButton("?");
        jButton2.addActionListener(this);
        this.add(jButton2);
        this.ilpb = new JProgressBar(0);
        this.ilpb.setString("Loading");
        this.ilpb.setPreferredSize(new Dimension(80, 20));
        this.add(this.ilpb);
        JButton jButton3 = new JButton("Exit");
        this.add(jButton3);
        jButton3.addActionListener(this);
        this.pusmi = new MenuItem("Play audio...");
        this.pusmi.setActionCommand("Play");
        this.pusmi.addActionListener(this);
        this.pusmi.setEnabled(false);
        this.popup = new PopupMenu();
        this.popup.add(this.pusmi);
        this.origin.add(this.popup);
    }

    void setPicture(String string) {
        if (this.remove.isEnabled()) {
            Selector.start(new PictureReader(this.target, this.dest + string, this.origin, this.dir + string, this.ilpb));
            this.indic.setText("in source dir.");
        } else {
            Selector.start(new PictureReader(this.target, this.dir + string, null, null, this.ilpb));
            this.origin.setPicture((BufferedImage)null);
            this.indic.setText("");
        }
        this.frame.setTitle("Pictures selector - " + string);
        this.ilpb.setStringPainted(true);
        this.ilpb.setIndeterminate(true);
    }

    void updateActionButtons() {
        File file = new File(this.dest + this.files.elementAt(this.curF));
        if (file.exists()) {
            this.copy.setEnabled(false);
            this.copy_nxt.setEnabled(false);
            this.remove.setEnabled(true);
            this.bt90d.setEnabled(false);
            this.bt_90d.setEnabled(false);
            this.straighten.setEnabled(false);
        } else {
            this.copy.setEnabled(true);
            this.copy_nxt.setEnabled(this.curF < this.files.size() - 1);
            this.remove.setEnabled(false);
            this.bt90d.setEnabled(this.writer != null);
            this.bt_90d.setEnabled(this.writer != null);
            this.straighten.setEnabled(this.writer != null);
        }
        String string = (String)this.files.elementAt(this.curF);
        string = string.substring(0, string.lastIndexOf(46)) + ".wav";
        this.audio = new File(this.dest + string);
        this.audio_src = new File(this.dir + string);
        if (!this.audio.exists()) {
            this.audio = this.audio_src;
        }
        if (this.audio.exists()) {
            this.play.setEnabled(true);
            this.auto_play.setEnabled(true);
            this.cpWav.setEnabled(true);
        } else {
            this.play.setEnabled(false);
            this.auto_play.setEnabled(false);
            this.cpWav.setEnabled(false);
            this.audio = null;
        }
        this.pusmi.setEnabled(this.audio_src.exists());
        if (this.curF > 0) {
            string = (String)this.files.elementAt(this.curF - 1);
            string = string.substring(0, string.lastIndexOf(46)) + ".wav";
            this.prev_audio = new File(this.dest + string);
            if (!this.prev_audio.exists()) {
                this.prev_audio = new File(this.dir + string);
            }
        }
        if (this.curF == 0 || !this.prev_audio.exists()) {
            this.cpPrevWav.setEnabled(false);
            this.prev_audio = null;
        } else {
            this.cpPrevWav.setEnabled(true);
        }
        this.uprightPicture = null;
        System.gc();
    }

    public void rotate(double d) {
        double d2;
        double d3;
        double d4 = (double)this.target.getImage().getWidth() / 2.0;
        double d5 = (double)this.target.getImage().getHeight() / 2.0;
        AffineTransform affineTransform = new AffineTransform(Math.cos(d), Math.sin(d), -Math.sin(d), Math.cos(d), d4 - d4 * Math.cos(d) + d5 * Math.sin(d), d5 - d4 * Math.sin(d) - d5 * Math.cos(d));
        if (!this.turned) {
            this.uprightPicture = this.target.getImage();
        }
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        BufferedImage bufferedImage = new BufferedImage(this.target.getImage().getWidth(), this.target.getImage().getHeight(), this.target.getImage().getType());
        affineTransformOp.filter(this.target.getImage(), bufferedImage);
        double d6 = -Math.abs(d);
        double d7 = -d4 * Math.cos(d6) - d5 * Math.sin(d6);
        double d8 = -d4 * Math.sin(d6) + d5 * Math.cos(d6);
        double d9 = d4 * Math.cos(d6) - d5 * Math.sin(d6);
        double d10 = d4 * Math.sin(d6) + d5 * Math.cos(d6);
        double d11 = -d4 * Math.cos(d6) + d5 * Math.sin(d6);
        double d12 = -d4 * Math.sin(d6) - d5 * Math.cos(d6);
        new CropMode().show();
        switch (this.crop_mode) {
            case 2: {
                d3 = d7 * ((d10 - d8) * (d11 - d7) - (d9 - d7) * (d12 - d8)) / ((d10 - d8) * (d11 - d7) + (d9 - d7) * (d12 - d8));
                d2 = (d3 - d7) * (d10 - d8) / (d9 - d7) + d8;
                break;
            }
            case 1: {
                double d13 = d5 / d4;
                d3 = d4 > d5 ? (d7 * (d10 - d8) - d8 * (d9 - d7)) / (d10 - d8 - d13 * (d9 - d7)) : -(d7 * (d12 - d8) - d8 * (d11 - d7)) / (d12 - d8 + d13 * (d11 - d7));
                d2 = d13 * d3;
                break;
            }
            default: {
                d3 = d4;
                d2 = d5;
            }
        }
        this.target.setPicture(bufferedImage.getSubimage((int)(d4 - d3), (int)(d5 - d2), (int)(2.0 * d3), (int)(2.0 * d2)));
        this.turned = true;
        bufferedImage = null;
        affineTransformOp = null;
        affineTransform = null;
        System.gc();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        if (actionEvent.getActionCommand().equals("Exit")) {
            System.exit(0);
        }
        if (actionEvent.getActionCommand().equals("?")) {
            if (JOptionPane.showOptionDialog(this.frame, "Pictures selector #1\nCopyright (C) Pierre Albou, 2003.\nAll rights reserved.", "About the program", 0, 1, null, AdbOptions, AdbOptions[0]) == 1) {
                InfoWin infoWin = new InfoWin(this.getClass().getClassLoader().getResource("help.html"), "Pictures selector #1 - help");
                infoWin.setSize(580, 640);
                infoWin.setVisible(true);
            }
            return;
        }
        if (actionEvent.getActionCommand().equals("C")) {
            String string = (String)JOptionPane.showInputDialog(this.frame, "Select compression level:", "Compression", 3, null, Cs, Cs[1 + this.compression]);
            if (string == null) {
                return;
            }
            this.comp_level.setText(string);
            this.compression = string.equals("default") ? -1 : Integer.parseInt(string);
            return;
        }
        if (Selector.isLoading()) {
            JOptionPane.showMessageDialog(this.frame, "Picture still loading...", "Warning", 2);
            return;
        }
        boolean bl = actionEvent.getActionCommand().equals("Copy");
        if (bl || actionEvent.getActionCommand().equals("Copy >>>")) {
            Object object;
            String string = "in source dir.";
            if (this.turned) {
                try {
                    if (this.compression != -1) {
                        object = this.writer.getDefaultWriteParam();
                        ((ImageWriteParam)object).setCompressionMode(2);
                        ((ImageWriteParam)object).setCompressionQuality(1.0f - (float)this.compression / 10.0f);
                    } else {
                        object = null;
                    }
                    this.writer.setOutput(ImageIO.createImageOutputStream(new File(this.dest + this.files.elementAt(this.curF))));
                    this.writer.write(null, new IIOImage(this.target.getImage(), null, null), (ImageWriteParam)object);
                }
                catch (IOException iOException) {
                    System.err.println("IO error: couldn't write rotated image:\n" + iOException.getMessage());
                    string = "";
                }
                this.writer.reset();
                this.writer.dispose();
                this.writer = ImageIO.getImageWriter(this.refReader);
                if (bl) {
                    this.origin.setPicture(this.uprightPicture);
                }
            } else {
                Selector.copyFile(this.dir + this.files.elementAt(this.curF), this.dest + this.files.elementAt(this.curF));
                if (bl) {
                    this.origin.setPicture(this.target);
                }
            }
            if (this.audio != null && this.cpWav.isSelected() && ((File)(object = new File(this.dir + this.audio.getName()))).exists()) {
                Selector.copyFile(((File)object).getPath(), this.dest + this.audio.getName());
            }
            if (this.prev_audio != null && this.cpPrevWav.isSelected()) {
                object = (String)this.files.elementAt(this.curF);
                object = ((String)object).substring(0, ((String)object).lastIndexOf(46)) + ".wav";
                Selector.copyFile(this.prev_audio.getPath(), this.dest + (String)object);
            }
            if (bl) {
                this.updateActionButtons();
                this.indic.setText(string);
            } else {
                this.actionPerformed(new ActionEvent(this.copy_nxt, 0, ">>>"));
            }
            return;
        }
        if (actionEvent.getActionCommand().equals("+90\u00b0") || actionEvent.getActionCommand().equals("-90\u00b0")) {
            AffineTransform affineTransform = actionEvent.getActionCommand().equals("+90\u00b0") ? new AffineTransform(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, this.target.getImage().getWidth()) : new AffineTransform(0.0f, 1.0f, -1.0f, 0.0f, this.target.getImage().getHeight(), 0.0f);
            if (!this.turned) {
                this.uprightPicture = this.target.getImage();
            }
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
            BufferedImage bufferedImage = new BufferedImage(this.target.getImage().getHeight(), this.target.getImage().getWidth(), this.target.getImage().getType());
            affineTransformOp.filter(this.target.getImage(), bufferedImage);
            this.target.setPicture(bufferedImage);
            this.turned = true;
            bufferedImage = null;
            affineTransformOp = null;
            affineTransform = null;
            System.gc();
            return;
        }
        if (actionEvent.getActionCommand().equals("Straighten")) {
            this.target.enterAngleReadingMode(this.straighten, this);
            return;
        }
        if (actionEvent.getActionCommand().equals("Remove")) {
            File file = new File(this.dest + this.files.elementAt(this.curF));
            file.delete();
            if (this.audio != null) {
                file = new File(this.dest + this.audio.getName());
                file.delete();
            }
            this.updateActionButtons();
            this.target.setPicture(this.origin);
            this.origin.setPicture((BufferedImage)null);
            this.indic.setText("");
            this.turned = false;
            return;
        }
        if (actionEvent.getActionCommand().equals("Go to...")) {
            serializable = new FileDialog(this.frame, "Choose a first file", 0);
            ((Dialog)serializable).setVisible(true);
            FileDialog fileDialog = new FileDialog(this.frame, "Choose a destination folder", 1);
            fileDialog.setFile("---");
            fileDialog.setVisible(true);
            if (((FileDialog)serializable).getFile() == null || fileDialog.getDirectory() == null) {
                return;
            }
            this.dir = ((FileDialog)serializable).getDirectory();
            this.dest = fileDialog.getDirectory();
            int n = ((FileDialog)serializable).getFile().lastIndexOf(46);
            String string = "";
            if (n >= 0) {
                string = ((FileDialog)serializable).getFile().toLowerCase().substring(n);
            }
            this.files.clear();
            String[] stringArray = new File(this.dir).list();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].toLowerCase().endsWith(string)) continue;
                this.files.add(stringArray[i].toLowerCase());
            }
            Collections.sort(this.files);
            this.curF = this.files.indexOf(((FileDialog)serializable).getFile().toLowerCase());
            if (this.files.isEmpty()) {
                this.bprv.setEnabled(false);
                this.bnxt.setEnabled(false);
                this.copy.setEnabled(false);
                this.copy_nxt.setEnabled(false);
                this.remove.setEnabled(false);
                this.bt90d.setEnabled(false);
                this.bt_90d.setEnabled(false);
                this.straighten.setEnabled(false);
                this.quality.setEnabled(false);
            } else {
                if (this.curF > 0) {
                    this.bprv.setEnabled(true);
                }
                if (this.curF < this.files.size() - 1) {
                    this.bnxt.setEnabled(true);
                }
                try {
                    Iterator<ImageReader> iterator = ImageIO.getImageReaders(ImageIO.createImageInputStream(new File(this.dir + ((FileDialog)serializable).getFile())));
                    if (iterator.hasNext()) {
                        this.refReader = iterator.next();
                        this.writer = ImageIO.getImageWriter(this.refReader);
                        if (this.writer == null) {
                            this.quality.setEnabled(false);
                        } else {
                            this.quality.setEnabled(true);
                            ImageWriteParam imageWriteParam = this.writer.getDefaultWriteParam();
                            try {
                                imageWriteParam.setCompressionMode(2);
                                imageWriteParam.setCompressionQuality(0.7f);
                            }
                            catch (Exception exception) {
                                this.compression = -1;
                                this.quality.setEnabled(false);
                            }
                        }
                    } else {
                        this.writer = null;
                    }
                }
                catch (IOException iOException) {
                    this.writer = null;
                }
                this.updateActionButtons();
            }
            this.setPicture(((FileDialog)serializable).getFile());
        }
        if (actionEvent.getActionCommand().equals("<<<")) {
            if (--this.curF <= 0) {
                this.bprv.setEnabled(false);
            }
            if (this.curF < this.files.size() - 1) {
                this.bnxt.setEnabled(true);
            }
            this.updateActionButtons();
            this.setPicture((String)this.files.elementAt(this.curF));
        }
        if (actionEvent.getActionCommand().equals(">>>")) {
            if (++this.curF > 0) {
                this.bprv.setEnabled(true);
            }
            if (this.curF >= this.files.size() - 1) {
                this.bnxt.setEnabled(false);
            }
            this.updateActionButtons();
            this.setPicture((String)this.files.elementAt(this.curF));
        }
        this.turned = false;
        if (this.cpPrevWav.isSelected()) {
            this.cpWav.setSelected(true);
            this.cpPrevWav.setSelected(false);
        }
        if (actionEvent.getActionCommand().equals("Play") || this.audio != null && this.auto_play.isSelected()) {
            serializable = actionEvent.getSource().equals(this.pusmi) ? this.audio_src : this.audio;
            try {
                this.ais = AudioSystem.getAudioInputStream((File)serializable);
                this.sadl = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = SelectorControls.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, this.ais.getFormat()));
                this.sadl.open(this.ais.getFormat());
                this.sadl.start();
                new PlayThread().start();
            }
            catch (Throwable throwable) {
                JOptionPane.showMessageDialog(this.frame, "Cannot playback the " + this.audio.getName() + " file", "Error", 0);
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource().equals(this.cpWav) && this.cpWav.isSelected()) {
            this.cpPrevWav.setSelected(false);
        }
        if (changeEvent.getSource().equals(this.cpPrevWav) && this.cpPrevWav.isSelected()) {
            this.cpWav.setSelected(false);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class CropMode
    extends JDialog
    implements ActionListener {
        CropMode() {
            super(SelectorControls.this.frame, "Choose cropping method", true);
            JButton jButton;
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            JPanel jPanel = new JPanel(gridBagLayout);
            URL uRL = this.getClass().getClassLoader().getResource("images/wrbtn.gif");
            if (uRL == null) {
                jButton = new JButton("Wide rectangle");
            } else {
                jButton = new JButton(new ImageIcon(uRL));
                jButton.setActionCommand("Wide rectangle");
            }
            jButton.addActionListener(this);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            jPanel.add(jButton);
            JLabel jLabel = new JLabel(" Widest/highest possible rectangle ");
            ++gridBagConstraints.gridx;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            uRL = this.getClass().getClassLoader().getResource("images/prbtn.gif");
            if (uRL == null) {
                jButton = new JButton("Same aspect ratio rectangle");
            } else {
                jButton = new JButton(new ImageIcon(uRL));
                jButton.setActionCommand("Same aspect ratio rectangle");
            }
            jButton.addActionListener(this);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            jPanel.add(jButton);
            jLabel = new JLabel(" Preserve width/height ratio ");
            ++gridBagConstraints.gridx;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            uRL = this.getClass().getClassLoader().getResource("images/orbtn.gif");
            if (uRL == null) {
                jButton = new JButton("Original rectangle");
            } else {
                jButton = new JButton(new ImageIcon(uRL));
                jButton.setActionCommand("Original rectangle");
            }
            jButton.addActionListener(this);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            jPanel.add(jButton);
            jLabel = new JLabel(" Original size (add black patches) ");
            ++gridBagConstraints.gridx;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            this.getContentPane().add((Component)jPanel, "Center");
            this.pack();
            this.setLocationRelativeTo(SelectorControls.this.frame);
            SelectorControls.this.crop_mode = 1;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SelectorControls.this.crop_mode = actionEvent.getActionCommand().equals("Wide rectangle") ? 2 : (actionEvent.getActionCommand().equals("Same aspect ratio rectangle") ? 1 : 0);
            this.dispose();
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                SelectorControls.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class PlayThread
    extends Thread {
        byte[] buffer = new byte[16384];

        PlayThread() {
        }

        public void run() {
            try {
                int n;
                while ((n = SelectorControls.this.ais.read(this.buffer, 0, this.buffer.length)) != -1) {
                    if (n <= 0) continue;
                    SelectorControls.this.sadl.write(this.buffer, 0, n);
                }
                SelectorControls.this.sadl.drain();
                SelectorControls.this.sadl.close();
                SelectorControls.this.ais.close();
            }
            catch (Exception exception) {
                System.err.println("Playback I/O error: file " + SelectorControls.this.audio.getName());
            }
        }
    }
}

