/*
 * Decompiled with CFR 0.152.
 */
package WizSolitaire.Games;

import WizSolitaire.Card;
import WizSolitaire.CardGame;
import WizSolitaire.CardWrapper;
import WizSolitaire.Deck;
import WizSolitaire.GameTable;
import WizSolitaire.TableCell;
import WizSolitaire.UndoStep;
import java.awt.Rectangle;
import java.util.Vector;

public class FreeCell
extends CardGame {
    private int a;

    public FreeCell(Deck deck, GameTable gameTable, int n2, int n3) {
        super("Free Cell", deck, gameTable, n2, n3);
    }

    protected void SetupCells() {
        int n2;
        for (n2 = 0; n2 < 4; ++n2) {
            this.Table.AddCell(new TableCell());
        }
        for (n2 = 0; n2 < 4; ++n2) {
            TableCell tableCell = new TableCell();
            tableCell.SetBackground(this.MyDeck.GetPlaceholder(n2));
            this.Table.AddCell(tableCell);
        }
        for (n2 = 0; n2 < 8; ++n2) {
            this.Table.AddCell(new TableCell());
        }
    }

    protected void Layout() {
        int n2;
        this.Table.Resize(12 + 8 * (6 + this.CardWidth), 15 + (this.CardHeight << 2));
        float f2 = (float)((double)this.CardWidth / 88.0);
        int n3 = (int)(14.0f * f2);
        int n4 = this.CardHeight + 15;
        for (n2 = 0; n2 < 4; ++n2) {
            this.Table.GetCell(n2).SetPos(6 + n2 * (this.CardWidth + 1), 5);
        }
        int n5 = this.Table.getSize().width - (this.CardWidth + 1 << 2) - 6;
        for (n2 = 0; n2 < 4; ++n2) {
            this.Table.GetCell(4 + n2).SetPos(n5 + n2 * (this.CardWidth + 1), 5);
        }
        for (n2 = 0; n2 < 8; ++n2) {
            TableCell tableCell = this.Table.GetCell(8 + n2);
            tableCell.SetPos(6 + n2 * (6 + this.CardWidth), n4);
            tableCell.SetCardSpacing(0, n3);
        }
    }

    protected void PlaceCards() {
        for (int i2 = 0; i2 < 52; ++i2) {
            TableCell tableCell = this.Table.GetCell(8 + i2 % 8);
            CardWrapper cardWrapper = this.Table.WrapCard(this.MyDeck.Pick());
            tableCell.AddCard(cardWrapper);
            cardWrapper.SetFrontUp(true);
        }
        this.a = 52;
    }

    private int e(TableCell tableCell, int n2) {
        int n3 = 0;
        TableCell tableCell2 = this.Table.GetCell(n2);
        if (n2 <= 3) {
            if (tableCell2.GetWrapper(0) == null) {
                n3 = 1;
            }
        } else if (n2 >= 4 && n2 <= 7) {
            Card card = tableCell.GetCard(-1);
            Card card2 = tableCell2.GetCard(-1);
            if (card2 == null && card.GetValue() == 1 || card2 != null && card.GetSuit() == card2.GetSuit() && card.GetValue() == card2.GetValue() + 1) {
                n3 = 1;
            }
        } else {
            Card card;
            int n4;
            int n5 = 0;
            Card card3 = null;
            Card card4 = tableCell2.GetCard(-1);
            boolean bl = true;
            int n6 = n4 = tableCell.GetCardsCount();
            while (bl && --n6 >= 0) {
                card = tableCell.GetCard(n6);
                bl = card3 == null || card.GetColor() != card3.GetColor() && card.GetValue() == card3.GetValue() + 1;
                card3 = card;
                if (!bl) continue;
                ++n5;
            }
            if (card4 != null) {
                for (n6 = n4 - n5; n6 < n4 && ((card = tableCell.GetCard(n6)).GetColor() == card4.GetColor() || card.GetValue() != card4.GetValue() - 1); ++n6) {
                }
                n5 = n4 - n6;
            }
            if (n5 > 0) {
                n6 = 1;
                for (int i2 = 0; i2 < 16; ++i2) {
                    if (i2 >= 4 && i2 <= 7 || this.Table.GetCell(i2).GetWrapper(0) != null) continue;
                    ++n6;
                }
                if (n6 >= n5) {
                    n3 = n5;
                } else if (n2 > 8 && this.Table.GetCell(n2).GetWrapper(0) == null) {
                    n3 = n6;
                } else {
                    this.Table.StatusMsg("You can only move " + n6 + " cards!");
                }
            }
        }
        return n3;
    }

    private void f(TableCell tableCell, int n2) {
        TableCell tableCell2 = this.Table.GetCell(n2);
        int n3 = this.e(tableCell, n2);
        if (n3 > 0) {
            int n4;
            int n5 = tableCell.GetCardsCount();
            UndoStep undoStep = this.NewMove();
            for (n3 = n4 = n5 - n3; n3 < n5; ++n3) {
                CardWrapper cardWrapper = tableCell.GetWrapper(n4);
                if (n2 >= 4 && n2 <= 7) {
                    --this.a;
                }
                undoStep.AddMove(cardWrapper, tableCell);
                tableCell2.AddCard(cardWrapper);
            }
            this.CleanUp(undoStep);
            this.AddUndo(undoStep);
            return;
        }
        if (tableCell2 != tableCell) {
            this.Beep();
        }
    }

    public void CardDblClick(CardWrapper cardWrapper, int n2, int n3) {
        UndoStep undoStep = this.NewMove();
        if (n2 >= 8) {
            TableCell tableCell = this.Table.GetCell(n2);
            CardWrapper cardWrapper2 = tableCell.GetWrapper(-1);
            boolean bl = false;
            for (int i2 = 0; !bl && i2 <= 3; ++i2) {
                if (this.e(tableCell, i2) <= 0) continue;
                undoStep.AddMove(cardWrapper2, tableCell);
                this.Table.GetCell(i2).AddCard(cardWrapper2);
                bl = true;
            }
            if (!bl) {
                this.Beep();
            }
        }
        this.CleanUp(undoStep);
        this.AddUndo(undoStep);
        this.Table.StatusMsg("");
        this.Table.repaint();
    }

    public void CardMouseDown(CardWrapper cardWrapper, int n2, int n3, int n4, int n5) {
        if (n2 < 4 || n2 >= 8) {
            int n6;
            TableCell tableCell = this.Table.GetCell(n2);
            if (cardWrapper == tableCell.GetWrapper(-1)) {
                cardWrapper.SetMoving(true);
                return;
            }
            Card card = null;
            boolean bl = false;
            boolean bl2 = true;
            for (n6 = tableCell.GetCardsCount() - 1; bl2 && n6 >= 0; --n6) {
                CardWrapper cardWrapper2 = tableCell.GetWrapper(n6);
                Card card2 = cardWrapper2.GetCard();
                if (card != null && (card2.GetColor() == card.GetColor() || card2.GetValue() != card.GetValue() + 1)) {
                    bl2 = false;
                }
                if (bl2 && cardWrapper2 == cardWrapper) {
                    bl = true;
                }
                card = card2;
            }
            if (bl) {
                if (!bl2) {
                    ++n6;
                }
                ++n6;
                while (n6 < tableCell.GetCardsCount()) {
                    tableCell.GetWrapper(n6).SetMoving(true);
                    ++n6;
                }
            }
        }
    }

    public void CardMouseUp(int n2, int n3) {
        Vector vector = new Vector();
        this.GetMovingCards(vector);
        if (vector.size() > 0) {
            Rectangle rectangle = new Rectangle();
            int n4 = 0;
            int n5 = 0;
            this.GetCardsRect(vector, rectangle);
            CardWrapper cardWrapper = (CardWrapper)vector.get(0);
            for (int i2 = 0; i2 < 16; ++i2) {
                int n6;
                TableCell tableCell = this.Table.GetCell(i2);
                if (tableCell == cardWrapper.GetCell() || (n6 = tableCell.CoverArea(rectangle)) <= n4) continue;
                n4 = n6;
                n5 = i2;
            }
            if (n4 > 25) {
                this.f(cardWrapper.GetCell(), n5);
            }
        }
        super.CardMouseUp(n2, n3);
        this.k();
    }

    public void CleanUp(UndoStep undoStep) {
        boolean bl;
        undoStep.BeginStep(true);
        do {
            Object object;
            int n2;
            int n3 = 13;
            bl = false;
            for (n2 = 4; 13 != 0 && n2 <= 7; ++n2) {
                object = this.Table.GetCell(n2).GetCard(-1);
                if (object == null) {
                    n3 = 0;
                    continue;
                }
                if (((Card)object).GetValue() >= n3) continue;
                n3 = ((Card)object).GetValue();
            }
            n3 += 2;
            block2: for (n2 = 0; n2 < 16; ++n2) {
                if (n2 >= 4 && n2 <= 7 || (object = this.Table.GetCell(n2).GetWrapper(-1)) == null || ((CardWrapper)object).GetCard().GetValue() > n3) continue;
                for (int i2 = 4; i2 <= 7; ++i2) {
                    if (this.e(((CardWrapper)object).GetCell(), i2) <= 0) continue;
                    undoStep.AddMove((CardWrapper)object);
                    this.Table.GetCell(i2).AddCard((CardWrapper)object);
                    bl = true;
                    --this.a;
                    continue block2;
                }
            }
            this.Table.StatusMsg("Cards to move: " + this.a);
        } while (bl);
        undoStep.EndStep();
    }

    private void k() {
        block2: {
            for (int i2 = 4; i2 <= 7; ++i2) {
                Card card = this.Table.GetCell(i2).GetCard(-1);
                if (card != null && card.GetValue() >= 13) {
                    continue;
                }
                break block2;
            }
            this.GameOver(true);
        }
    }

    public void Undo() {
        super.Undo();
        this.a = 52;
        for (int i2 = 4; i2 <= 7; ++i2) {
            this.a -= this.Table.GetCell(i2).GetCardsCount();
        }
        this.Table.StatusMsg("Cards to move: " + this.a);
    }
}

