/**
* Standard precompiler directives for wxWindows applications
*/
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// the application icon (under Windows and OS/2 it is in resources)
#if defined(__WXGTK__) || defined(__WXMOTIF__) || defined(__WXMAC__) || defined(__WXMGL__) || defined(__WXX11__)
    #include "mondrian.xpm"
#endif


/**
* Headers files specifically required for this application
*/
#include "wx/file.h"
#include "wx/filename.h"
#include "wx/progdlg.h"
#include <math.h>

/**
* MyApp
* This class represents the application itself.  All wxWindows applications should
* derive a class from wxApp.
*/
class MyApp : public wxApp {
   public:
      virtual bool OnInit();
};

/**
* MyFrame
* This class represents the main frame for the application.
*/
class MyFrame : public wxFrame {
   public:
      MyFrame(const wxString& title, 
               const wxPoint& pos, 
               const wxSize& size,
               long style = wxDEFAULT_FRAME_STYLE);
      void OnQuit(wxCommandEvent& event);
      void OnInstructions(wxCommandEvent& event);
      void OnAbout(wxCommandEvent& event);
      void OnInputBrowse(wxCommandEvent& event);
      void OnOutputBrowse(wxCommandEvent& event);
      void OnGo(wxCommandEvent& event);
      wxTextCtrl *inputFile;
      wxTextCtrl *outputFile;
      wxTextCtrl *customSize;
      wxRadioButton *floppyRadioButton;
      wxRadioButton *zipRadioButton;
      wxRadioButton *cdrRadioButton;
      wxRadioButton *customRadioButton;
      wxCheckBox *overwriteFiles;
      
   private:
      DECLARE_EVENT_TABLE()
};

/**
* This enum contains ID's for menu items and other controls.
*/
enum {
   Splitter_Quit = 1,
   Splitter_Instructions = 2,
   Splitter_About = wxID_ABOUT,
   Splitter_FloppyRadio = 3,
   Splitter_ZipRadio = 4,
   Splitter_CdrRadio = 5,
   Splitter_CustomRadio = 6,
   Splitter_InputBrowse = 7,
   Splitter_OutputBrowse = 8,
   Splitter_Go = 9
};

/**
* This macro initializes the event handler, mapping events to methods that are
* invoked when the event occurs.
*/
BEGIN_EVENT_TABLE(MyFrame, wxFrame)
   EVT_MENU(Splitter_Quit,  MyFrame::OnQuit)
   EVT_MENU(Splitter_About, MyFrame::OnAbout)
   EVT_MENU(Splitter_Instructions, MyFrame::OnInstructions)
   EVT_BUTTON(Splitter_InputBrowse, MyFrame::OnInputBrowse)    
   EVT_BUTTON(Splitter_OutputBrowse, MyFrame::OnOutputBrowse)    
   EVT_BUTTON(Splitter_Go, MyFrame::OnGo)    
END_EVENT_TABLE()

/**
* This macro is placed before the code implementing a wxWindows application
*/
IMPLEMENT_APP(MyApp)

/**
* MyApp::OnInit
* This method is the equivalent of a "main()"... program execution starts here.  It
* simply instantiates and displays the main window for the application.
*/
bool MyApp::OnInit() {
    MyFrame *frame = new MyFrame(wxString("Steve's File Splitter"),
                                 wxPoint(50, 50), 
                                 wxSize(400, 400),
                                 (wxMINIMIZE_BOX 
                                    | !wxMAXIMIZE_BOX 
                                    | !wxRESIZE_BORDER 
                                    | wxSYSTEM_MENU 
                                    | wxCAPTION));
    frame->Show(TRUE);
    return TRUE;
}

/**
* MyFrame::MyFrame
* This is the constructor for the MyFrame class, which represents the main window
* for the application.  This constructor primarily initializes GUI components.
*/
MyFrame::MyFrame(const wxString& title, 
                  const wxPoint& pos, 
                  const wxSize& size, 
                  long style)
       : wxFrame(NULL, -1, title, pos, size, style) {
   SetIcon(wxICON(icon));
#if wxUSE_MENUS
   wxMenu *menuFile = new wxMenu;
   wxMenu *helpMenu = new wxMenu;
   helpMenu->Append(Splitter_Instructions, 
                     wxString("&Instructions"), 
                     wxString("Show instructions"));
   helpMenu->Append(Splitter_About, 
                     wxString("&About"), 
                     wxString("Show about dialog"));
   menuFile->Append(Splitter_Quit, 
                     wxString("E&xit"), 
                     wxString("Quit this program"));
   wxMenuBar *menuBar = new wxMenuBar();
   menuBar->Append(menuFile, wxString("&File"));
   menuBar->Append(helpMenu, wxString("&Help"));
   SetMenuBar(menuBar);
#endif // wxUSE_MENUS
   wxColour backgroundColour(0, 153, 204);
   wxPanel *mainPanel = new wxPanel(this, -1, wxPoint(-1,-1), wxSize(-1, -1));
   mainPanel->SetBackgroundColour(backgroundColour);
   wxBitmap bitmap = wxBitmap(wxString("logo"), wxBITMAP_TYPE_RESOURCE);
   bitmap.SetMask(new wxMask(bitmap, wxColour(0, 156, 206)));
   (void)new wxStaticBitmap(mainPanel, -1, bitmap, wxPoint(30, 10));
   (void)new wxStaticText(mainPanel,
                           -1,
                           wxString("Number of bytes per chunk:"),
                           wxPoint(20, 100));
   floppyRadioButton = new wxRadioButton(mainPanel, 
                                          Splitter_FloppyRadio, 
                                          wxString("Floppy Disk (1.44MB)"), 
                                          wxPoint(20,120), 
                                          wxDefaultSize, 
                                          wxRB_GROUP);
   floppyRadioButton->SetBackgroundColour(backgroundColour);                                                
   floppyRadioButton->SetValue(TRUE);
   zipRadioButton = new wxRadioButton(mainPanel, 
                                       Splitter_ZipRadio, 
                                       wxString("ZIP Disk (100MB)"), 
                                       wxPoint(20,140), 
                                       wxDefaultSize);
   zipRadioButton->SetBackgroundColour(backgroundColour);                                                
   cdrRadioButton = new wxRadioButton(mainPanel, 
                                       Splitter_CdrRadio, 
                                       wxString("CD-R (650MB)"), 
                                       wxPoint(20,160), 
                                       wxDefaultSize);
   cdrRadioButton->SetBackgroundColour(backgroundColour);                                                
   customRadioButton = new wxRadioButton(mainPanel, 
                                          Splitter_CustomRadio, 
                                          wxString("Custom size (in bytes):"), 
                                          wxPoint(20,180), 
                                          wxDefaultSize);
   customRadioButton->SetBackgroundColour(backgroundColour);     
   customSize = new wxTextCtrl(mainPanel,
                              -1,
                              wxString(""),
                              wxPoint(38,200),
                              wxSize(150, 20));                                              
   (void)new wxStaticText(mainPanel,
                           -1,
                           wxString("File to be split:"),
                           wxPoint(20, 230));
   inputFile = new wxTextCtrl(mainPanel,
                              -1,
                              wxString(""),
                              wxPoint(20,250),
                              wxSize(250, 20));
   (void)new wxButton(mainPanel, 
                        Splitter_InputBrowse, 
                        wxString("Browse"), 
                        wxPoint(300, 250), 
                        wxSize(-1, -1));
   (void)new wxStaticText(mainPanel,
                           -1,
                           wxString("Path and basename for output files:"),
                           wxPoint(20, 290));
   outputFile = new wxTextCtrl(mainPanel,
                                 -1,
                                 wxString(""),
                                 wxPoint(20,310),
                                 wxSize(250, 20));
   overwriteFiles = new wxCheckBox(mainPanel,
                                    -1,
                                    wxString("Overwrite existing files"),
                                    wxPoint(30, 335),
                                    wxSize(-1, -1)); 
   overwriteFiles->SetBackgroundColour(backgroundColour);                                    
   (void)new wxButton(mainPanel, 
                        Splitter_OutputBrowse, 
                        wxString("Browse"), 
                        wxPoint(300, 310), 
                        wxSize(-1, -1));                                          
   (void)new wxButton(mainPanel, 
                        Splitter_Go, 
                        wxString("Go"), 
                        wxPoint(250, 150), 
                        wxSize(-1, -1));
}

/**
* MyFrame::OnQuit
* This method is called by the event handler when the "Quit" menu item is selected.
* It terminates the application.
*/
void MyFrame::OnQuit(wxCommandEvent& WXUNUSED(event)) {
   Close(TRUE);
}

/**
* MyFrame::OnInstructions
* This method is called by the event handler when the "Instructions" menu item is 
* selected.  It brings up a dialog box with instuctions for using the application.
*/
void MyFrame::OnInstructions(wxCommandEvent& WXUNUSED(event)) {
   wxString msg;
   msg.Printf("File Splitter takes a file and splits it up into a number of smaller \"chunks\",\n");
   msg.Append("also creating a small batch file that will automatically rejoin the chunks back\n");
   msg.Append("into the original file's state once transferred to their destination.\n\n");
   msg.Append("Number of bytes per chunk:\n");
   msg.Append("       Select the radio button for a pre-defined file size, or select\n");
   msg.Append("       \"Custom size\" and enter any number of bytes you wish.\n");
   msg.Append("File to be split:\n");
   msg.Append("       Type in the path and filename for the file you would like to split,\n");
   msg.Append("       or use the \"Browse\" button\n");
   msg.Append("Path and basename for destination files:\n");
   msg.Append("       File Splitter will create file chunks with a basename you select plus an\n");
   msg.Append("       extention number (i.e. if you select \"C:\\windows\\desktop\\output\" for\n");
   msg.Append("       the basename and there are three chunks created, they will be named\n");
   msg.Append("       \"output.1\",\"output.2\", \"output.3\" and placed on the Desktop).  Type in\n");
   msg.Append("       the path and basename you would like to use... or click the \"Browse\"\n");
   msg.Append("       button and type in the basename, after browsing to the desired directory.\n");
   msg.Append("       If the \"Overwrite existing files\" box is not checked, then File Splitter\n");
   msg.Append("       will fail if there is an existing file with the same name as a chunk to be\n");
   msg.Append("       created\n\n");
   msg.Append("When you have finished splitting your file, copy the chunks to their destination\n");
   msg.Append("through whatever medium you are using (disks, network, etc).  In addition to\n");
   msg.Append("chunks, File Splitter creates a batch file in the format \"REJOIN-<original filename>.bat\".\n");
   msg.Append("Copy this file to the same directory on the destination where the chunks have been\n");
   msg.Append("copied, and run the batch file (in Windows, just double-click on it) to recreate \n");
   msg.Append("the original file.  After you're done, you may safely delete the chunks and the \n");
   msg.Append("batch file.");
   wxMessageBox(msg, wxString("Instructions"), wxOK | wxICON_INFORMATION, this);
}

/**
* MyFrame::OnAbout
* This method is called by the event handler when the "About" menu item is selected.
* It brings up the "About" dialog box.
*/
void MyFrame::OnAbout(wxCommandEvent& WXUNUSED(event)) {
   wxString msg;
   msg.Printf("File Splitter, Version 2.0\n");
   msg.Append("Copyright 2003, Steve D. Perkins\n");
   msg.Append("steve@steveperkins.net\n");
   msg.Append("www.steveperkins.net\n\n");
   msg.Append("This software is distributed under the terms\n");
   msg.Append("of the GNU General Public License (GPL)");
   wxMessageBox(msg, wxString("About"), wxOK | wxICON_INFORMATION, this);
}

/**
* MyFrame::OnInputBrowse
* This method is called by the event handler when the "Browse" button beside the 
* input file text field is pressed.  It triggers a file dialog that populates the
* input file text field.
*/
void MyFrame::OnInputBrowse(wxCommandEvent& WXUNUSED(event)) {
   wxFileDialog *inputFileDialog = new wxFileDialog(this,
                                             wxString("Choose the file to be split..."));
   if (inputFileDialog->ShowModal() == wxID_OK) {  
      inputFile->SetValue(inputFileDialog->GetPath());   
   }
}

/**
* MyFrame::OnOutputBrowse
* This method is called by the event handler when the "Browse" button beside the 
* output file text field is pressed.  It triggers a file dialog that populates the
* output file text field.
*/
void MyFrame::OnOutputBrowse(wxCommandEvent& WXUNUSED(event)) {
   wxFileDialog *outputFileDialog = new wxFileDialog(this,
                                             wxString("Choose the path and basename..."));
   if (outputFileDialog->ShowModal() == wxID_OK) {  
      outputFile->SetValue(outputFileDialog->GetPath());   
   }
}

/**
* MyFrame::OnGo
* This method is called by the event handler when the "Go" button is pressed.  It 
* performs the actual split operation.
*/
void MyFrame::OnGo(wxCommandEvent& WXUNUSED(event)) {
   // VALIDATE THAT INPUT FILE EXISTS AND THAT CUSTOM CHUNK SIZE (IF USED) IS VALID NUMBER
   if(customRadioButton->GetValue() == TRUE && customSize->GetValue() == "") {
      wxMessageBox(
               wxString("Error:  You chose to use a Custom Size, but did not provide a number of bytes!\n"),
               wxString("Error"), 
               wxOK | wxICON_INFORMATION, this);
      return;
   }
   if(!wxFile::Exists(inputFile->GetValue())) {
      wxMessageBox(
               wxString("Error:  Could not find the input file!\n"),
               wxString("Error"), 
               wxOK | wxICON_INFORMATION, this);
      return;
   }
   // DETERMINE THE CHUNK SIZE TO USE
   long chunkSize;
   if(floppyRadioButton->GetValue() == TRUE) {
      chunkSize = 1440000;
   } else if(zipRadioButton->GetValue() == TRUE) {
      chunkSize = 100000000;
   } else if(cdrRadioButton->GetValue() == TRUE) {
      chunkSize = 650000000;
   } else if(customRadioButton->GetValue() == TRUE) {
      if(customSize->GetValue().ToLong(&chunkSize) == FALSE) {
         wxMessageBox(wxString("Error: The custom size selected cannot be recognized as a number!"), 
                        wxString("Error"), 
                        wxOK | wxICON_INFORMATION, this);
         return;
      }         
   }
   // INITIALIZE FILENAME INFORMATION AND OPEN INPUT FILE
   wxFileName inputFileName(inputFile->GetValue());
   wxFile inputFileHandle;
   inputFileHandle.Open(inputFileName.GetFullPath());
   wxFileName rejoinFileName(outputFile->GetValue().GetData());
   rejoinFileName.SetName(wxString("REJOIN-") + inputFileName.GetFullName() + wxString(".bat"));
   // DETERMINE NUMBER OF CHUNKS, OPEN PROGRESS DIALOG, INITIALIZE TEXT TO GO IN 
   // REJOIN BATCH FILE, AND START LOOPING THROUGH CHUNKS
   long inputFileSize = inputFileHandle.Length();
   long numberOfChunks = (long)ceil((float)inputFileSize / (float)chunkSize);
   wxString rejoinBatchText("copy /b ");
   wxProgressDialog progress(wxString("Progress"),
                              wxString("Splitting your file"),
                              100);
   for(int index = 0; index < numberOfChunks; index++) {
      // UPDATE PROGRESS DIALOG
      if(index > 0) {
         wxString newMessage;
         newMessage.Printf("%d of %d chunks created", (int)index, (int)numberOfChunks);
         progress.Update(index * 100 / numberOfChunks, newMessage);
         rejoinBatchText.append("+");
      }
      // READ IN BYTES FROM THE INPUT FILE
      char bytesBuffer[chunkSize];
      long actualBytesRead = inputFileHandle.Read(bytesBuffer, chunkSize);
      // INITIALIZE OUTPUT FILE AND ADD ITS NAME TO THE REJOIN BATCH FILE TEXT
      wxString outputFileString;
      outputFileString.Printf("%s.%d", outputFile->GetValue().GetData(), index + 1);
      wxFileName outputFileName(outputFileString);
      rejoinBatchText.append("\"" + outputFileName.GetFullName() + "\"");
      wxFile outputFileHandle;
      // VALIDATE THAT OUTPUT FILE IS SUCESSFULLY CREATED
      if(outputFileHandle.Create(outputFileName.GetFullPath(), overwriteFiles->GetValue()) == FALSE) {
         wxString error;
         error.Printf("Error opening output file " + outputFileString);
         if(overwriteFiles->GetValue() == FALSE) {
            error.Append("\n\nIf the file already exists, check the \"Overwrite existing files\" box");
         }
         wxMessageBox(error, 
                        wxString("Error"), 
                        wxOK | wxICON_INFORMATION, this);
         return;
      }
      // WRITE BYTES TO OUTPUT CHUNK
      outputFileHandle.Write(bytesBuffer, actualBytesRead);
      outputFileHandle.Close();
   }
   inputFileHandle.Close();
   // WRITE REJOIN BATCH FILE
   rejoinBatchText.Append(" \"" + inputFileName.GetFullName() + "\"");
   wxFile rejoinFileHandle(rejoinFileName.GetFullPath(), wxFile::write);
   rejoinFileHandle.Write(rejoinBatchText);
   rejoinFileHandle.Close();
   wxMessageBox(wxString("Your file has been split!"), 
                  wxString("Complete"), 
                  wxOK | wxICON_INFORMATION, this);
}
