
; parameters

ParamSize    equ 0 ;  <parameter name size>
PParam       equ 2 ;  <pointer to parameter name>
ValueSize    equ 6 ;  <parameter value size>
PValue       equ 8 ;  <pointer to parameter value>

; available functions

_StrToOem     equ 0Ch ; Procedure StrToOem(Src,Dst:Pointer;Count:Word);Far;
_OemToStr     equ 10h ; Procedure OemToStr(Src,Dst:Pointer;Count:Word);Far;
_OemLow       equ 14h ; Procedure OemLow(Src,Dst:Pointer;Count:Word);Far;
_OemUp        equ 18h ; Procedure OemUp(Src,Dst:Pointer;Count:Word);Far;
_StrToUnicode equ 1Ch ; Procedure StrToUnicode(Src,Dst:Pointer;Count:Word);Far;
_UnicodeToStr equ 20h ; Procedure UnicodeToStr(Src,Dst:Pointer;Count:Word);Far;
_MessageBox   equ 24h ; Function MessageBox(Title,Message:String):Pointer;Far;
_Warning      equ 28h ; Function Warning(Message:String;keys:string):Word;Far;
_ScrSave      equ 2Ch ; Function ScrSave(x1,y1,x2,y2:Word):Pointer;Far;
_ScrRest      equ 30h ; Procedure ScrRest(Screen:Pointer);Far;
_GetKey       equ 34h ; Function GetKey:Word;Far;
_GetShiftKey  equ 38h ; Function GetShiftKey:Word;Far;
_KeyPressed   equ 3Ch ; Function KeyPressed:Boolean;Far;

StartUp macro
        mov  ax,ds
        push cs
        pop  ds
        mov  SaveDS,ax                  ; save DS of main program
Endm

pushe macro reg
;       push eReg
        db   66h
        push reg
Endm

pope macro reg
;       pop  eReg
        db   66h
        pop  reg
Endm

RestoreDS macro
        push SaveDS
        pop  ds
Endm

GetParamAddr macro
        les  bp,ParamAddr
Endm

StabileRegisters macro
        push cs
        pop  ds
        GetParamAddr
        RestoreDS
Endm

StrToOem macro
        call dword ptr es:[bp][_StrToOem]
Endm

OemToStr macro
        call dword ptr es:[bp][_OemToStr]
Endm

OemLow macro
        call dword ptr es:[bp][_OemLow]
Endm

OemUp macro
        call dword ptr es:[bp][_OemUp]
Endm

StrToUnicode macro
        call dword ptr es:[bp][_StrToUnicode]
Endm

UnicodeToStr macro
        call dword ptr es:[bp][_UnicodeToStr]
Endm

MessageBox macro
        call dword ptr es:[bp][_MessageBox]
Endm

Warning macro
        call dword ptr es:[bp][_Warning]
Endm

ScrSave macro
        call dword ptr es:[bp][_ScrSave]
Endm

ScrRest macro
        call dword ptr es:[bp][_ScrRest]
Endm

GetKey macro
        call dword ptr es:[bp][_GetKey]
Endm

GetShiftKey macro
        call dword ptr es:[bp][_GetShiftKey]
Endm

KeyPressed macro
        call dword ptr es:[bp][_KeyPressed]
Endm
