/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.bean.multiplayer;

import com.ibm.media.bean.multiplayer.DTMsgBox;
import com.ibm.media.bean.multiplayer.JMFUtil;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.Serializable;

public class LinksArrayEditor
extends PropertyEditorSupport
implements PropertyEditor,
Serializable,
ActionListener,
ItemListener {
    PropertyChangeSupport support = new PropertyChangeSupport(this);
    Panel linksPanel = new Panel();
    transient String[] oldValue;
    transient String[] newValue;
    List mediaGroup = new List(5);
    List related = new List(5);
    List start = new List(5);
    List stop = new List(5);
    TextField relatedField = new TextField(20);
    TextField startField = new TextField(3);
    TextField stopField = new TextField(3);
    TextField mediaNumField = new TextField(3);
    Button addLink = new Button(JMFUtil.getBIString("ADD"));
    Button delLink = new Button(JMFUtil.getBIString("DELETE"));
    Label mediaLabel = new Label(JMFUtil.getBIString("MEDIA_GROUP"));
    Label linkLabel = new Label(JMFUtil.getBIString("RELATED_LINK_URL"));
    Label startLabel = new Label(JMFUtil.getBIString("START_TIME"));
    Label stopLabel = new Label(JMFUtil.getBIString("STOP_TIME"));
    Panel pan = null;
    String addLinkC = "addLink";
    String delLinkC = "delLink";

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(this.addLinkC)) {
            this.processAdd();
        } else if (actionEvent.getActionCommand().equals(this.delLinkC)) {
            this.deleteLink();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public Panel createGuiPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.linksPanel.setLayout(gridBagLayout);
        this.linksPanel.setBackground(Color.lightGray);
        this.linksPanel.setForeground(Color.black);
        this.delLink.setEnabled(false);
        this.linksPanel.setLayout(gridBagLayout);
        this.refreshLists();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.linksPanel.add((Component)this.mediaLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.linksPanel.add((Component)this.linkLabel, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.linksPanel.add((Component)this.startLabel, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.linksPanel.add((Component)this.stopLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.mediaGroup.addItemListener(this);
        this.linksPanel.add((Component)this.mediaGroup, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.related.addItemListener(this);
        this.linksPanel.add((Component)this.related, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.start.addItemListener(this);
        this.linksPanel.add((Component)this.start, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.stop.addItemListener(this);
        this.linksPanel.add((Component)this.stop, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.linksPanel.add((Component)this.mediaNumField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.linksPanel.add((Component)new Label("http://"), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        this.linksPanel.add((Component)this.relatedField, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.linksPanel.add((Component)this.startField, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.linksPanel.add((Component)this.stopField, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addLink.addActionListener(this);
        this.addLink.setActionCommand(this.addLinkC);
        this.linksPanel.add((Component)this.addLink, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.delLink.addActionListener(this);
        this.delLink.setActionCommand(this.delLinkC);
        this.linksPanel.add((Component)this.delLink, gridBagConstraints);
        return this.linksPanel;
    }

    private void deleteLink() {
        String[] stringArray = null;
        int n = this.mediaGroup.getSelectedIndex();
        int n2 = n * 4;
        int n3 = 0;
        if (this.newValue != null && (n3 = this.newValue.length - 4) > 4) {
            stringArray = new String[n3];
            JMFUtil.copyShortenStringArray(this.newValue, stringArray, n2, 4);
        }
        this.mediaGroup.remove(n);
        this.related.remove(n);
        this.start.remove(n);
        this.stop.remove(n);
        this.delLink.setEnabled(false);
        this.setValue(stringArray);
    }

    private boolean duplicate(String string, String string2, String string3, String string4) {
        int n = 0;
        while (n < this.mediaGroup.getItemCount()) {
            if (string.equals(this.mediaGroup.getItem(n)) & string2.equals(this.related.getItem(n)) & string3.equals(this.start.getItem(n)) & string4.equals(this.stop.getItem(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getAsText() {
        return JMFUtil.parseArrayIntoString(this.newValue);
    }

    public Component getCustomEditor() {
        if (this.pan == null) {
            this.pan = this.createGuiPanel();
        }
        return this.pan;
    }

    public String getJavaInitializationString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.newValue == null) {
            return "null";
        }
        stringBuffer = new StringBuffer("new String[] {\"");
        int n = 0;
        while (n < this.newValue.length) {
            stringBuffer.append(JMFUtil.convertString(this.newValue[n]));
            if (n + 1 != this.newValue.length) {
                stringBuffer.append("\",\"");
            }
            ++n;
        }
        stringBuffer.append("\"}");
        return stringBuffer.toString();
    }

    public Object getValue() {
        return this.newValue;
    }

    public boolean isPaintable() {
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable instanceof List) {
            List list = (List)itemSelectable;
            int n = (Integer)itemEvent.getItem();
            int n2 = itemEvent.getStateChange();
            if (list == this.related || list == this.start || list == this.stop || list == this.mediaGroup) {
                list = this.related;
                List list2 = this.start;
                List list3 = this.stop;
                List list4 = this.mediaGroup;
                if (n2 == 1) {
                    list.select(n);
                    list2.select(n);
                    list3.select(n);
                    list4.select(n);
                    this.delLink.setEnabled(true);
                } else if (n2 == 2) {
                    list.deselect(n);
                    list2.deselect(n);
                    list3.deselect(n);
                    list4.deselect(n);
                    this.delLink.setEnabled(false);
                }
            }
        }
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.black);
        graphics.draw3DRect(1, 1, rectangle.width - 2, rectangle.height - 2, true);
        graphics.setColor(Color.black);
        graphics.setFont(new Font("Helevetica", 1, 9));
        graphics.drawString(this.getAsText(), 5, rectangle.height / 2 + 5);
    }

    private void processAdd() {
        int n;
        long l;
        long l2;
        StringBuffer stringBuffer = new StringBuffer("http://");
        String string = this.mediaNumField.getText();
        String string2 = this.relatedField.getText();
        String string3 = this.startField.getText();
        String string4 = this.stopField.getText();
        if (string3.equals("") && string4.equals("")) {
            string3 = new String("0");
            string4 = new String("0");
        }
        if (string.equals("") || string2.equals("") || string3.equals("") || string4.equals("")) {
            DTMsgBox.createAndGo(JMFUtil.getBIString("JMF_MultiPlayer"), JMFUtil.getBIString("NOVALUE"));
            return;
        }
        try {
            l2 = Long.parseLong(string3);
            l = Long.parseLong(string4);
        }
        catch (NumberFormatException numberFormatException) {
            DTMsgBox.createAndGo(JMFUtil.getBIString("JMF_MultiPlayer"), String.valueOf(JMFUtil.getBIString("TIMES")) + ": " + JMFUtil.getBIString("0orGreater"));
            return;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            DTMsgBox.createAndGo(JMFUtil.getBIString("JMF_MultiPlayer"), String.valueOf(JMFUtil.getBIString("INDEX")) + ": " + JMFUtil.getBIString("1orGreater"));
            return;
        }
        if (l2 < 0L || l < 0L) {
            DTMsgBox.createAndGo(JMFUtil.getBIString("JMF_MultiPlayer"), String.valueOf(JMFUtil.getBIString("TIMES")) + ": " + JMFUtil.getBIString("0orGreater"));
            return;
        }
        if (n < 1) {
            DTMsgBox.createAndGo(JMFUtil.getBIString("JMF_MultiPlayer"), String.valueOf(JMFUtil.getBIString("INDEX")) + ": " + JMFUtil.getBIString("1orGreater"));
            return;
        }
        stringBuffer.append(string2);
        if (this.duplicate(string, stringBuffer.toString(), string3, string4)) {
            DTMsgBox.createAndGo(JMFUtil.getBIString("JMF_MultiPlayer"), JMFUtil.getBIString("DUPLICATE_LINK"));
            return;
        }
        int n2 = 0;
        if (this.newValue != null) {
            n2 = this.newValue.length;
        }
        String[] stringArray = new String[n2 + 4];
        JMFUtil.copyStringArray(this.newValue, stringArray);
        stringArray[n2] = string;
        stringArray[n2 + 1] = stringBuffer.toString();
        stringArray[n2 + 2] = string3;
        stringArray[n2 + 3] = string4;
        this.mediaGroup.add(stringArray[n2]);
        this.related.add(stringArray[n2 + 1]);
        this.start.add(stringArray[n2 + 2]);
        this.stop.add(stringArray[n2 + 3]);
        this.mediaNumField.setText("");
        this.relatedField.setText("");
        this.startField.setText("");
        this.stopField.setText("");
        this.setValue(stringArray);
    }

    private void refreshLists() {
        this.mediaGroup.removeAll();
        this.related.removeAll();
        this.start.removeAll();
        this.stop.removeAll();
        if (this.newValue != null) {
            int n = 0;
            while (n < this.newValue.length) {
                this.mediaGroup.add(this.newValue[n]);
                this.related.add(this.newValue[n + 1]);
                this.start.add(this.newValue[n + 2]);
                this.stop.add(this.newValue[n + 3]);
                n += 4;
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAsText(String string) {
        this.setValue(JMFUtil.parseStringIntoArray(string));
    }

    public void setValue(Object object) {
        this.oldValue = this.newValue;
        this.newValue = object instanceof String ? JMFUtil.parseStringIntoArray((String)object) : (String[])object;
        this.firePropertyChange();
        this.support.firePropertyChange("links", null, this.newValue);
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

