/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.bean.multiplayer;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ImageLabel
extends Canvas {
    protected Image image;
    protected static String defaultImageString = null;
    private String imageString = "<Existing Image>";
    private boolean debug = false;
    protected int border = 0;
    protected Color borderColor = null;
    protected int width = 80;
    protected int height = 60;
    protected boolean explicitSize = false;
    private int explicitWidth = 0;
    private int explicitHeight = 0;
    private MediaTracker tracker;
    private static int lastTrackerID = 0;
    private int currentTrackerID;
    protected boolean doneLoading = false;
    private Container parentContainer;
    boolean newEventsOnly = false;

    public ImageLabel() {
    }

    public ImageLabel(Image image) {
        this.image = image;
        this.tracker = new MediaTracker(this);
        this.currentTrackerID = lastTrackerID++;
        this.tracker.addImage(image, this.currentTrackerID);
    }

    public ImageLabel(String string) {
        this(ImageLabel.makeURL(string));
    }

    public ImageLabel(URL uRL) {
        this(ImageLabel.loadImage(uRL));
        this.imageString = uRL.toExternalForm();
    }

    public ImageLabel(URL uRL, String string) {
        this(ImageLabel.makeURL(uRL, string));
        this.imageString = string;
    }

    public void centerAt(int n, int n2) {
        this.debug("Placing center of " + this.imageString + " at (" + n + "," + n2 + ")");
        this.move(n - this.width / 2, n2 - this.height / 2);
    }

    protected void debug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    protected void drawRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color) {
        graphics.setColor(color);
        int n6 = 0;
        while (n6 < n5) {
            graphics.drawRect(n, n2, n3, n4);
            if (n6 < n5 - 1) {
                ++n;
                ++n2;
                n3 -= 2;
                n4 -= 2;
            }
            ++n6;
        }
    }

    public int getBorder() {
        return this.border;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public static String getDefaultImageString() {
        return defaultImageString;
    }

    public int getHeight() {
        return this.height;
    }

    public Image getImage() {
        return this.image;
    }

    protected String getImageString() {
        return this.imageString;
    }

    public int getWidth() {
        return this.width;
    }

    protected boolean hasExplicitSize() {
        return this.explicitSize;
    }

    public synchronized boolean inside(int n, int n2) {
        return n >= 0 && n <= this.width && n2 >= 0 && n2 <= this.height;
    }

    public boolean isDebugging() {
        return this.debug;
    }

    private static Image loadImage(URL uRL) {
        Image image = null;
        if (uRL.getProtocol().equals("file")) {
            try {
                InputStream inputStream = uRL.openStream();
                if (inputStream == null) {
                    System.out.println("null button image stream");
                    return null;
                }
                int n = 0;
                while (inputStream.available() == 0) {
                }
                n = inputStream.available();
                byte[] byArray = new byte[n];
                inputStream.read(byArray);
                image = Toolkit.getDefaultToolkit().createImage(byArray);
            }
            catch (IOException iOException) {
                System.out.println("Cannot read button image.");
                return null;
            }
        } else {
            image = Toolkit.getDefaultToolkit().getImage(uRL);
        }
        return image;
    }

    private static URL makeURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Bad URL " + string + ": " + malformedURLException);
            malformedURLException.printStackTrace();
        }
        return uRL;
    }

    private static URL makeURL(URL uRL, String string) {
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Bad URL " + uRL.toExternalForm() + ", " + string + ": " + malformedURLException);
            malformedURLException.printStackTrace();
        }
        return uRL2;
    }

    public Dimension minimumSize() {
        if (!this.doneLoading) {
            this.waitForImage(false);
        }
        return super.minimumSize();
    }

    public void paint(Graphics graphics) {
        if (!this.doneLoading) {
            this.waitForImage(true);
        } else {
            if (this.explicitSize) {
                graphics.drawImage(this.image, this.border, this.border, this.width - 2 * this.border, this.height - 2 * this.border, this);
            } else {
                graphics.drawImage(this.image, this.border, this.border, this);
            }
            this.drawRect(graphics, 0, 0, this.width - 1, this.height - 1, this.border, this.borderColor);
        }
    }

    public Dimension preferredSize() {
        if (!this.doneLoading) {
            this.waitForImage(false);
        }
        return super.preferredSize();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            if (n3 > 0) {
                this.explicitWidth = n3;
            }
            if (n4 > 0) {
                this.explicitHeight = n4;
            }
        }
        super.reshape(n, n2, n3, n4);
    }

    public void resize(int n, int n2) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            if (n > 0) {
                this.explicitWidth = n;
            }
            if (n2 > 0) {
                this.explicitHeight = n2;
            }
        }
        super.resize(n, n2);
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public static void setDefaultImageString(String string) {
        defaultImageString = string;
    }

    public void setIsDebugging(boolean bl) {
        this.debug = bl;
    }

    public void waitForImage(boolean bl) {
        if (!this.doneLoading) {
            this.debug("[waitForImage] - Resizing and waiting for " + this.imageString);
            try {
                this.tracker.waitForID(this.currentTrackerID);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                System.out.println("Error loading " + this.imageString + ": " + exception.getMessage());
                exception.printStackTrace();
            }
            if (this.tracker.isErrorID(0)) {
                new Throwable("Error loading image " + this.imageString).printStackTrace();
            }
            this.doneLoading = true;
            this.width = this.explicitWidth != 0 ? this.explicitWidth : this.image.getWidth(this) + 2 * this.border;
            this.height = this.explicitHeight != 0 ? this.explicitHeight : this.image.getHeight(this) + 2 * this.border;
            this.resize(this.width, this.height);
            this.debug("[waitForImage] - " + this.imageString + " is " + this.width + "x" + this.height + ".");
            this.parentContainer = this.getParent();
            if (this.parentContainer != null && bl) {
                this.setBackground(this.parentContainer.getBackground());
                this.parentContainer.layout();
            }
        }
    }
}

