/*
 * Decompiled with CFR 0.152.
 */
package se.bysoft.sureshot.products.jplayer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.bysoft.sureshot.debug.Assertion;
import se.bysoft.sureshot.gui.util.GuiHelper;
import se.bysoft.sureshot.gui.util.ImagePanel;
import se.bysoft.sureshot.gui.util.Updatable;
import se.bysoft.sureshot.gui.util.UpdateCaller;
import se.bysoft.sureshot.products.jplayer.JPlayer;
import se.bysoft.sureshot.util.SystemExit;
import se.bysoft.sureshot.util.image.ImageLoader;
import se.bysoft.sureshot.util.image.ImageLoaderImpl;
import se.bysoft.sureshot.util.reporter.MessageBoxReporter;
import se.bysoft.sureshot.util.reporter.Reporter;
import se.bysoft.sureshot.util.time.TimeHelper;

public class JPlayerView
implements Observer,
Updatable {
    private final ImageLoader _imageLoader = new ImageLoaderImpl();
    private final JFrame _mainFrame = new JFrame();
    private final Reporter _reporter = new MessageBoxReporter(this._mainFrame, "JPlayer error...");
    private final JPlayer _model = new JPlayer(this._reporter);
    private final JLabel _infoLabel = new JLabel("JPlayer");
    private final JLabel _timeLabel = new JLabel("00:00");
    private Icon _playIcon;
    private Icon _playOverIcon;
    private Icon _playPressedIcon;
    private JButton _playButton;
    private Icon _stopIcon;
    private Icon _stopOverIcon;
    private Icon _stopPressedIcon;
    private JButton _stopButton;
    private Icon _pauseIcon;
    private Icon _pauseOverIcon;
    private Icon _pausePressedIcon;
    private JButton _pauseButton;
    private final JList _tunesList = new JList(this._model.getListModel());
    private final JMenuItem _aboutItem = new JMenuItem("About", 65);
    private final JMenuItem _openItem = new JMenuItem("Open Files ...", 79);
    private final JMenuItem _exitItem = new JMenuItem("Exit", 120);
    private final JMenu _fileMenu = new JMenu("File");
    private final JMenu _helpMenu = new JMenu("Help");
    private final JMenuBar _menuBar = new JMenuBar();

    public JPlayerView(boolean bl) {
        try {
            this._playIcon = new ImageIcon(this._imageLoader.load(bl ? "E:\\products\\jplayer\\graphics\\play.gif" : "/graphics/play.gif"));
            this._playOverIcon = new ImageIcon(this._imageLoader.load(bl ? "E:\\products\\jplayer\\graphics\\play_over.gif" : "/graphics/play_over.gif"));
            this._playPressedIcon = new ImageIcon(this._imageLoader.load(bl ? "E:\\products\\jplayer\\graphics\\play_pressed.gif" : "/graphics/play_pressed.gif"));
            this._playButton = new JButton(this._playIcon);
            this._stopIcon = new ImageIcon(this._imageLoader.load(bl ? "E:\\products\\jplayer\\graphics\\stop.gif" : "/graphics/stop.gif"));
            this._stopOverIcon = new ImageIcon(this._imageLoader.load(bl ? "E:\\products\\jplayer\\graphics\\stop_over.gif" : "/graphics/stop_over.gif"));
            this._stopPressedIcon = new ImageIcon(this._imageLoader.load(bl ? "E:\\products\\jplayer\\graphics\\stop_pressed.gif" : "/graphics/stop_pressed.gif"));
            this._stopButton = new JButton(this._stopIcon);
            this._pauseIcon = new ImageIcon(this._imageLoader.load(bl ? "E:\\products\\jplayer\\graphics\\pause.gif" : "/graphics/pause.gif"));
            this._pauseOverIcon = new ImageIcon(this._imageLoader.load(bl ? "E:\\products\\jplayer\\graphics\\pause_over.gif" : "/graphics/pause_over.gif"));
            this._pausePressedIcon = new ImageIcon(this._imageLoader.load(bl ? "E:\\products\\jplayer\\graphics\\pause_pressed.gif" : "/graphics/pause_pressed.gif"));
            this._pauseButton = new JButton(this._pauseIcon);
            Font font = new Font("Helvetica", 1, 10);
            Font font2 = new Font("Helvetica", 1, 16);
            this._model.addObserver(this);
            InfoView infoView = new InfoView(this._model.getPlayerModel());
            Image image = this._imageLoader.load(bl ? "E:\\products\\jplayer\\graphics\\mainframe_icon.gif" : "/graphics/mainframe_icon.gif");
            ((Frame)this._mainFrame).setIconImage(image);
            this._mainFrame.setDefaultCloseOperation(3);
            this._mainFrame.setResizable(false);
            this._mainFrame.setTitle("JPlayer");
            MenuListener menuListener = new MenuListener();
            this._openItem.addActionListener(menuListener);
            this._exitItem.addActionListener(menuListener);
            this._aboutItem.addActionListener(menuListener);
            this._fileMenu.add(this._openItem);
            this._fileMenu.add(this._exitItem);
            this._helpMenu.add(this._aboutItem);
            this._menuBar.add(this._fileMenu);
            this._menuBar.add(this._helpMenu);
            this._mainFrame.setJMenuBar(this._menuBar);
            ImagePanel imagePanel = new ImagePanel(bl ? "E:\\products\\jplayer\\graphics\\background.gif" : "/graphics/background.gif", this._imageLoader);
            imagePanel.setLayout(null);
            JPanel jPanel = new JPanel();
            this._playButton.setRolloverIcon(this._playOverIcon);
            this._playButton.setPressedIcon(this._playPressedIcon);
            this._playButton.setBorder(null);
            this._playButton.setOpaque(false);
            this._stopButton.setRolloverIcon(this._stopOverIcon);
            this._stopButton.setPressedIcon(this._stopPressedIcon);
            this._stopButton.setBorder(null);
            this._stopButton.setOpaque(false);
            this._pauseButton.setRolloverIcon(this._pauseOverIcon);
            this._pauseButton.setPressedIcon(this._pausePressedIcon);
            this._pauseButton.setBorder(null);
            this._pauseButton.setOpaque(false);
            this._infoLabel.setForeground(Color.white);
            this._infoLabel.setFont(font);
            this._timeLabel.setForeground(Color.white);
            this._timeLabel.setFont(font2);
            imagePanel.add(this._playButton);
            imagePanel.add(this._stopButton);
            imagePanel.add(this._pauseButton);
            imagePanel.add(this._infoLabel);
            imagePanel.add(this._timeLabel);
            JScrollPane jScrollPane = new JScrollPane(this._tunesList, 20, 30);
            imagePanel.add(jScrollPane);
            JSlider jSlider = new JSlider(this._model.getSliderModel());
            jSlider.setOpaque(false);
            imagePanel.add(jSlider);
            this._infoLabel.setBounds(190, 25, 160, 30);
            this._timeLabel.setBounds(190, 55, 160, 30);
            this._playButton.setBounds(30, 25, 45, 45);
            this._pauseButton.setBounds(30, 25, 45, 45);
            this._stopButton.setBounds(75, 25, 45, 45);
            this._tunesList.setBackground(Color.black);
            this._tunesList.setForeground(Color.white);
            this._tunesList.setBorder(null);
            this._tunesList.setFont(new Font("Helvetica", 1, 10));
            jScrollPane.setBounds(32, 112, 335, 346);
            jScrollPane.setBorder(null);
            jSlider.setBounds(30, 75, 130, 30);
            jSlider.addChangeListener(new SliderListener());
            this._tunesList.setDropTarget(new DropTarget(jScrollPane, new ListDropTarget(this._model.getListModel())));
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        int n = JPlayerView.this._tunesList.locationToIndex(mouseEvent.getPoint());
                        JPlayerView.this._model.play(n);
                    }
                }
            };
            this._tunesList.addMouseListener(mouseAdapter);
            KeyListener keyListener = new KeyListener();
            this._tunesList.addKeyListener(keyListener);
            ButtonListener buttonListener = new ButtonListener();
            this._playButton.addActionListener(buttonListener);
            this._stopButton.addActionListener(buttonListener);
            this._pauseButton.addActionListener(buttonListener);
            this.update(this._model, null);
            this._mainFrame.getContentPane().add((Component)imagePanel, "Center");
            this._mainFrame.pack();
            GuiHelper.center(this._mainFrame);
            ((Component)this._mainFrame).setVisible(true);
        }
        catch (Exception exception) {
            String string = "Error starting JPlayer. " + exception.getMessage();
            this._reporter.reportError(string);
            exception.printStackTrace();
            SystemExit.exit(-1);
        }
    }

    public void update(Observable observable, Object object) {
        SwingUtilities.invokeLater(new UpdateCaller(this));
    }

    public void updateView() {
        if (this._model.getState() == JPlayer.State.STOPPED) {
            this._playButton.setVisible(true);
            this._pauseButton.setVisible(false);
        } else if (this._model.getState() == JPlayer.State.PLAYING) {
            this._pauseButton.setVisible(true);
            this._playButton.setVisible(false);
        } else if (this._model.getState() == JPlayer.State.PAUSED) {
            this._playButton.setVisible(true);
            this._pauseButton.setVisible(false);
        } else if (this._model.getState() == JPlayer.State.NOTHING_TO_PLAY) {
            File[] fileArray;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setMultiSelectionEnabled(true);
            int n = jFileChooser.showOpenDialog(this._mainFrame);
            if (n == 0 && (fileArray = jFileChooser.getSelectedFiles()).length > 0) {
                this._model.getListModel().clear();
                this._model.getListModel().addAll(fileArray);
                this._model.play(0);
            }
        } else {
            Assertion.assertion(false);
        }
    }

    public static void main(String[] stringArray) {
        new JPlayerView(false);
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class InfoView
    implements Observer,
    Updatable {
        private final JPlayer.PlayerModel _playerModel;

        public InfoView(JPlayer.PlayerModel playerModel) {
            this._playerModel = playerModel;
            this._playerModel.addObserver(this);
        }

        public void update(Observable observable, Object object) {
            SwingUtilities.invokeLater(new UpdateCaller(this));
        }

        public void updateView() {
            int n = (int)this._playerModel.value.getMediaTime().getSeconds();
            String string = new File(this._playerModel.getCurrentUrl().getFile()).getName();
            JPlayerView.this._timeLabel.setText(TimeHelper.getMMSS(n));
            JPlayerView.this._infoLabel.setText(string);
        }
    }

    private class MenuListener
    implements ActionListener {
        private MenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == JPlayerView.this._exitItem) {
                SystemExit.exit(0);
            } else if (object == JPlayerView.this._aboutItem) {
                JOptionPane.showMessageDialog(JPlayerView.this._mainFrame, "JPlayer v1.00\nCopyright Sureshot\n\nPlease visit JPlayer's homepage:\nhttp://www.bysoft.se/sureshot/jplayer/", "About JPlayer", 1);
            } else if (object == JPlayerView.this._openItem) {
                JPlayerView.this._model.nothingToPlay();
            } else {
                Assertion.assertion(false);
            }
        }
    }

    class SliderListener
    implements ChangeListener {
        private boolean adjustedLastTime = false;

        SliderListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (!jSlider.getValueIsAdjusting() && this.adjustedLastTime) {
                int n = jSlider.getValue();
                this.adjustedLastTime = jSlider.getValueIsAdjusting();
                JPlayerView.this._model.getSliderModel().sliderAdjusted(n);
            }
            this.adjustedLastTime = jSlider.getValueIsAdjusting();
        }
    }

    public class KeyListener
    extends KeyAdapter {
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 127) {
                int[] nArray = JPlayerView.this._tunesList.getSelectedIndices();
                JPlayerView.this._model.getListModel().remove(nArray);
            }
        }
    }

    public class ButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == JPlayerView.this._playButton) {
                JPlayerView.this._model.play(JPlayerView.this._tunesList.getSelectedIndex());
            } else if (object == JPlayerView.this._stopButton) {
                JPlayerView.this._model.stop();
            } else if (object == JPlayerView.this._pauseButton) {
                JPlayerView.this._model.pause();
            } else {
                Assertion.assertion(false);
            }
        }
    }

    private static class ListDropTarget
    implements DropTargetListener {
        private final JPlayer.TuneListModel _model;

        public ListDropTarget(JPlayer.TuneListModel tuneListModel) {
            this._model = tuneListModel;
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.acceptDrag(1);
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.acceptDrag(1);
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
            boolean bl = false;
            if ((dropTargetDropEvent.getSourceActions() & 1) == 0) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            dropTargetDropEvent.acceptDrop(1);
            DataFlavor[] dataFlavorArray = dropTargetDropEvent.getCurrentDataFlavors();
            DataFlavor dataFlavor = null;
            int n = 0;
            while (n < dataFlavorArray.length) {
                if (DataFlavor.javaFileListFlavor.equals(dataFlavorArray[n])) {
                    dataFlavor = dataFlavorArray[n];
                    break;
                }
                ++n;
            }
            if (dataFlavor != null) {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                List list = null;
                try {
                    list = (List)transferable.getTransferData(dataFlavor);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    System.err.println(iOException.getMessage());
                    dropTargetContext.dropComplete(false);
                    return;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace();
                    System.err.println(unsupportedFlavorException.getMessage());
                    dropTargetContext.dropComplete(false);
                    return;
                }
                Assertion.assertion(list != null);
                if (list != null) {
                    this._model.addAll(list);
                }
            }
            dropTargetContext.dropComplete(bl);
        }
    }
}

