/*
 * Decompiled with CFR 0.152.
 */
package se.bysoft.sureshot.products.jplayer;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.Player;
import javax.media.Time;
import javax.swing.AbstractListModel;
import javax.swing.DefaultBoundedRangeModel;
import se.bysoft.sureshot.debug.Assertion;
import se.bysoft.sureshot.util.reporter.Reporter;

public class JPlayer
extends Observable {
    private final Reporter _reporter;
    private final PlayerModel _playerModel = new PlayerModel();
    private final SliderModel _sliderModel = new SliderModel(this._playerModel);
    private final TuneListModel _tuneListModel = new TuneListModel();
    private URL _url;
    private State _state = State.STOPPED;
    private Time _pauseTime;

    public JPlayer(Reporter reporter) {
        this._reporter = reporter;
        this._playerModel.start();
    }

    public PlayerModel getPlayerModel() {
        return this._playerModel;
    }

    public TuneListModel getListModel() {
        return this._tuneListModel;
    }

    public SliderModel getSliderModel() {
        return this._sliderModel;
    }

    public State getState() {
        return this._state;
    }

    public void nothingToPlay() {
        this._state = State.NOTHING_TO_PLAY;
        this._notifyChange();
    }

    public void pause() {
        if (this._playerModel.value != null) {
            this._pauseTime = this._playerModel.value.getMediaTime();
            this._playerModel.value.stop();
        }
        this._state = State.PAUSED;
        this._notifyChange();
    }

    public void stop() {
        if (this._playerModel.value != null) {
            this._playerModel.value.stop();
            this._playerModel.value.close();
        }
        this._state = State.STOPPED;
        this._notifyChange();
    }

    public void play(int n) {
        try {
            if (this._state != State.PAUSED) {
                if (this._tuneListModel.getSize() == 0) {
                    this._state = State.NOTHING_TO_PLAY;
                    this._notifyChange();
                    return;
                }
                if (n >= this._tuneListModel.getSize() || n < 0) {
                    n = 0;
                }
                if (this._playerModel.value != null) {
                    this._playerModel.value.stop();
                    this._playerModel.value.close();
                }
                this._playerModel.setCurrentUrl(((File)this._tuneListModel.get(n)).toURL());
                this._playerModel.value = Manager.createRealizedPlayer(this._playerModel.getCurrentUrl());
            }
            this._playerModel.value.start();
            if (this._state == State.PAUSED) {
                this._playerModel.value.setMediaTime(this._pauseTime);
            }
            this._playerModel.value.addControllerListener(new MyControllerListener());
            this._tuneListModel.nowPlaying(n);
            this._state = State.PLAYING;
            this._notifyChange();
        }
        catch (Exception exception) {
            String string = "An exception occured when playing. " + exception.getMessage();
            this._reporter.reportError(string);
            exception.printStackTrace();
        }
    }

    private void _notifyChange() {
        this.setChanged();
        this.notifyObservers();
    }

    public class PlayerModel
    extends Observable
    implements Runnable {
        public Player value;

        public void start() {
            new Thread(this).start();
        }

        public void setCurrentUrl(URL uRL) {
            JPlayer.this._url = uRL;
        }

        public URL getCurrentUrl() {
            return JPlayer.this._url;
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(500L);
                    if (this.value == null) continue;
                    this.setChanged();
                    this.notifyObservers();
                }
            }
            catch (InterruptedException interruptedException) {
                Assertion.assertion(false);
                return;
            }
        }
    }

    public static class SliderModel
    extends DefaultBoundedRangeModel
    implements Observer {
        private final PlayerModel _playerModel;
        private int _currentValue;

        public SliderModel(PlayerModel playerModel) {
            this._playerModel = playerModel;
            this._playerModel.addObserver(this);
        }

        public void update(Observable observable, Object object) {
            if (this._playerModel.value != null && !this.getValueIsAdjusting()) {
                this._currentValue = (int)this._playerModel.value.getMediaTime().getSeconds();
                this.setMaximum((int)this._playerModel.value.getDuration().getSeconds());
                this.fireStateChanged();
            }
        }

        public void setValue(int n) {
            this._currentValue = n;
        }

        public void sliderAdjusted(int n) {
            Player player = this._playerModel.value;
            if (player != null) {
                player.setMediaTime(new Time((double)n));
                this._currentValue = n;
                this.fireStateChanged();
            }
        }

        public int getValue() {
            return this._currentValue;
        }
    }

    public class MyControllerListener
    implements ControllerListener {
        public void controllerUpdate(ControllerEvent controllerEvent) {
            if (controllerEvent instanceof EndOfMediaEvent) {
                JPlayer.this.play(JPlayer.this._tuneListModel.getNowPlaying() + 1);
            }
        }
    }

    public static class TuneListModel
    extends AbstractListModel {
        private final ArrayList _files = new ArrayList();
        private int _nowPlayingIndex;

        public int getSize() {
            return this._files.size();
        }

        public Object getElementAt(int n) {
            return ((File)this._files.get(n)).getName();
        }

        public Object get(int n) {
            return this._files.get(n);
        }

        public void add(File file) {
            this._files.add(file);
            this._change();
        }

        public void add(File file, int n) {
            this._files.add(n, file);
            this._change();
        }

        public void addAll(Collection collection) {
            this._files.addAll(collection);
            this._change();
        }

        public void addAll(File[] fileArray) {
            this._files.addAll(Arrays.asList(fileArray));
            this._change();
        }

        public void clear() {
            this._files.clear();
            this._change();
        }

        public void remove(int[] nArray) {
            int n = nArray.length - 1;
            while (n >= 0) {
                int n2 = nArray[n];
                if (n2 >= 0 && n2 < this._files.size()) {
                    this._files.remove(n2);
                }
                --n;
            }
            this._change();
        }

        public void nowPlaying(int n) {
            this._nowPlayingIndex = n;
            this._change();
        }

        public int getNowPlaying() {
            return this._nowPlayingIndex;
        }

        private void _change() {
            this.fireContentsChanged(this, 0, this._files.size());
        }
    }

    public static final class State {
        public static final State PLAYING = new State();
        public static final State STOPPED = new State();
        public static final State PAUSED = new State();
        public static final State NOTHING_TO_PLAY = new State();

        protected State() {
        }
    }
}

