/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

public class ProgressBar
extends Canvas {
    private int nMinPos;
    private int nMaxPos;
    private int nCurPos;

    public ProgressBar(int n2, int n3) {
        this.nMinPos = n2;
        this.nMaxPos = n3;
        if (this.nMaxPos <= this.nMinPos) {
            this.nMaxPos = this.nMinPos + 1;
        }
        this.nCurPos = this.nMinPos;
        this.setBackground(Color.lightGray);
    }

    public int getCurPercent() {
        return 100 * (this.nCurPos - this.nMinPos) / (this.nMaxPos - this.nMinPos);
    }

    public int getCurPos() {
        return this.nCurPos;
    }

    public int getMaxPos() {
        return this.nMaxPos;
    }

    public int getMinPos() {
        return this.nMinPos;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(128, 22);
        return dimension;
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        graphics.setColor(Color.darkGray);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 2);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 2, rectangle.y);
        graphics.setColor(Color.white);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1, rectangle.x + 1, rectangle.y + rectangle.height - 1);
        ++rectangle.x;
        ++rectangle.y;
        rectangle.width -= 2;
        rectangle.height -= 2;
        graphics.setColor(Color.blue);
        rectangle.width = rectangle.width * (this.nCurPos - this.nMinPos) / (this.nMaxPos - this.nMinPos);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setCurPos(int n2) {
        this.nCurPos = n2;
        if (this.nCurPos > this.nMaxPos) {
            this.nCurPos = this.nMaxPos;
        }
        if (this.nCurPos < this.nMinPos) {
            this.nCurPos = this.nMinPos;
        }
        this.repaint();
    }
}

