/*
 * Decompiled with CFR 0.152.
 */
package jmapps.rtp;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.SessionManager;
import jmapps.ui.JMPanel;

public class PanelOverallRtpStats
extends JMPanel {
    private SessionManager mngrSession;
    private UpdateThread threadUpdate = null;
    private Label fieldTotalRtpPackets;
    private Label fieldTotalBytes;
    private Label fieldBadRtpPackets;
    private Label fieldLocalCollisions;
    private Label fieldRemoteCollisions;
    private Label fieldPacketsLooped;
    private Label fieldFailedTransmissions;
    private Label fieldRtcpPackets;
    private Label fieldSrPackets;
    private Label fieldBadRtcpPackets;
    private Label fieldUnknownRtcpTypes;
    private Label fieldMalformedRr;
    private Label fieldMalformedSdes;
    private Label fieldMalformedBye;
    private Label fieldMalformedSr;
    private static final String LABEL_TOTAL_PACKETS = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.totalpackets");
    private static final String LABEL_TOTAL_BYTES = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.totalbytes");
    private static final String LABEL_BAD_RTP_PACKETS = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.badrtppackets");
    private static final String LABEL_LOCAL_COLLISIONS = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.localcollisions");
    private static final String LABEL_REMOTE_COLLISIONS = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.remotecollisions");
    private static final String LABEL_PACKETS_LOOPED = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.packetslooped");
    private static final String LABEL_FAILED_TRANSMISSIONS = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.failedtransmissions");
    private static final String LABEL_RTCP_PACKETS = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.rtcppackets");
    private static final String LABEL_SR_PACKETS = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.srpackets");
    private static final String LABEL_BAD_RTCP_PACKETS = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.badrtcppackets");
    private static final String LABEL_UNKNOWN_RTCP_TYPES = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.unknownrtcptypes");
    private static final String LABEL_MALFORMED_RR = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.malformedrr");
    private static final String LABEL_MALFORMED_SDES = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.malformedsdes");
    private static final String LABEL_MALFORMED_BYE = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.malformedbye");
    private static final String LABEL_MALFORMED_SR = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.malformedsr");

    public PanelOverallRtpStats(SessionManager sessionManager) {
        this.mngrSession = sessionManager;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.threadUpdate == null) {
            this.threadUpdate = new UpdateThread();
        }
        this.threadUpdate.start();
    }

    private void init() throws Exception {
        this.setLayout(new GridLayout(1, 0, 24, 6));
        JMPanel jMPanel = new JMPanel(new BorderLayout(6, 6));
        this.add(jMPanel);
        JMPanel jMPanel2 = new JMPanel(new BorderLayout(6, 6));
        this.add(jMPanel2);
        JMPanel jMPanel3 = new JMPanel(new BorderLayout(6, 6));
        jMPanel.add((Component)jMPanel3, "North");
        JMPanel jMPanel4 = new JMPanel(new GridLayout(0, 1, 0, 0));
        jMPanel3.add((Component)jMPanel4, "West");
        JMPanel jMPanel5 = new JMPanel(new GridLayout(0, 1, 0, 0));
        jMPanel3.add((Component)jMPanel5, "Center");
        Label label = new Label(LABEL_TOTAL_PACKETS);
        jMPanel4.add(label);
        this.fieldTotalRtpPackets = new Label("000000000000");
        jMPanel5.add(this.fieldTotalRtpPackets);
        label = new Label(LABEL_TOTAL_BYTES);
        jMPanel4.add(label);
        this.fieldTotalBytes = new Label();
        jMPanel5.add(this.fieldTotalBytes);
        label = new Label(LABEL_BAD_RTP_PACKETS);
        jMPanel4.add(label);
        this.fieldBadRtpPackets = new Label();
        jMPanel5.add(this.fieldBadRtpPackets);
        label = new Label(LABEL_LOCAL_COLLISIONS);
        jMPanel4.add(label);
        this.fieldLocalCollisions = new Label();
        jMPanel5.add(this.fieldLocalCollisions);
        label = new Label(LABEL_REMOTE_COLLISIONS);
        jMPanel4.add(label);
        this.fieldRemoteCollisions = new Label();
        jMPanel5.add(this.fieldRemoteCollisions);
        label = new Label(LABEL_PACKETS_LOOPED);
        jMPanel4.add(label);
        this.fieldPacketsLooped = new Label();
        jMPanel5.add(this.fieldPacketsLooped);
        label = new Label(LABEL_FAILED_TRANSMISSIONS);
        jMPanel4.add(label);
        this.fieldFailedTransmissions = new Label();
        jMPanel5.add(this.fieldFailedTransmissions);
        jMPanel3 = new JMPanel(new BorderLayout(6, 6));
        jMPanel2.add((Component)jMPanel3, "North");
        jMPanel4 = new JMPanel(new GridLayout(0, 1, 0, 0));
        jMPanel3.add((Component)jMPanel4, "West");
        jMPanel5 = new JMPanel(new GridLayout(0, 1, 0, 0));
        jMPanel3.add((Component)jMPanel5, "Center");
        label = new Label(LABEL_RTCP_PACKETS);
        jMPanel4.add(label);
        this.fieldRtcpPackets = new Label();
        jMPanel5.add(this.fieldRtcpPackets);
        label = new Label(LABEL_SR_PACKETS);
        jMPanel4.add(label);
        this.fieldSrPackets = new Label();
        jMPanel5.add(this.fieldSrPackets);
        label = new Label(LABEL_BAD_RTCP_PACKETS);
        jMPanel4.add(label);
        this.fieldBadRtcpPackets = new Label();
        jMPanel5.add(this.fieldBadRtcpPackets);
        label = new Label(LABEL_UNKNOWN_RTCP_TYPES);
        jMPanel4.add(label);
        this.fieldUnknownRtcpTypes = new Label();
        jMPanel5.add(this.fieldUnknownRtcpTypes);
        label = new Label(LABEL_MALFORMED_RR);
        jMPanel4.add(label);
        this.fieldMalformedRr = new Label();
        jMPanel5.add(this.fieldMalformedRr);
        label = new Label(LABEL_MALFORMED_SDES);
        jMPanel4.add(label);
        this.fieldMalformedSdes = new Label();
        jMPanel5.add(this.fieldMalformedSdes);
        label = new Label(LABEL_MALFORMED_BYE);
        jMPanel4.add(label);
        this.fieldMalformedBye = new Label();
        jMPanel5.add(this.fieldMalformedBye);
        label = new Label(LABEL_MALFORMED_SR);
        jMPanel4.add(label);
        this.fieldMalformedSr = new Label();
        jMPanel5.add(this.fieldMalformedSr);
        this.updateFields();
    }

    public void removeNotify() {
        if (this.threadUpdate != null) {
            this.threadUpdate.terminate();
            this.threadUpdate = null;
        }
        super.removeNotify();
    }

    private void updateFields() {
        GlobalReceptionStats globalReceptionStats = this.mngrSession.getGlobalReceptionStats();
        this.fieldTotalRtpPackets.setText(String.valueOf(globalReceptionStats.getPacketsRecd()));
        this.fieldTotalBytes.setText(String.valueOf(globalReceptionStats.getBytesRecd()));
        this.fieldBadRtpPackets.setText(String.valueOf(globalReceptionStats.getBadRTPkts()));
        this.fieldLocalCollisions.setText(String.valueOf(globalReceptionStats.getLocalColls()));
        this.fieldRemoteCollisions.setText(String.valueOf(globalReceptionStats.getRemoteColls()));
        this.fieldPacketsLooped.setText(String.valueOf(globalReceptionStats.getPacketsLooped()));
        this.fieldFailedTransmissions.setText(String.valueOf(globalReceptionStats.getTransmitFailed()));
        this.fieldRtcpPackets.setText(String.valueOf(globalReceptionStats.getRTCPRecd()));
        this.fieldSrPackets.setText(String.valueOf(globalReceptionStats.getSRRecd()));
        this.fieldBadRtcpPackets.setText(String.valueOf(globalReceptionStats.getBadRTCPPkts()));
        this.fieldUnknownRtcpTypes.setText(String.valueOf(globalReceptionStats.getUnknownTypes()));
        this.fieldMalformedRr.setText(String.valueOf(globalReceptionStats.getMalformedRR()));
        this.fieldMalformedSdes.setText(String.valueOf(globalReceptionStats.getMalformedSDES()));
        this.fieldMalformedBye.setText(String.valueOf(globalReceptionStats.getMalformedBye()));
        this.fieldMalformedSr.setText(String.valueOf(globalReceptionStats.getMalformedSR()));
    }

    private class UpdateThread
    extends Thread {
        private boolean boolTerminate = false;

        public void run() {
            while (!this.boolTerminate) {
                try {
                    Thread.sleep(1000L);
                    PanelOverallRtpStats.this.updateFields();
                }
                catch (Exception exception) {}
            }
        }

        public void terminate() {
            this.boolTerminate = true;
        }
    }
}

