/*
 * Decompiled with CFR 0.152.
 */
package jmapps.jmstudio;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.media.Control;
import javax.media.protocol.DataSource;
import jmapps.ui.JMDialog;
import jmapps.ui.JMPanel;

public class CaptureControlsDialog
extends JMDialog {
    private DataSource dataSource;
    private int nControlCount = 0;

    public CaptureControlsDialog(Frame frame, DataSource dataSource) {
        super(frame, JMFI18N.getResource("jmstudio.capturecontrols.title"), false);
        this.dataSource = dataSource;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(JMDialog.ACTION_CLOSE)) {
            this.setAction(JMDialog.ACTION_CLOSE);
            this.setVisible(false);
        }
    }

    private void init() throws Exception {
        int n2 = 0;
        Object[] objectArray = null;
        this.setLayout(new BorderLayout());
        JMPanel jMPanel = new JMPanel(new BorderLayout());
        jMPanel.setEmptyBorder(6, 6, 6, 6);
        this.add((Component)jMPanel, "Center");
        if (this.dataSource != null) {
            objectArray = this.dataSource.getControls();
        }
        if (objectArray != null) {
            n2 = objectArray.length;
        }
        Panel panel = jMPanel;
        this.nControlCount = 0;
        int n3 = 0;
        while (n3 < n2) {
            Component component;
            if (objectArray[n3] != null && objectArray[n3] instanceof Control && (component = ((Control)objectArray[n3]).getControlComponent()) != null) {
                ++this.nControlCount;
                Panel panel2 = new Panel(new BorderLayout(6, 6));
                panel2.add(component, "North");
                panel.add((Component)panel2, "Center");
                panel = panel2;
            }
            ++n3;
        }
        panel = new JMPanel(new FlowLayout(1));
        jMPanel.add((Component)panel, "South");
        JMPanel jMPanel2 = this.createButtonPanel(new String[]{JMDialog.ACTION_CLOSE});
        panel.add(jMPanel2);
        this.pack();
        this.setResizable(false);
    }

    public boolean isEmpty() {
        return this.nControlCount < 1;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setAction(JMDialog.ACTION_CLOSE);
        this.setVisible(false);
    }
}

