/*
 * Decompiled with CFR 0.152.
 */
package jmapps.export;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Processor;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import jmapps.jmstudio.CaptureControlsDialog;
import jmapps.jmstudio.CaptureDialog;
import jmapps.ui.JMDialog;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;
import jmapps.util.JMAppsCfg;

public class PanelMediaSource
extends JMPanel
implements ActionListener,
TextListener {
    private JMAppsCfg cfgJMApps = null;
    private TextField textSource;
    private Button buttonBrowseFile;
    private Button buttonBrowseCapture;
    private CaptureDialog dlgCapture = null;
    private CaptureControlsDialog dlgCaptureControls = null;
    private boolean boolSettingCaptureSource = false;
    private String strContentTypeDefault = null;
    private DataSource dataSource = null;

    public PanelMediaSource(JMAppsCfg jMAppsCfg) {
        this.cfgJMApps = jMAppsCfg;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void SaveData() {
        String string = this.textSource.getText();
        if (this.cfgJMApps != null && string != null) {
            this.cfgJMApps.setLastTransmitRtpSource(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.buttonBrowseFile.getLabel())) {
            this.browseFile();
        } else if (string.equals(this.buttonBrowseCapture.getLabel())) {
            this.browseCapture();
        }
    }

    private void browseCapture() {
        if (this.dlgCapture == null) {
            this.dlgCapture = new CaptureDialog(this.getFrame(), this.cfgJMApps);
        }
        this.dlgCapture.show();
        String string = this.dlgCapture.getAction();
        if (string.equals(JMDialog.ACTION_OK)) {
            this.boolSettingCaptureSource = true;
            this.textSource.setText(this.dlgCapture.toString());
        } else {
            this.dlgCapture = null;
        }
    }

    private void browseFile() {
        FileDialog fileDialog;
        String string = this.textSource.getText();
        try {
            fileDialog = new FileDialog(this.getFrame(), JMFI18N.getResource("jmstudio.export.source.filedialog"), 0);
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(this.getFrame(), JMFI18N.getResource("jmstudio.error.fgiledialog"));
            return;
        }
        int n2 = string.indexOf(58);
        if (n2 > 0 && string.substring(0, n2).equalsIgnoreCase("file")) {
            string = string.substring(n2 + 1);
            fileDialog.setFile(string);
        }
        fileDialog.show();
        string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string != null && string.length() > 0) {
            string = "file:" + string2 + string;
            this.textSource.setText(string);
            this.dlgCapture = null;
        }
    }

    public Processor createProcessor() {
        String string;
        Processor processor = null;
        this.strContentTypeDefault = null;
        this.dlgCaptureControls = null;
        if (this.dataSource == null) {
            if (this.dlgCapture != null) {
                this.dataSource = this.dlgCapture.createCaptureDataSource();
            } else {
                String string2 = this.getSourceUrl();
                try {
                    MediaLocator mediaLocator = new MediaLocator(string2);
                    this.dataSource = Manager.createDataSource(mediaLocator);
                }
                catch (Exception exception) {
                    MessageDialog.createErrorDialog(this.getFrame(), String.valueOf(JMFI18N.getResource("jmstudio.error.datasource.createfor")) + " '" + string2 + "'. ", exception);
                }
            }
        }
        if (this.dataSource == null) {
            this.setCursor(Cursor.getDefaultCursor());
            return null;
        }
        if (this.dataSource instanceof CaptureDevice) {
            this.dlgCaptureControls = new CaptureControlsDialog(this.getFrame(), this.dataSource);
        }
        if ((string = this.dataSource.getContentType()) != null) {
            this.strContentTypeDefault = new ContentDescriptor(string).toString();
        }
        try {
            processor = Manager.createProcessor(this.dataSource);
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(this.getFrame(), JMFI18N.getResource("jmstudio.error.processor.create"), exception);
            exception.printStackTrace();
            this.setCursor(Cursor.getDefaultCursor());
            return null;
        }
        return processor;
    }

    public CaptureControlsDialog getCaptureControlsDialog() {
        return this.dlgCaptureControls;
    }

    public String getDefaultContentType() {
        return this.strContentTypeDefault;
    }

    public String getSourceUrl() {
        String string = this.textSource.getText();
        return string;
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout(12, 12));
        Panel panel = new Panel(new GridLayout(0, 1));
        this.add((Component)panel, "North");
        panel.add(new Label(JMFI18N.getResource("jmstudio.export.source.label1")));
        panel.add(new Label(JMFI18N.getResource("jmstudio.export.source.label2")));
        Panel panel2 = new Panel(new BorderLayout(6, 6));
        this.add((Component)panel2, "Center");
        Panel panel3 = new Panel(new BorderLayout(6, 6));
        panel2.add((Component)panel3, "North");
        this.textSource = new TextField();
        this.textSource.addTextListener(this);
        panel3.add((Component)this.textSource, "Center");
        Panel panel4 = new Panel(new BorderLayout(6, 6));
        panel2.add((Component)panel4, "Center");
        Panel panel5 = new Panel(new BorderLayout(6, 6));
        panel4.add((Component)panel5, "North");
        Panel panel6 = new Panel(new GridLayout(1, 0, 6, 6));
        panel5.add((Component)panel6, "West");
        this.buttonBrowseFile = new Button(JMFI18N.getResource("jmstudio.export.source.file"));
        this.buttonBrowseFile.addActionListener(this);
        panel6.add(this.buttonBrowseFile);
        this.buttonBrowseCapture = new Button(JMFI18N.getResource("jmstudio.export.source.capture"));
        this.buttonBrowseCapture.addActionListener(this);
        panel6.add(this.buttonBrowseCapture);
    }

    public void setCaptureDlg(CaptureDialog captureDialog) {
        this.dlgCapture = captureDialog;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setJMStudioCfg(JMAppsCfg jMAppsCfg) {
        String string = null;
        this.cfgJMApps = jMAppsCfg;
        if (jMAppsCfg != null) {
            string = jMAppsCfg.getLastTransmitRtpSource();
        }
        if (string != null) {
            this.textSource.setText(string);
        }
    }

    public void setSourceUrl(String string) {
        if (string != null && string.trim().length() > 0) {
            this.textSource.setText(string);
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        Object object = textEvent.getSource();
        if (object == this.textSource) {
            if (this.boolSettingCaptureSource) {
                this.boolSettingCaptureSource = false;
            } else {
                this.dlgCapture = null;
            }
            this.dataSource = null;
        }
    }
}

