/*
 * Decompiled with CFR 0.152.
 */
package jmapps.export;

import com.sun.media.rtp.RTPSessionMgr;
import com.sun.media.ui.PlayerWindow;
import com.sun.media.util.JMFI18N;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.Duration;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.Processor;
import javax.media.Time;
import javax.media.control.MonitorControl;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionManager;
import jmapps.export.PanelMediaSource;
import jmapps.export.PanelMediaTargetFile;
import jmapps.export.PanelMediaTargetFormat;
import jmapps.export.PanelMediaTargetNetwork;
import jmapps.export.PanelMediaTargetType;
import jmapps.export.TransmitPlayerWindow;
import jmapps.jmstudio.CaptureControlsDialog;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;
import jmapps.ui.ProgressDialog;
import jmapps.ui.ProgressThread;
import jmapps.ui.WizardDialog;
import jmapps.util.JMAppsCfg;
import jmapps.util.JMFUtils;

public class ExportWizard
extends WizardDialog
implements ControllerListener,
DataSinkListener {
    protected PanelMediaSource panelSource;
    protected PanelMediaTargetType panelTargetType;
    protected PanelMediaTargetFormat panelTargetFormat;
    protected PanelMediaTargetFile panelTargetFile;
    protected PanelMediaTargetNetwork panelTargetNetwork;
    protected String strTitle = JMFI18N.getResource("jmstudio.export.title");
    protected Processor processor = null;
    protected String strTargetType = null;
    protected boolean boolChangedProcessor = false;
    protected boolean boolChangedTargetType = false;
    protected String strFailMessage = null;
    protected DataSink dataSinkSave = null;
    protected ProgressDialog dlgProgressSave = null;
    protected ProgressThread threadProgressSave = null;
    protected TransmitPlayerWindow playerTransmit = null;
    protected CaptureControlsDialog dlgCaptureControls = null;
    protected Vector vectorWindowsLeft = new Vector();
    private JMAppsCfg cfgJMApps = null;
    Object stateLock = new Object();
    boolean stateFailed = false;

    public ExportWizard(Frame frame, String string, JMAppsCfg jMAppsCfg) {
        this(JMFI18N.getResource("jmstudio.export.title"), frame, string, jMAppsCfg);
    }

    public ExportWizard(String string, Frame frame, String string2, JMAppsCfg jMAppsCfg) {
        super(frame, string, true, "logo.gif");
        this.strTitle = string;
        this.setTitle(string);
        this.cfgJMApps = jMAppsCfg;
        this.panelSource.setJMStudioCfg(jMAppsCfg);
        this.panelSource.setSourceUrl(string2);
        this.panelTargetNetwork.setJMStudioCfg(jMAppsCfg);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ((string.equals(ProgressDialog.ACTION_ABORT) || string.equals(ProgressDialog.ACTION_STOP)) && this.dataSinkSave != null) {
            this.stopSaving();
        } else if (string.equals(ProgressDialog.ACTION_PAUSE) && this.dataSinkSave != null) {
            this.processor.stop();
            this.dlgProgressSave.setPauseButtonText(ProgressDialog.ACTION_RESUME);
            this.threadProgressSave.pauseThread();
        } else if (string.equals(ProgressDialog.ACTION_RESUME) && this.dataSinkSave != null) {
            this.processor.start();
            this.dlgProgressSave.setPauseButtonText(ProgressDialog.ACTION_PAUSE);
            this.threadProgressSave.resumeThread();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void addTransmitSessionManager(SessionManager sessionManager, SendStream sendStream, String string) {
        if (this.playerTransmit == null) {
            return;
        }
        this.playerTransmit.addSessionManager(sessionManager, sendStream, string);
    }

    private synchronized void closeDataSink() {
        if (this.dataSinkSave != null) {
            this.dataSinkSave.close();
            this.dataSinkSave = null;
        }
    }

    private void configureProcessor() {
        if (this.processor == null) {
            return;
        }
        boolean bl = this.waitForState(this.processor, 180);
        if (!bl) {
            MessageDialog.createErrorDialog(this.frameOwner, this.strFailMessage);
            this.destroyProcessor();
        }
    }

    public void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof ControllerErrorEvent) {
            this.strFailMessage = String.valueOf(JMFI18N.getResource("jmstudio.error.controller")) + "\n" + ((ControllerErrorEvent)controllerEvent).getMessage();
        } else if (controllerEvent instanceof EndOfMediaEvent && this.strTargetType.equals(PanelMediaTargetType.TYPE_FILE)) {
            this.stopSaving();
        }
    }

    protected void createTransmitWindow() {
        if (this.processor == null) {
            return;
        }
        this.playerTransmit = new TransmitPlayerWindow(this.processor);
        this.playerTransmit.addWindowListener(this);
        this.vectorWindowsLeft.addElement(this.playerTransmit);
    }

    public void dataSinkUpdate(DataSinkEvent dataSinkEvent) {
        if (dataSinkEvent instanceof EndOfStreamEvent) {
            this.closeDataSink();
        } else if (dataSinkEvent instanceof DataSinkErrorEvent) {
            this.stopSaving();
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.writefile"));
        }
    }

    private void destroyProcessor() {
        if (this.processor == null) {
            return;
        }
        this.processor.removeControllerListener(this);
        this.processor.close();
        this.processor = null;
        this.panelSource.setDataSource(null);
    }

    private boolean doPreview() {
        if (this.processor == null) {
            return false;
        }
        this.panelTargetFormat.updateProcessorFormat();
        this.realizeProcessor();
        if (this.processor == null) {
            return false;
        }
        DataSource dataSource = this.processor.getDataOutput();
        if (dataSource == null) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.creatednooutput"));
            this.destroyProcessor();
            return false;
        }
        try {
            Player player = Manager.createPlayer(dataSource);
            if (player == null) {
                MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.player.create"));
                this.destroyProcessor();
                return false;
            }
            PlayerWindow playerWindow = new PlayerWindow(player, JMFI18N.getResource("jmstudio.playerwindow.preview"));
            this.vectorWindowsLeft.addElement(playerWindow);
            playerWindow = new PlayerWindow(this.processor, JMFI18N.getResource("jmstudio.playerwindow.transcoding"));
            this.vectorWindowsLeft.addElement(playerWindow);
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.player.create"), exception);
            this.destroyProcessor();
            return false;
        }
        return true;
    }

    private boolean doSaveFile() {
        MonitorControl monitorControl = null;
        Component component = null;
        if (this.processor == null) {
            return false;
        }
        this.panelTargetFormat.updateProcessorFormat();
        this.realizeProcessor();
        if (this.processor == null) {
            return false;
        }
        DataSource dataSource = this.processor.getDataOutput();
        if (dataSource == null) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.creatednooutput"));
            this.destroyProcessor();
            return false;
        }
        try {
            String string = this.panelTargetFile.getFileName();
            MediaLocator mediaLocator = new MediaLocator("file:" + string);
            this.dataSinkSave = Manager.createDataSink(dataSource, mediaLocator);
        }
        catch (Exception exception) {
            this.stopSaving();
            MessageDialog.createErrorDialog(this.frameOwner, exception);
            return false;
        }
        try {
            this.dataSinkSave.addDataSinkListener(this);
            monitorControl = (MonitorControl)this.processor.getControl("javax.media.control.MonitorControl");
            if (monitorControl != null) {
                component = monitorControl.getControlComponent();
            }
            Time time = this.processor.getDuration();
            int n2 = (int)time.getSeconds();
            this.dataSinkSave.open();
            this.dataSinkSave.start();
            this.processor.start();
            this.dlgProgressSave = n2 > 0 && time != Duration.DURATION_UNBOUNDED && time != Duration.DURATION_UNKNOWN ? new ProgressDialog(this.frameOwner, JMFI18N.getResource("jmstudio.saveprogress.title"), 0, n2, (ActionListener)this) : new ProgressDialog(this.frameOwner, JMFI18N.getResource("jmstudio.saveprogress.title"), JMFI18N.getResource("jmstudio.saveprogress.label"), component, (ActionListener)this);
            this.dlgProgressSave.setVisible(true);
            this.threadProgressSave = new ProgressThread(this.processor, this.dlgProgressSave);
            this.threadProgressSave.start();
            this.vectorWindowsLeft.addElement(this.dlgProgressSave);
        }
        catch (Exception exception) {
            this.stopSaving();
            MessageDialog.createErrorDialog(this.frameOwner, exception);
        }
        return true;
    }

    private boolean doTransmit() {
        String string = JMFI18N.getResource("jmstudio.export.targetnw.audio");
        String string2 = JMFI18N.getResource("jmstudio.export.targetnw.video");
        if (this.processor == null) {
            return false;
        }
        this.panelSource.setCaptureDlg(null);
        this.panelTargetFormat.updateProcessorFormat();
        this.realizeProcessor();
        if (this.processor == null) {
            return false;
        }
        DataSource dataSource = this.processor.getDataOutput();
        if (dataSource == null) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.creatednooutput"));
            this.destroyProcessor();
            return false;
        }
        if (!(dataSource instanceof PushBufferDataSource)) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.outputincorrect"));
            this.destroyProcessor();
            return false;
        }
        PushBufferStream[] pushBufferStreamArray = ((PushBufferDataSource)dataSource).getStreams();
        if (pushBufferStreamArray == null) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.outputempty"));
            this.destroyProcessor();
            return false;
        }
        boolean[] blArray = this.panelTargetFormat.getEnabledVideoTracks();
        boolean[] blArray2 = this.panelTargetFormat.getEnabledAudioTracks();
        String[] stringArray = this.panelTargetNetwork.getVideoAddresses();
        String[] stringArray2 = this.panelTargetNetwork.getAudioAddresses();
        String[] stringArray3 = this.panelTargetNetwork.getVideoPorts();
        String[] stringArray4 = this.panelTargetNetwork.getAudioPorts();
        String[] stringArray5 = this.panelTargetNetwork.getVideoTtls();
        String[] stringArray6 = this.panelTargetNetwork.getAudioTtls();
        TrackControl[] trackControlArray = this.processor.getTrackControls();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        while (n4 < pushBufferStreamArray.length) {
            block19: {
                String string3;
                String string4;
                String string5;
                String string6;
                block20: {
                    Format format;
                    block18: {
                        format = pushBufferStreamArray[n4].getFormat();
                        if (!(format instanceof VideoFormat)) break block18;
                        while (n2 < blArray.length && !blArray[n2]) {
                            ++n2;
                        }
                        if (n2 >= blArray.length) break block19;
                        string6 = stringArray[n2];
                        string5 = stringArray3[n2];
                        string4 = stringArray5[n2];
                        string3 = String.valueOf(string2) + " " + ++n2;
                        break block20;
                    }
                    if (!(format instanceof AudioFormat)) break block19;
                    while (n3 < blArray2.length && !blArray2[n3]) {
                        ++n3;
                    }
                    if (n3 >= blArray2.length) break block19;
                    string6 = stringArray2[n3];
                    string5 = stringArray4[n3];
                    string4 = stringArray6[n3];
                    string3 = String.valueOf(string) + " " + ++n3;
                }
                try {
                    if (!string6.equals("...") && !string5.equals("")) {
                        RTPSessionMgr rTPSessionMgr = JMFUtils.createSessionManager(string6, string5, string4, null);
                        if (rTPSessionMgr == null) {
                            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.createsessionmanager"));
                            this.destroyProcessor();
                            return false;
                        }
                        SendStream sendStream = rTPSessionMgr.createSendStream(dataSource, n4);
                        sendStream.start();
                        if (!bl) {
                            this.createTransmitWindow();
                        }
                        bl = true;
                        this.addTransmitSessionManager(rTPSessionMgr, sendStream, string3);
                    }
                }
                catch (Exception exception) {
                    MessageDialog.createErrorDialog(this.frameOwner, exception);
                    this.destroyProcessor();
                    return false;
                }
            }
            ++n4;
        }
        this.dlgCaptureControls = this.panelSource.getCaptureControlsDialog();
        if (this.dlgCaptureControls != null && !this.dlgCaptureControls.isEmpty()) {
            this.dlgCaptureControls.setVisible(true);
        }
        if (!bl) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.transmittracks"));
            this.destroyProcessor();
        }
        return bl;
    }

    protected Panel getFirstPage() {
        return this.panelSource;
    }

    protected Panel getLastPage() {
        JMPanel jMPanel = null;
        String string = this.panelTargetType.getType();
        if (string.equals(PanelMediaTargetType.TYPE_FILE)) {
            jMPanel = this.panelTargetFile;
        } else if (string.equals(PanelMediaTargetType.TYPE_NETWORK)) {
            jMPanel = this.panelTargetNetwork;
        } else if (string.equals(PanelMediaTargetType.TYPE_SCREEN)) {
            jMPanel = this.panelTargetFormat;
        }
        return jMPanel;
    }

    protected Panel getNextPage(Panel panel) {
        Panel panel2 = null;
        if (panel == null) {
            panel2 = this.getFirstPage();
        } else if (panel == this.panelSource) {
            panel2 = this.panelTargetType;
        } else if (panel == this.panelTargetType) {
            panel2 = this.panelTargetFormat;
        } else if (panel == this.panelTargetFormat) {
            String string = this.panelTargetType.getType();
            if (string.equals(PanelMediaTargetType.TYPE_FILE)) {
                panel2 = this.panelTargetFile;
            } else if (string.equals(PanelMediaTargetType.TYPE_NETWORK)) {
                panel2 = this.panelTargetNetwork;
            } else if (string.equals(PanelMediaTargetType.TYPE_SCREEN)) {
                panel2 = null;
            }
        } else {
            panel2 = null;
        }
        return panel2;
    }

    protected Panel getPrevPage(Panel panel) {
        Panel panel2 = null;
        panel2 = panel == null ? this.getLastPage() : (panel == this.panelTargetNetwork ? this.panelTargetFormat : (panel == this.panelTargetFile ? this.panelTargetFormat : (panel == this.panelTargetFile ? this.panelTargetFormat : (panel == this.panelTargetFormat ? this.panelTargetType : (panel == this.panelTargetType ? this.panelSource : null)))));
        return panel2;
    }

    public Vector getWindowsLeft() {
        return this.vectorWindowsLeft;
    }

    protected void init() throws Exception {
        super.init();
        this.panelSource = new PanelMediaSource(this.cfgJMApps);
        this.panelTargetType = new PanelMediaTargetType();
        this.panelTargetFormat = new PanelMediaTargetFormat();
        this.panelTargetFile = new PanelMediaTargetFile();
        this.panelTargetNetwork = new PanelMediaTargetNetwork(this.cfgJMApps);
        ((Component)this).setSize(480, 480);
        ((Component)this).setLocation(100, 100);
    }

    protected boolean onFinish() {
        this.setCursor(new Cursor(3));
        boolean bl = this.strTargetType == null ? false : (this.strTargetType.equals(PanelMediaTargetType.TYPE_FILE) ? this.doSaveFile() : (this.strTargetType.equals(PanelMediaTargetType.TYPE_NETWORK) ? this.doTransmit() : (this.strTargetType.equals(PanelMediaTargetType.TYPE_SCREEN) ? this.doPreview() : false)));
        this.setCursor(Cursor.getDefaultCursor());
        return bl;
    }

    protected boolean onPageActivate(Panel panel) {
        if (panel == this.panelSource) {
            this.setTitle(this.strTitle);
        } else if (panel == this.panelTargetFormat) {
            if (this.boolChangedProcessor || this.boolChangedTargetType) {
                this.setCursor(new Cursor(3));
                String string = this.panelSource.getDefaultContentType();
                this.panelTargetFormat.setProcessor(this.processor, string, this.strTargetType);
                this.boolChangedProcessor = false;
                this.boolChangedTargetType = false;
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else if (panel != this.panelTargetFile && panel == this.panelTargetNetwork) {
            this.panelTargetNetwork.setTracks(this.panelTargetFormat.getEnabledVideoTracks(), this.panelTargetFormat.getEnabledAudioTracks());
        }
        return true;
    }

    protected boolean onPageDone(Panel panel) {
        if (panel == this.panelSource) {
            this.setCursor(new Cursor(3));
            this.processor = this.panelSource.createProcessor();
            if (this.processor != null) {
                this.processor.addControllerListener(this);
                this.configureProcessor();
            }
            this.setCursor(Cursor.getDefaultCursor());
            if (this.processor == null) {
                this.panelSource.setDataSource(null);
                this.setTitle(this.strTitle);
                return false;
            }
            this.boolChangedProcessor = true;
            this.setTitle(String.valueOf(this.strTitle) + " " + this.panelSource.getSourceUrl());
            this.panelSource.SaveData();
        } else if (panel == this.panelTargetType) {
            if (this.strTargetType == null || !this.panelTargetType.getType().equals(this.strTargetType)) {
                this.strTargetType = this.panelTargetType.getType();
                this.boolChangedTargetType = true;
            }
        } else if (panel == this.panelTargetNetwork) {
            if (!this.panelTargetNetwork.checkValidFields(true)) {
                return false;
            }
            this.panelTargetNetwork.saveData();
        }
        return true;
    }

    private void realizeProcessor() {
        if (this.processor == null) {
            return;
        }
        boolean bl = this.waitForState(this.processor, 300);
        if (!bl) {
            MessageDialog.createErrorDialog(this.frameOwner, this.strFailMessage);
            this.destroyProcessor();
        }
    }

    private void stopSaving() {
        if (this.threadProgressSave != null) {
            this.threadProgressSave.terminateNormaly();
            this.threadProgressSave = null;
        }
        if (this.processor != null) {
            this.processor.stop();
            this.destroyProcessor();
        }
        if (this.dlgProgressSave != null) {
            this.dlgProgressSave.dispose();
            this.dlgProgressSave = null;
        }
    }

    private synchronized boolean waitForState(Processor processor, int n2) {
        StateListener stateListener = new StateListener();
        processor.addControllerListener(stateListener);
        this.stateFailed = false;
        if (n2 == 180) {
            processor.configure();
        } else if (n2 == 300) {
            processor.realize();
        }
        while (processor.getState() < n2 && !this.stateFailed) {
            Object object = this.stateLock;
            synchronized (object) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    boolean bl = false;
                    Object var6_6 = null;
                    return bl;
                }
            }
        }
        processor.removeControllerListener(stateListener);
        return this.stateFailed ^ true;
    }

    public void windowClosed(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object == this.playerTransmit) {
            if (this.dlgCaptureControls != null) {
                this.dlgCaptureControls.dispose();
                this.dlgCaptureControls = null;
            }
            this.playerTransmit = null;
        }
        if (this.getAction().equals(WizardDialog.ACTION_CANCEL)) {
            this.destroyProcessor();
        }
    }

    class StateListener
    implements ControllerListener {
        StateListener() {
        }

        public void controllerUpdate(ControllerEvent controllerEvent) {
            if (controllerEvent instanceof ControllerClosedEvent) {
                ExportWizard.this.stateFailed = true;
            }
            if (controllerEvent instanceof ControllerEvent) {
                Object object = ExportWizard.this.stateLock;
                synchronized (object) {
                    ExportWizard.this.stateLock.notifyAll();
                }
            }
        }
    }
}

