/*
 * Decompiled with CFR 0.152.
 */
package javax.media.rtp;

import java.io.Serializable;
import java.net.InetAddress;

public class SessionAddress
implements Serializable {
    private InetAddress m_dataAddress;
    private InetAddress m_controlAddress;
    private int m_dataPort;
    private int m_controlPort;
    private int ttl;
    public static final int ANY_PORT = -1;

    public SessionAddress() {
        this(null, -1, null, -1);
    }

    public SessionAddress(InetAddress inetAddress, int n2) {
        this.m_dataAddress = inetAddress;
        this.m_controlAddress = inetAddress;
        this.m_dataPort = n2;
        this.m_controlPort = n2 + 1;
    }

    public SessionAddress(InetAddress inetAddress, int n2, int n3) {
        this.m_dataAddress = inetAddress;
        this.m_controlAddress = inetAddress;
        this.m_dataPort = n2;
        this.m_controlPort = n2 + 1;
        this.ttl = n3;
    }

    public SessionAddress(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) {
        this.m_dataAddress = inetAddress;
        this.m_controlAddress = inetAddress2;
        this.m_dataPort = n2;
        this.m_controlPort = n3;
    }

    public boolean equals(Object object) {
        if (object instanceof SessionAddress) {
            SessionAddress sessionAddress = (SessionAddress)object;
            InetAddress inetAddress = sessionAddress.getDataAddress();
            InetAddress inetAddress2 = sessionAddress.getControlAddress();
            int n2 = sessionAddress.getDataPort();
            int n3 = sessionAddress.getControlPort();
            if (inetAddress.equals(this.m_dataAddress) && inetAddress2.equals(this.m_controlAddress) && n2 == this.m_dataPort && n3 == this.m_controlPort) {
                return true;
            }
        }
        return false;
    }

    public InetAddress getControlAddress() {
        return this.m_controlAddress;
    }

    public String getControlHostAddress() {
        return this.m_controlAddress.getHostAddress();
    }

    public int getControlPort() {
        return this.m_controlPort;
    }

    public InetAddress getDataAddress() {
        return this.m_dataAddress;
    }

    public String getDataHostAddress() {
        return this.m_dataAddress.getHostAddress();
    }

    public int getDataPort() {
        return this.m_dataPort;
    }

    public int getTimeToLive() {
        return this.ttl;
    }

    public int hashCode() {
        return 1;
    }

    public void setControlHostAddress(InetAddress inetAddress) {
        this.m_controlAddress = inetAddress;
    }

    public void setControlPort(int n2) {
        this.m_controlPort = n2;
    }

    public void setDataHostAddress(InetAddress inetAddress) {
        this.m_dataAddress = inetAddress;
    }

    public void setDataPort(int n2) {
        this.m_dataPort = n2;
    }

    public String toString() {
        String string = "DataAddress: ";
        string = this.m_dataAddress != null ? String.valueOf(string) + this.m_dataAddress.toString() : String.valueOf(string) + "null";
        string = String.valueOf(string) + "\nControlAddress: ";
        string = this.m_controlAddress != null ? String.valueOf(string) + this.m_controlAddress.toString() : String.valueOf(string) + "null";
        string = String.valueOf(string) + "\nDataPort: " + this.m_dataPort + "\nControlPort: " + this.m_controlPort;
        return string;
    }
}

