/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;

public class VideoFormat
extends Format {
    protected Dimension size = null;
    protected int maxDataLength = -1;
    protected float frameRate = -1.0f;
    public static final String CINEPAK = "cvid";
    public static final String JPEG = "jpeg";
    public static final String JPEG_RTP = "jpeg/rtp";
    public static final String MPEG = "mpeg";
    public static final String MPEG_RTP = "mpeg/rtp";
    public static final String H261 = "h261";
    public static final String H261_RTP = "h261/rtp";
    public static final String H263 = "h263";
    public static final String H263_RTP = "h263/rtp";
    public static final String H263_1998_RTP = "h263-1998/rtp";
    public static final String RGB = "rgb";
    public static final String YUV = "yuv";
    public static final String IRGB = "irgb";
    public static final String SMC = "smc";
    public static final String RLE = "rle";
    public static final String RPZA = "rpza";
    public static final String MJPG = "mjpg";
    public static final String MJPEGA = "mjpa";
    public static final String MJPEGB = "mjpb";
    public static final String INDEO32 = "iv32";
    public static final String INDEO41 = "iv41";
    public static final String INDEO50 = "iv50";

    public VideoFormat(String string) {
        super(string);
    }

    public VideoFormat(String string, Dimension dimension, int n2, Class clazz, float f2) {
        this(string);
        if (dimension != null) {
            this.size = new Dimension(dimension);
        }
        this.maxDataLength = n2;
        this.dataType = clazz;
        this.frameRate = f2;
    }

    public Object clone() {
        VideoFormat videoFormat = new VideoFormat(this.encoding, this.size, this.maxDataLength, this.dataType, this.frameRate);
        videoFormat.copy(this);
        return videoFormat;
    }

    protected void copy(Format format) {
        super.copy(format);
        VideoFormat videoFormat = (VideoFormat)format;
        if (videoFormat.size != null) {
            this.size = new Dimension(videoFormat.size);
        }
        this.maxDataLength = videoFormat.maxDataLength;
        this.frameRate = videoFormat.frameRate;
    }

    public boolean equals(Object object) {
        if (object instanceof VideoFormat) {
            VideoFormat videoFormat = (VideoFormat)object;
            if (this.size == null || videoFormat.size == null ? this.size != videoFormat.size : !this.size.equals(videoFormat.size)) {
                return false;
            }
            return super.equals(object) && this.maxDataLength == videoFormat.maxDataLength && this.frameRate == videoFormat.frameRate;
        }
        return false;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public int getMaxDataLength() {
        return this.maxDataLength;
    }

    public Dimension getSize() {
        return this.size;
    }

    public Format intersects(Format format) {
        Format format2 = super.intersects(format);
        if (format2 == null) {
            return null;
        }
        if (!(format instanceof VideoFormat)) {
            return format2;
        }
        VideoFormat videoFormat = (VideoFormat)format;
        VideoFormat videoFormat2 = (VideoFormat)format2;
        videoFormat2.size = this.size != null ? this.size : videoFormat.size;
        videoFormat2.maxDataLength = this.maxDataLength != -1 ? this.maxDataLength : videoFormat.maxDataLength;
        videoFormat2.frameRate = this.frameRate != -1.0f ? this.frameRate : videoFormat.frameRate;
        return videoFormat2;
    }

    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof VideoFormat)) {
            return true;
        }
        VideoFormat videoFormat = (VideoFormat)format;
        return !(this.size != null && videoFormat.size != null && !this.size.equals(videoFormat.size) || this.frameRate != -1.0f && videoFormat.frameRate != -1.0f && this.frameRate != videoFormat.frameRate);
    }

    public Format relax() {
        VideoFormat videoFormat = (VideoFormat)super.relax();
        if (videoFormat == null) {
            return null;
        }
        videoFormat.size = null;
        videoFormat.maxDataLength = -1;
        videoFormat.frameRate = -1.0f;
        return videoFormat;
    }

    public String toString() {
        String string = "";
        string = this.getEncoding() != null ? String.valueOf(string) + this.getEncoding().toUpperCase() : String.valueOf(string) + "N/A";
        if (this.size != null) {
            string = String.valueOf(string) + ", " + this.size.width + "x" + this.size.height;
        }
        if (this.frameRate != -1.0f) {
            string = String.valueOf(string) + ", FrameRate=" + (float)((int)(this.frameRate * 10.0f)) / 10.0f;
        }
        if (this.maxDataLength != -1) {
            string = String.valueOf(string) + ", Length=" + this.maxDataLength;
        }
        if (this.dataType != null && this.dataType != Format.byteArray) {
            string = String.valueOf(string) + ", " + this.dataType;
        }
        return string;
    }
}

