/*
 * Decompiled with CFR 0.152.
 */
package javax.media.cdm;

import com.sun.media.util.Registry;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;

public class CaptureDeviceManager
extends javax.media.CaptureDeviceManager {
    static Vector devices = null;

    static {
        CaptureDeviceManager.readFromRegistry();
    }

    public CaptureDeviceManager() {
        CaptureDeviceManager.readFromRegistry();
    }

    public static synchronized boolean addDevice(CaptureDeviceInfo captureDeviceInfo) {
        if (captureDeviceInfo != null) {
            if (devices == null) {
                devices = new Vector();
            } else {
                Enumeration enumeration = devices.elements();
                while (enumeration.hasMoreElements()) {
                    CaptureDeviceInfo captureDeviceInfo2 = (CaptureDeviceInfo)enumeration.nextElement();
                    if (!captureDeviceInfo2.equals(captureDeviceInfo)) continue;
                    return false;
                }
            }
            devices.addElement(captureDeviceInfo);
            return true;
        }
        return false;
    }

    public static synchronized void commit() throws IOException {
        Registry registry = new Registry();
        Registry.removeGroup("CDM");
        if (devices == null) {
            Registry.set("CDM.nDevices", new Integer(0));
        } else {
            Registry.set("CDM.nDevices", new Integer(devices.size()));
            int n2 = 0;
            Enumeration enumeration = devices.elements();
            while (enumeration.hasMoreElements()) {
                CaptureDeviceInfo captureDeviceInfo = (CaptureDeviceInfo)enumeration.nextElement();
                Registry.set("CDM." + n2, captureDeviceInfo);
                ++n2;
            }
        }
        try {
            Registry.commit();
        }
        catch (Exception exception) {
            System.err.println("Exception on commit = " + exception);
        }
    }

    public static synchronized CaptureDeviceInfo getDevice(String string) {
        if (devices == null) {
            return null;
        }
        Enumeration enumeration = devices.elements();
        while (enumeration.hasMoreElements()) {
            CaptureDeviceInfo captureDeviceInfo = (CaptureDeviceInfo)enumeration.nextElement();
            if (!captureDeviceInfo.getName().equals(string)) continue;
            return captureDeviceInfo;
        }
        return null;
    }

    public static synchronized Vector getDeviceList() {
        return CaptureDeviceManager.getDeviceList(null);
    }

    public static synchronized Vector getDeviceList(Format format) {
        if (devices == null) {
            return null;
        }
        if (format == null) {
            return devices;
        }
        Vector<CaptureDeviceInfo> vector = new Vector<CaptureDeviceInfo>();
        Enumeration enumeration = devices.elements();
        block0: while (enumeration.hasMoreElements()) {
            CaptureDeviceInfo captureDeviceInfo = (CaptureDeviceInfo)enumeration.nextElement();
            Format[] formatArray = captureDeviceInfo.getFormats();
            int n2 = 0;
            while (n2 < formatArray.length) {
                if (formatArray[n2].matches(format)) {
                    vector.addElement(captureDeviceInfo);
                    continue block0;
                }
                ++n2;
            }
        }
        if (vector.size() > 0) {
            return vector;
        }
        return null;
    }

    private static synchronized void readFromRegistry() {
        if (devices != null) {
            return;
        }
        devices = new Vector();
        Registry registry = new Registry();
        Object object = Registry.get("CDM.nDevices");
        if (object == null || (Integer)object == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < (Integer)object) {
            Object object2 = Registry.get("CDM." + n2);
            if (object2 != null && object2 instanceof CaptureDeviceInfo) {
                devices.addElement(object2);
            }
            ++n2;
        }
    }

    public static synchronized boolean removeDevice(CaptureDeviceInfo captureDeviceInfo) {
        if (devices == null || captureDeviceInfo == null || captureDeviceInfo.getName() == null) {
            return false;
        }
        Enumeration enumeration = devices.elements();
        while (enumeration.hasMoreElements()) {
            CaptureDeviceInfo captureDeviceInfo2 = (CaptureDeviceInfo)enumeration.nextElement();
            if (captureDeviceInfo2 != captureDeviceInfo) continue;
            devices.removeElement(captureDeviceInfo2);
            return true;
        }
        return false;
    }
}

