/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import com.sun.media.ExtBuffer;
import com.sun.media.Log;
import com.sun.media.SimpleGraphBuilder;
import java.awt.Component;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;

public class CodecChain {
    static final int STAGES = 5;
    protected Codec[] codecs = null;
    protected Buffer[] buffers = null;
    protected Format[] formats = null;
    protected Renderer renderer = null;
    private boolean deallocated = true;
    protected boolean firstBuffer = true;
    private boolean rtpFormat = false;

    protected boolean buildChain(Format format) {
        String string;
        Vector vector = new Vector(10);
        Vector vector2 = SimpleGraphBuilder.findRenderingChain(format, vector);
        if (vector2 == null) {
            return false;
        }
        int n2 = vector2.size();
        this.codecs = new Codec[n2 - 1];
        this.buffers = new ExtBuffer[n2 - 1];
        this.formats = new Format[n2];
        this.formats[0] = format;
        Log.comment("Monitor codec chain:");
        int n3 = 0;
        while (n3 < this.codecs.length) {
            this.codecs[n3] = (Codec)vector2.elementAt(n2 - n3 - 1);
            this.formats[n3 + 1] = (Format)vector.elementAt(n2 - n3 - 2);
            this.buffers[n3] = new ExtBuffer();
            this.buffers[n3].setFormat(this.formats[n3 + 1]);
            Log.write("    codec: " + this.codecs[n3]);
            Log.write("      format: " + this.formats[n3]);
            ++n3;
        }
        this.renderer = (Renderer)vector2.elementAt(0);
        Log.write("    renderer: " + this.renderer);
        Log.write("      format: " + this.formats[this.codecs.length] + "\n");
        if (format.getEncoding() != null && (string = format.getEncoding().toUpperCase()).endsWith("RTP")) {
            this.rtpFormat = true;
        }
        return true;
    }

    public void close() {
        int n2 = 0;
        while (n2 < this.codecs.length) {
            this.codecs[n2].close();
            ++n2;
        }
        if (this.renderer != null) {
            this.renderer.close();
        }
    }

    public void deallocate() {
        if (this.deallocated) {
            return;
        }
        if (this.renderer != null) {
            this.renderer.close();
        }
        this.deallocated = true;
    }

    private int doProcess(int n2, Buffer buffer, boolean bl) {
        int n3;
        Codec codec;
        Format format = buffer.getFormat();
        if (n2 == this.codecs.length) {
            if (bl) {
                if (this.renderer != null && this.formats[n2] != null && this.formats[n2] != format && !this.formats[n2].equals(format) && !buffer.isDiscard()) {
                    if (this.renderer.setInputFormat(format) == null) {
                        Log.error("Monitor failed to handle mid-stream format change:");
                        Log.error("  old: " + this.formats[n2]);
                        Log.error("  new: " + format);
                        return 1;
                    }
                    this.formats[n2] = format;
                }
                try {
                    return this.renderer.process(buffer);
                }
                catch (Exception exception) {
                    Log.dumpStack(exception);
                    return 1;
                }
                catch (Error error) {
                    Log.dumpStack(error);
                    return 1;
                }
            }
            return 0;
        }
        if (this.isRawFormat(format)) {
            if (!bl) {
                return 0;
            }
        } else if (!this.rtpFormat && this.firstBuffer) {
            if ((buffer.getFlags() & 0x10) == 0) {
                return 0;
            }
            this.firstBuffer = false;
        }
        if ((codec = this.codecs[n2]) != null && this.formats[n2] != null && this.formats[n2] != format && !this.formats[n2].equals(format) && !buffer.isDiscard()) {
            if (codec.setInputFormat(format) == null) {
                Log.error("Monitor failed to handle mid-stream format change:");
                Log.error("  old: " + this.formats[n2]);
                Log.error("  new: " + format);
                return 1;
            }
            this.formats[n2] = format;
        }
        do {
            try {
                n3 = codec.process(buffer, this.buffers[n2]);
            }
            catch (Exception exception) {
                Log.dumpStack(exception);
                return 1;
            }
            catch (Error error) {
                Log.dumpStack(error);
                return 1;
            }
            if (n3 == 1) {
                return 1;
            }
            if ((n3 & 4) != 0) continue;
            if (!this.buffers[n2].isDiscard() && !this.buffers[n2].isEOM()) {
                this.doProcess(n2 + 1, this.buffers[n2], bl);
            }
            this.buffers[n2].setOffset(0);
            this.buffers[n2].setLength(0);
            this.buffers[n2].setFlags(0);
        } while ((n3 & 2) != 0);
        return n3;
    }

    public Component getControlComponent() {
        return null;
    }

    boolean isRawFormat(Format format) {
        return false;
    }

    public boolean prefetch() {
        if (!this.deallocated) {
            return true;
        }
        try {
            this.renderer.open();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            return false;
        }
        this.renderer.start();
        this.deallocated = false;
        return true;
    }

    public int process(Buffer buffer, boolean bl) {
        int n2 = 0;
        return this.doProcess(n2, buffer, bl);
    }

    public void reset() {
        this.firstBuffer = true;
        int n2 = 0;
        while (n2 < this.codecs.length) {
            if (this.codecs[n2] != null) {
                this.codecs[n2].reset();
            }
            ++n2;
        }
    }
}

