/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.VideoSize;
import com.sun.media.ui.VideoSizeControl;
import com.sun.media.util.JMFI18N;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class VideoFormatChooser
extends Panel
implements ItemListener,
ActionListener {
    public static final String ACTION_TRACK_ENABLED = "ACTION_VIDEO_TRACK_ENABLED";
    public static final String ACTION_TRACK_DISABLED = "ACTION_VIDEO_TRACK_DISABLED";
    private VideoFormat formatOld;
    private Format[] arrSupportedFormats = null;
    private float[] customFrameRates = null;
    private Vector vectorContSuppFormats = new Vector();
    private boolean boolDisplayEnableTrack;
    private ActionListener listenerEnableTrack;
    private boolean boolEnableTrackSaved = true;
    private Checkbox checkEnableTrack;
    private Label labelEncoding;
    private Choice comboEncoding;
    private Label labelSize;
    private VideoSizeControl controlSize;
    private Label labelFrameRate;
    private Choice comboFrameRate;
    private Label labelExtra;
    private Choice comboExtra;
    private int nWidthLabel = 0;
    private int nWidthData = 0;
    private static final int MARGINH = 12;
    private static final int MARGINV = 6;
    private static final float[] standardCaptureRates = new float[]{15.0f, 1.0f, 2.0f, 5.0f, 7.5f, 10.0f, 12.5f, 20.0f, 24.0f, 25.0f, 30.0f};
    private static final String DEFAULT_STRING = JMFI18N.getResource("formatchooser.default");

    public VideoFormatChooser(Format[] formatArray, VideoFormat videoFormat) {
        this(formatArray, videoFormat, false, null, null);
    }

    public VideoFormatChooser(Format[] formatArray, VideoFormat videoFormat, boolean bl, ActionListener actionListener) {
        this(formatArray, videoFormat, bl, actionListener, null);
    }

    public VideoFormatChooser(Format[] formatArray, VideoFormat videoFormat, boolean bl, ActionListener actionListener, boolean bl2) {
        this(formatArray, videoFormat, bl, actionListener, (float[])(bl2 ? standardCaptureRates : null));
    }

    public VideoFormatChooser(Format[] formatArray, VideoFormat videoFormat, boolean bl, ActionListener actionListener, float[] fArray) {
        this.arrSupportedFormats = formatArray;
        this.boolDisplayEnableTrack = bl;
        this.listenerEnableTrack = actionListener;
        this.customFrameRates = fArray;
        int n2 = this.arrSupportedFormats.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.arrSupportedFormats[n3] instanceof VideoFormat) {
                this.vectorContSuppFormats.addElement(this.arrSupportedFormats[n3]);
            }
            ++n3;
        }
        this.formatOld = this.isFormatSupported(videoFormat) ? videoFormat : null;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public VideoFormatChooser(Format[] formatArray, VideoFormat videoFormat, float[] fArray) {
        this(formatArray, videoFormat, false, null, fArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Size Changed")) {
            this.updateFieldsFromSize(this.formatOld);
        }
    }

    public void doLayout() {
        Dimension dimension;
        this.getPreferredSize();
        int n2 = 0;
        int n3 = 0;
        int n4 = this.nWidthLabel + 12;
        Dimension dimension2 = this.getSize();
        if (this.boolDisplayEnableTrack) {
            dimension = this.checkEnableTrack.getPreferredSize();
            this.checkEnableTrack.setBounds(n3, n2, dimension.width, dimension.height);
            n2 += dimension.height + 6;
        }
        Dimension dimension3 = this.labelEncoding.getPreferredSize();
        dimension = this.comboEncoding.getPreferredSize();
        this.labelEncoding.setBounds(n3, n2, this.nWidthLabel, dimension3.height);
        this.comboEncoding.setBounds(n4, n2, dimension2.width - n4, dimension.height);
        dimension3 = this.labelSize.getPreferredSize();
        dimension = this.controlSize.getPreferredSize();
        this.labelSize.setBounds(n3, n2 += Math.max(dimension3.height, dimension.height) + 6, this.nWidthLabel, dimension3.height);
        this.controlSize.setBounds(n4, n2, dimension2.width - n4, dimension.height);
        dimension3 = this.labelFrameRate.getPreferredSize();
        dimension = this.comboFrameRate.getPreferredSize();
        this.labelFrameRate.setBounds(n3, n2 += Math.max(dimension3.height, dimension.height) + 6, this.nWidthLabel, dimension3.height);
        this.comboFrameRate.setBounds(n4, n2, dimension2.width - n4, dimension.height);
        dimension3 = this.labelExtra.getPreferredSize();
        dimension = this.comboExtra.getPreferredSize();
        this.labelExtra.setBounds(n3, n2 += Math.max(dimension3.height, dimension.height) + 6, this.nWidthLabel, dimension3.height);
        this.comboExtra.setBounds(n4, n2, dimension2.width - n4, dimension.height);
        n2 += Math.max(dimension3.height, dimension.height) + 6;
    }

    private void enableControls(boolean bl) {
        this.labelEncoding.setEnabled(bl);
        this.comboEncoding.setEnabled(bl);
        this.labelSize.setEnabled(bl);
        this.controlSize.setEnabled(bl);
        this.labelFrameRate.setEnabled(bl);
        this.comboFrameRate.setEnabled(bl);
        this.labelExtra.setEnabled(bl);
        this.comboExtra.setEnabled(bl);
    }

    public Format getFormat() {
        VideoFormat videoFormat;
        String string = null;
        VideoFormat videoFormat2 = null;
        String string2 = this.comboEncoding.getSelectedItem();
        int n2 = this.vectorContSuppFormats.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e2 = this.vectorContSuppFormats.elementAt(n3);
            if (e2 instanceof VideoFormat && this.isFormatGoodForEncoding(videoFormat2 = (VideoFormat)e2) && this.isFormatGoodForVideoSize(videoFormat2) && this.isFormatGoodForFrameRate(videoFormat2)) {
                YUVFormat yUVFormat;
                int n4;
                if (string2.equalsIgnoreCase("rgb") && videoFormat2 instanceof RGBFormat) {
                    RGBFormat rGBFormat = (RGBFormat)videoFormat2;
                    Integer n5 = new Integer(rGBFormat.getBitsPerPixel());
                    String string3 = n5.toString();
                    if (this.comboExtra.getSelectedItem().equals(string3)) break;
                } else if (!string2.equalsIgnoreCase("yuv") || !(videoFormat2 instanceof YUVFormat) || (string = this.getYuvType(n4 = (yUVFormat = (YUVFormat)videoFormat2).getYuvType())) != null && this.comboExtra.getSelectedItem().equals(string)) break;
            }
            ++n3;
        }
        if (n3 >= n2) {
            return null;
        }
        if (videoFormat2.getSize() == null) {
            videoFormat = new VideoFormat(null, this.controlSize.getVideoSize(), -1, null, -1.0f);
            videoFormat2 = (VideoFormat)videoFormat.intersects(videoFormat2);
        }
        if (this.customFrameRates != null && videoFormat2 != null) {
            videoFormat = new VideoFormat(null, null, -1, null, this.getFrameRate());
            videoFormat2 = (VideoFormat)videoFormat.intersects(videoFormat2);
        }
        return videoFormat2;
    }

    public float getFrameRate() {
        String string = this.comboFrameRate.getSelectedItem();
        if (string != null) {
            if (string.equals(DEFAULT_STRING)) {
                return -1.0f;
            }
            try {
                float f2 = Float.valueOf(string).floatValue();
                return f2;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return -1.0f;
    }

    public Dimension getPreferredSize() {
        Dimension dimension;
        Dimension dimension2 = new Dimension();
        if (this.boolDisplayEnableTrack) {
            dimension = this.checkEnableTrack.getPreferredSize();
            dimension2.width = Math.max(dimension2.width, dimension.width);
            dimension2.height += dimension.height + 6;
        }
        Dimension dimension3 = this.labelEncoding.getPreferredSize();
        this.nWidthLabel = Math.max(this.nWidthLabel, dimension3.width);
        dimension = this.comboEncoding.getPreferredSize();
        this.nWidthData = Math.max(this.nWidthData, dimension.width);
        dimension2.height += Math.max(dimension3.height, dimension.height) + 6;
        dimension3 = this.labelSize.getPreferredSize();
        this.nWidthLabel = Math.max(this.nWidthLabel, dimension3.width);
        dimension = this.controlSize.getPreferredSize();
        this.nWidthData = Math.max(this.nWidthData, dimension.width);
        dimension2.height += Math.max(dimension3.height, dimension.height) + 6;
        dimension3 = this.labelFrameRate.getPreferredSize();
        this.nWidthLabel = Math.max(this.nWidthLabel, dimension3.width);
        dimension = this.comboFrameRate.getPreferredSize();
        this.nWidthData = Math.max(this.nWidthData, dimension.width);
        dimension2.height += Math.max(dimension3.height, dimension.height) + 6;
        dimension3 = this.labelExtra.getPreferredSize();
        this.nWidthLabel = Math.max(this.nWidthLabel, dimension3.width);
        dimension = this.comboExtra.getPreferredSize();
        this.nWidthData = Math.max(this.nWidthData, dimension.width);
        dimension2.height += Math.max(dimension3.height, dimension.height);
        dimension2.width = Math.max(dimension2.width, this.nWidthLabel + 12 + this.nWidthData);
        return dimension2;
    }

    private String getYuvType(int n2) {
        String string = null;
        string = (n2 & 2) == 2 ? JMFI18N.getResource("formatchooser.yuv.4:2:0") : ((n2 & 4) == 4 ? JMFI18N.getResource("formatchooser.yuv.4:2:2") : ((n2 & 0x20) == 32 ? JMFI18N.getResource("formatchooser.yuv.YUYV") : ((n2 & 8) == 8 ? JMFI18N.getResource("formatchooser.yuv.1:1:1") : ((n2 & 1) == 1 ? JMFI18N.getResource("formatchooser.yuv.4:1:1") : ((n2 & 0x10) == 16 ? JMFI18N.getResource("formatchooser.yuv.YVU9") : null)))));
        return string;
    }

    private void init() throws Exception {
        this.setLayout(null);
        this.checkEnableTrack = new Checkbox(JMFI18N.getResource("formatchooser.enabletrack"), true);
        this.checkEnableTrack.addItemListener(this);
        if (this.boolDisplayEnableTrack) {
            this.add(this.checkEnableTrack);
        }
        this.labelEncoding = new Label(JMFI18N.getResource("formatchooser.encoding"), 2);
        this.add(this.labelEncoding);
        this.comboEncoding = new Choice();
        this.comboEncoding.addItemListener(this);
        this.add(this.comboEncoding);
        this.labelSize = new Label(JMFI18N.getResource("formatchooser.videosize"), 2);
        this.add(this.labelSize);
        if (this.formatOld == null) {
            this.controlSize = new VideoSizeControl();
        } else {
            VideoSize videoSize = new VideoSize(this.formatOld.getSize());
            this.controlSize = new VideoSizeControl(videoSize);
        }
        this.controlSize.addActionListener(this);
        this.add(this.controlSize);
        this.labelFrameRate = new Label(JMFI18N.getResource("formatchooser.framerate"), 2);
        this.add(this.labelFrameRate);
        this.comboFrameRate = new Choice();
        this.comboFrameRate.addItemListener(this);
        this.add(this.comboFrameRate);
        this.labelExtra = new Label("Extra:", 2);
        this.labelExtra.setVisible(false);
        this.add(this.labelExtra);
        this.comboExtra = new Choice();
        this.comboExtra.setVisible(false);
        this.add(this.comboExtra);
        this.updateFields(this.formatOld);
    }

    private boolean isFormatGoodForEncoding(VideoFormat videoFormat) {
        boolean bl = false;
        String string = this.comboEncoding.getSelectedItem();
        if (string != null) {
            bl = videoFormat.getEncoding().equalsIgnoreCase(string);
        }
        return bl;
    }

    private boolean isFormatGoodForFrameRate(VideoFormat videoFormat) {
        boolean bl = false;
        if (this.customFrameRates != null) {
            return true;
        }
        String string = this.comboFrameRate.getSelectedItem();
        if (string.equals(DEFAULT_STRING)) {
            return true;
        }
        float f2 = videoFormat.getFrameRate();
        if (f2 == -1.0f) {
            return true;
        }
        if (string != null) {
            float f3 = Float.valueOf(string).floatValue();
            bl = f3 == f2;
        }
        return bl;
    }

    private boolean isFormatGoodForVideoSize(VideoFormat videoFormat) {
        boolean bl = false;
        VideoSize videoSize = this.controlSize.getVideoSize();
        Dimension dimension = videoFormat.getSize();
        bl = dimension == null ? true : videoSize.equals(dimension);
        return bl;
    }

    private boolean isFormatSupported(VideoFormat videoFormat) {
        boolean bl = false;
        if (videoFormat == null) {
            return bl;
        }
        int n2 = this.vectorContSuppFormats.size();
        int n3 = 0;
        while (n3 < n2 && !bl) {
            VideoFormat videoFormat2 = (VideoFormat)this.vectorContSuppFormats.elementAt(n3);
            if (videoFormat2.matches(videoFormat)) {
                bl = true;
            }
            ++n3;
        }
        return bl;
    }

    public boolean isTrackEnabled() {
        boolean bl = this.checkEnableTrack.getState();
        return bl;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.checkEnableTrack) {
            this.boolEnableTrackSaved = this.checkEnableTrack.getState();
            this.onEnableTrack(true);
        } else if (object == this.comboEncoding) {
            this.updateFieldsFromEncoding(this.formatOld);
        } else if (object == this.controlSize) {
            this.updateFieldsFromSize(this.formatOld);
        } else if (object == this.comboFrameRate) {
            this.updateFieldsFromRate(this.formatOld);
        }
    }

    private void onEnableTrack(boolean bl) {
        boolean bl2 = this.checkEnableTrack.getState();
        this.enableControls(bl2 && this.isEnabled());
        if (bl && this.listenerEnableTrack != null) {
            ActionEvent actionEvent = bl2 ? new ActionEvent(this, 1001, ACTION_TRACK_ENABLED) : new ActionEvent(this, 1001, ACTION_TRACK_DISABLED);
            this.listenerEnableTrack.actionPerformed(actionEvent);
        }
    }

    public void setCurrentFormat(VideoFormat videoFormat) {
        if (this.isFormatSupported(videoFormat)) {
            this.formatOld = videoFormat;
        }
        this.updateFields(this.formatOld);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.checkEnableTrack != null) {
            this.checkEnableTrack.setEnabled(bl);
        }
        this.enableControls(bl);
    }

    public void setFrameRate(float f2) {
        int n2 = 0;
        while (n2 < this.comboFrameRate.getItemCount()) {
            float f3 = Float.valueOf(this.comboFrameRate.getItem(n2)).floatValue();
            if ((double)Math.abs(f2 - f3) < 0.5) {
                this.comboFrameRate.select(n2);
                return;
            }
            ++n2;
        }
    }

    public void setSupportedFormats(Vector vector) {
        this.vectorContSuppFormats = vector;
        if (vector.isEmpty()) {
            this.checkEnableTrack.setState(false);
            this.checkEnableTrack.setEnabled(false);
            this.onEnableTrack(true);
            return;
        }
        this.checkEnableTrack.setEnabled(true);
        this.checkEnableTrack.setState(this.boolEnableTrackSaved);
        this.onEnableTrack(true);
        if (!this.isFormatSupported(this.formatOld)) {
            this.formatOld = null;
        }
        this.updateFields(this.formatOld);
    }

    public void setSupportedFormats(Format[] formatArray, VideoFormat videoFormat) {
        this.arrSupportedFormats = formatArray;
        this.vectorContSuppFormats.removeAllElements();
        int n2 = this.arrSupportedFormats.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.arrSupportedFormats[n3] instanceof VideoFormat) {
                this.vectorContSuppFormats.addElement(this.arrSupportedFormats[n3]);
            }
            ++n3;
        }
        this.formatOld = this.isFormatSupported(videoFormat) ? videoFormat : null;
        this.setSupportedFormats(this.vectorContSuppFormats);
    }

    public void setTrackEnabled(boolean bl) {
        this.boolEnableTrackSaved = bl;
        if (this.checkEnableTrack == null) {
            return;
        }
        this.checkEnableTrack.setState(bl);
        this.onEnableTrack(true);
    }

    private void updateFields(VideoFormat videoFormat) {
        String string;
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        boolean bl = this.comboEncoding.isEnabled();
        this.comboEncoding.setEnabled(false);
        this.comboEncoding.removeAll();
        int n2 = this.vectorContSuppFormats.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e2 = this.vectorContSuppFormats.elementAt(n3);
            if (e2 instanceof VideoFormat) {
                VideoFormat videoFormat2 = (VideoFormat)e2;
                string = videoFormat2.getEncoding().toUpperCase();
                if (string2 == null) {
                    string2 = string;
                }
                if (!vector.contains(string)) {
                    this.comboEncoding.addItem(string);
                    vector.addElement(string);
                }
            }
            ++n3;
        }
        if (videoFormat != null) {
            string = videoFormat.getEncoding().toUpperCase();
            this.comboEncoding.select(string);
        } else if (string2 != null) {
            this.comboEncoding.select(string2);
        } else if (this.comboEncoding.getItemCount() > 0) {
            this.comboEncoding.select(0);
        }
        this.updateFieldsFromEncoding(videoFormat);
        this.comboEncoding.setEnabled(bl);
    }

    private void updateFieldsFromEncoding(VideoFormat videoFormat) {
        VideoSize videoSize;
        Dimension dimension;
        VideoSize videoSize2 = null;
        boolean bl = false;
        boolean bl2 = this.controlSize.isEnabled();
        this.controlSize.setEnabled(false);
        this.controlSize.removeAll();
        int n2 = this.vectorContSuppFormats.size();
        int n3 = 0;
        while (n3 < n2) {
            VideoFormat videoFormat2;
            Object e2 = this.vectorContSuppFormats.elementAt(n3);
            if (e2 instanceof VideoFormat && this.isFormatGoodForEncoding(videoFormat2 = (VideoFormat)e2)) {
                dimension = videoFormat2.getSize();
                videoSize = dimension == null ? null : new VideoSize(dimension);
                if (!bl) {
                    bl = true;
                    videoSize2 = videoSize;
                }
                this.controlSize.addItem(videoSize);
            }
            ++n3;
        }
        if (videoFormat != null && this.isFormatGoodForEncoding(videoFormat)) {
            dimension = videoFormat.getSize();
            videoSize = dimension == null ? null : new VideoSize(dimension);
            this.controlSize.select(videoSize);
        } else if (bl) {
            this.controlSize.select(videoSize2);
        } else if (this.controlSize.getItemCount() > 0) {
            this.controlSize.select(0);
        }
        this.updateFieldsFromSize(videoFormat);
        this.controlSize.setEnabled(bl2);
    }

    private void updateFieldsFromRate(VideoFormat videoFormat) {
        YUVFormat yUVFormat;
        int n2;
        Integer n3;
        RGBFormat rGBFormat;
        String string = null;
        Vector<Object> vector = new Vector<Object>();
        boolean bl = false;
        boolean bl2 = false;
        String string2 = this.comboEncoding.getSelectedItem();
        if (string2 == null) {
            return;
        }
        if (string2.equalsIgnoreCase("rgb")) {
            this.labelExtra.setText(JMFI18N.getResource("formatchooser.bitsperpixel"));
            this.labelExtra.setVisible(true);
            this.comboExtra.setVisible(true);
            bl = true;
        } else if (string2.equalsIgnoreCase("yuv")) {
            this.labelExtra.setText(JMFI18N.getResource("formatchooser.yuvtype"));
            this.labelExtra.setVisible(true);
            this.comboExtra.setVisible(true);
            bl2 = true;
        } else {
            this.labelExtra.setVisible(false);
            this.comboExtra.setVisible(false);
            return;
        }
        boolean bl3 = this.comboExtra.isEnabled();
        this.comboExtra.setEnabled(false);
        this.comboExtra.removeAll();
        int n4 = this.vectorContSuppFormats.size();
        int n5 = 0;
        while (n5 < n4) {
            VideoFormat videoFormat2;
            Object e2 = this.vectorContSuppFormats.elementAt(n5);
            if (e2 instanceof VideoFormat && this.isFormatGoodForEncoding(videoFormat2 = (VideoFormat)e2) && this.isFormatGoodForVideoSize(videoFormat2) && this.isFormatGoodForFrameRate(videoFormat2)) {
                if (bl && videoFormat2 instanceof RGBFormat) {
                    rGBFormat = (RGBFormat)videoFormat2;
                    n3 = new Integer(rGBFormat.getBitsPerPixel());
                    if (!vector.contains(n3)) {
                        this.comboExtra.addItem(n3.toString());
                        vector.addElement(n3);
                    }
                } else if (bl2 && videoFormat2 instanceof YUVFormat && (string = this.getYuvType(n2 = (yUVFormat = (YUVFormat)videoFormat2).getYuvType())) != null && !vector.contains(string)) {
                    this.comboExtra.addItem(string);
                    vector.addElement(string);
                }
            }
            ++n5;
        }
        if (videoFormat != null && this.isFormatGoodForEncoding(videoFormat) && this.isFormatGoodForVideoSize(videoFormat) && this.isFormatGoodForFrameRate(videoFormat)) {
            if (bl && videoFormat instanceof RGBFormat) {
                rGBFormat = (RGBFormat)videoFormat;
                n3 = new Integer(rGBFormat.getBitsPerPixel());
                this.comboExtra.select(n3.toString());
            } else if (bl2 && videoFormat instanceof YUVFormat) {
                yUVFormat = (YUVFormat)videoFormat;
                n2 = yUVFormat.getYuvType();
                string = this.getYuvType(n2);
                if (string != null) {
                    this.comboExtra.select(string);
                }
            } else if (this.comboExtra.getItemCount() > 0) {
                this.comboExtra.select(0);
            }
        } else if (this.comboExtra.getItemCount() > 0) {
            this.comboExtra.select(0);
        }
        this.comboExtra.setEnabled(bl3);
    }

    private void updateFieldsFromSize(VideoFormat videoFormat) {
        Float f2;
        int n2;
        Float f3 = null;
        Vector<Float> vector = new Vector<Float>();
        boolean bl = this.comboFrameRate.isEnabled();
        this.comboFrameRate.setEnabled(false);
        if (this.customFrameRates == null) {
            this.comboFrameRate.removeAll();
        } else if (this.comboFrameRate.getItemCount() < 1) {
            n2 = 0;
            while (n2 < this.customFrameRates.length) {
                this.comboFrameRate.addItem(Float.toString(this.customFrameRates[n2]));
                ++n2;
            }
        }
        int n3 = this.vectorContSuppFormats.size();
        n2 = 0;
        while (n2 < n3) {
            VideoFormat videoFormat2;
            Object e2 = this.vectorContSuppFormats.elementAt(n2);
            if (e2 instanceof VideoFormat && this.isFormatGoodForEncoding(videoFormat2 = (VideoFormat)e2) && this.isFormatGoodForVideoSize(videoFormat2) && this.customFrameRates == null) {
                f2 = new Float(videoFormat2.getFrameRate());
                if (f3 == null) {
                    f3 = f2;
                }
                if (!vector.contains(f2)) {
                    if (f2.floatValue() == -1.0f) {
                        this.comboFrameRate.addItem(DEFAULT_STRING);
                    } else {
                        this.comboFrameRate.addItem(f2.toString());
                    }
                    vector.addElement(f2);
                }
            }
            ++n2;
        }
        if (videoFormat != null && this.customFrameRates == null && this.isFormatGoodForEncoding(videoFormat) && this.isFormatGoodForVideoSize(videoFormat)) {
            f2 = new Float(videoFormat.getFrameRate());
            if (f2.floatValue() == -1.0f) {
                this.comboFrameRate.select(DEFAULT_STRING);
            } else {
                this.comboFrameRate.select(f2.toString());
            }
        } else if (f3 != null) {
            if (f3.floatValue() == -1.0f) {
                this.comboFrameRate.select(DEFAULT_STRING);
            } else {
                this.comboFrameRate.select(f3.toString());
            }
        } else if (this.comboFrameRate.getItemCount() > 0) {
            this.comboFrameRate.select(0);
        }
        this.updateFieldsFromRate(videoFormat);
        this.comboFrameRate.setEnabled(bl);
    }
}

