/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.sun.media.rtp.util.Packet;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class RTPPacket
extends Packet {
    public Packet base;
    public boolean extensionPresent;
    public int marker;
    public int payloadType;
    public int seqnum;
    public long timestamp;
    public int ssrc;
    public int[] csrc;
    public int extensionType;
    public byte[] extension;
    public int payloadoffset;
    public int payloadlength;

    public RTPPacket() {
    }

    public RTPPacket(Packet packet) {
        super(packet);
        this.base = packet;
    }

    public void assemble(int n2, boolean bl) {
        this.length = n2;
        this.offset = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeByte(128);
            int n3 = this.payloadType;
            if (this.marker == 1) {
                n3 = this.payloadType | 0x80;
            }
            dataOutputStream.writeByte((byte)n3);
            dataOutputStream.writeShort(this.seqnum);
            dataOutputStream.writeInt((int)this.timestamp);
            dataOutputStream.writeInt(this.ssrc);
            dataOutputStream.write(this.base.data, this.payloadoffset, this.payloadlength);
            this.data = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            System.out.println("caught IOException in DOS");
        }
    }

    public int calcLength() {
        return this.payloadlength + 12;
    }

    public Object clone() {
        RTPPacket rTPPacket = new RTPPacket((Packet)this.base.clone());
        rTPPacket.extensionPresent = this.extensionPresent;
        rTPPacket.marker = this.marker;
        rTPPacket.payloadType = this.payloadType;
        rTPPacket.seqnum = this.seqnum;
        rTPPacket.timestamp = this.timestamp;
        rTPPacket.ssrc = this.ssrc;
        rTPPacket.csrc = (int[])this.csrc.clone();
        rTPPacket.extensionType = this.extensionType;
        rTPPacket.extension = this.extension;
        rTPPacket.payloadoffset = this.payloadoffset;
        rTPPacket.payloadlength = this.payloadlength;
        return rTPPacket;
    }

    public String toString() {
        String string = "RTP Packet:\n\tPayload Type: " + this.payloadType + "    Marker: " + this.marker + "\n\tSequence Number: " + this.seqnum + "\n\tTimestamp: " + this.timestamp + "\n\tSSRC (Sync Source): " + this.ssrc + "\n\tPayload Length: " + this.payloadlength + "    Payload Offset: " + this.payloadoffset + "\n";
        if (this.csrc.length > 0) {
            string = String.valueOf(string) + "Contributing sources:  " + this.csrc[0];
            int n2 = 1;
            while (n2 < this.csrc.length) {
                string = String.valueOf(string) + ", " + this.csrc[n2];
                ++n2;
            }
            string = String.valueOf(string) + "\n";
        }
        if (this.extensionPresent) {
            string = String.valueOf(string) + "\tExtension:  type " + this.extensionType + ", length " + this.extension.length + "\n";
        }
        return string;
    }
}

