/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.Log;
import com.sun.media.protocol.rtp.DataSource;
import com.sun.media.rtp.BufferControlImpl;
import com.sun.media.rtp.RTPControlImpl;
import com.sun.media.rtp.RTPDemultiplexer;
import com.sun.media.rtp.RTPRawReceiver;
import com.sun.media.rtp.RTPSourceStream;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.SourceRTPPacket;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketFilter;
import com.sun.media.rtp.util.PacketSource;
import com.sun.media.rtp.util.RTPPacket;
import com.sun.media.rtp.util.SSRCTable;
import com.sun.media.rtp.util.UDPPacket;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.media.Format;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.ActiveReceiveStreamEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.RTPEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;

public class RTPReceiver
extends PacketFilter {
    SSRCCache cache;
    RTPDemultiplexer rtpdemultiplexer;
    int lastseqnum = -1;
    private boolean rtcpstarted = false;
    private boolean setpriority = false;
    private boolean mismatchprinted = false;
    private String content = "";
    SSRCTable probationList = new SSRCTable();
    static final int MAX_DROPOUT = 3000;
    static final int MAX_MISORDER = 100;
    static final int SEQ_MOD = 65536;
    static final int MIN_SEQUENTIAL = 2;
    private boolean initBC = false;
    public String controlstr = "javax.media.rtp.RTPControl";
    private int errorPayload = -1;

    public RTPReceiver(SSRCCache sSRCCache, RTPDemultiplexer rTPDemultiplexer) {
        this.cache = sSRCCache;
        this.rtpdemultiplexer = rTPDemultiplexer;
        this.setConsumer(null);
    }

    public RTPReceiver(SSRCCache sSRCCache, RTPDemultiplexer rTPDemultiplexer, int n2, String string) throws UnknownHostException, IOException {
        this(sSRCCache, rTPDemultiplexer, new RTPRawReceiver(n2 & 0xFFFFFFFE, string, sSRCCache.sm.defaultstats));
    }

    public RTPReceiver(SSRCCache sSRCCache, RTPDemultiplexer rTPDemultiplexer, PacketSource packetSource) {
        this(sSRCCache, rTPDemultiplexer);
        this.setSource(packetSource);
    }

    public RTPReceiver(SSRCCache sSRCCache, RTPDemultiplexer rTPDemultiplexer, DatagramSocket datagramSocket) {
        this(sSRCCache, rTPDemultiplexer, new RTPRawReceiver(datagramSocket, sSRCCache.sm.defaultstats));
    }

    public String filtername() {
        return "RTP Packet Receiver";
    }

    public Packet handlePacket(Packet packet) {
        return this.handlePacket((RTPPacket)packet);
    }

    public Packet handlePacket(Packet packet, int n2) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionAddress) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionAddress, boolean bl) {
        return null;
    }

    public Packet handlePacket(RTPPacket rTPPacket) {
        Object object;
        Object object2;
        boolean bl;
        SSRCInfo sSRCInfo = null;
        if (rTPPacket.base instanceof UDPPacket) {
            InetAddress inetAddress = ((UDPPacket)rTPPacket.base).remoteAddress;
            if (this.cache.sm.bindtome && !this.cache.sm.isBroadcast(this.cache.sm.dataaddress) && !inetAddress.equals(this.cache.sm.dataaddress)) {
                return null;
            }
        } else if (rTPPacket.base instanceof Packet) {
            rTPPacket.base.toString();
        }
        if (sSRCInfo == null) {
            sSRCInfo = rTPPacket.base instanceof UDPPacket ? this.cache.get(rTPPacket.ssrc, ((UDPPacket)rTPPacket.base).remoteAddress, ((UDPPacket)rTPPacket.base).remotePort, 1) : this.cache.get(rTPPacket.ssrc, null, 0, 1);
        }
        if (sSRCInfo == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < rTPPacket.csrc.length) {
            SSRCInfo sSRCInfo2 = null;
            sSRCInfo2 = rTPPacket.base instanceof UDPPacket ? this.cache.get(rTPPacket.csrc[n2], ((UDPPacket)rTPPacket.base).remoteAddress, ((UDPPacket)rTPPacket.base).remotePort, 1) : this.cache.get(rTPPacket.csrc[n2], null, 0, 1);
            if (sSRCInfo2 != null) {
                sSRCInfo2.lastHeardFrom = rTPPacket.receiptTime;
            }
            ++n2;
        }
        if (sSRCInfo.lastPayloadType != -1 && sSRCInfo.lastPayloadType == rTPPacket.payloadType && this.mismatchprinted) {
            return null;
        }
        if (!sSRCInfo.sender) {
            sSRCInfo.initsource(rTPPacket.seqnum);
            sSRCInfo.payloadType = rTPPacket.payloadType;
        }
        int n3 = rTPPacket.seqnum - sSRCInfo.maxseq;
        if (sSRCInfo.maxseq + 1 != rTPPacket.seqnum && n3 > 0) {
            sSRCInfo.stats.update(0, n3 - 1);
        }
        if (sSRCInfo.wrapped) {
            sSRCInfo.wrapped = false;
        }
        boolean bl2 = false;
        if (sSRCInfo.probation > 0) {
            if (rTPPacket.seqnum == sSRCInfo.maxseq + 1) {
                --sSRCInfo.probation;
                sSRCInfo.maxseq = rTPPacket.seqnum;
                if (sSRCInfo.probation == 0) {
                    bl2 = true;
                }
            } else {
                sSRCInfo.probation = 1;
                sSRCInfo.maxseq = rTPPacket.seqnum;
                sSRCInfo.stats.update(2);
            }
        } else if (n3 < 3000) {
            if (rTPPacket.seqnum < sSRCInfo.baseseq) {
                sSRCInfo.cycles += 65536;
                sSRCInfo.wrapped = true;
            }
            sSRCInfo.maxseq = rTPPacket.seqnum;
        } else if (n3 <= 65436) {
            sSRCInfo.stats.update(3);
            if (rTPPacket.seqnum == sSRCInfo.lastbadseq) {
                sSRCInfo.initsource(rTPPacket.seqnum);
            } else {
                sSRCInfo.lastbadseq = rTPPacket.seqnum + 1 & 0xFFFF;
            }
        } else {
            sSRCInfo.stats.update(4);
        }
        if (bl = this.cache.sm.isUnicast()) {
            if (!this.rtcpstarted) {
                this.cache.sm.startRTCPReports(((UDPPacket)rTPPacket.base).remoteAddress);
                this.rtcpstarted = true;
                object2 = this.cache.sm.controladdress.getAddress();
                int n4 = object2[3] & 0xFF;
                if ((n4 & 0xFF) == 255) {
                    this.cache.sm.addUnicastAddr(this.cache.sm.controladdress);
                } else {
                    object = null;
                    boolean bl3 = true;
                    try {
                        object = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException unknownHostException) {
                        bl3 = false;
                    }
                    if (bl3) {
                        this.cache.sm.addUnicastAddr((InetAddress)object);
                    }
                }
            } else if (!this.cache.sm.isSenderDefaultAddr(((UDPPacket)rTPPacket.base).remoteAddress)) {
                this.cache.sm.addUnicastAddr(((UDPPacket)rTPPacket.base).remoteAddress);
            }
        }
        ++sSRCInfo.received;
        sSRCInfo.stats.update(1);
        if (sSRCInfo.probation > 0) {
            this.probationList.put(sSRCInfo.ssrc, rTPPacket.clone());
            return null;
        }
        sSRCInfo.maxseq = rTPPacket.seqnum;
        if (sSRCInfo.lastPayloadType != -1 && sSRCInfo.lastPayloadType != rTPPacket.payloadType) {
            sSRCInfo.currentformat = null;
            if (sSRCInfo.dsource != null && (object2 = (Object)((RTPControlImpl)sSRCInfo.dsource.getControl(this.controlstr))) != null) {
                ((RTPControlImpl)object2).currentformat = null;
                ((RTPControlImpl)object2).payload = -1;
            }
            sSRCInfo.lastPayloadType = rTPPacket.payloadType;
            if (sSRCInfo.dsource != null) {
                try {
                    sSRCInfo.dsource.stop();
                }
                catch (IOException iOException) {
                    System.err.println("Stopping DataSource after PCE " + iOException.getMessage());
                }
            }
            object2 = new RemotePayloadChangeEvent(this.cache.sm, (ReceiveStream)((Object)sSRCInfo), sSRCInfo.lastPayloadType, rTPPacket.payloadType);
            this.cache.eventhandler.postEvent((RTPEvent)object2);
        }
        if (sSRCInfo.currentformat == null) {
            sSRCInfo.currentformat = this.cache.sm.formatinfo.get(rTPPacket.payloadType);
            if (sSRCInfo.currentformat == null) {
                if (this.errorPayload != rTPPacket.payloadType) {
                    Log.error("No format has been registered for RTP Payload type " + rTPPacket.payloadType);
                    this.errorPayload = rTPPacket.payloadType;
                }
                return rTPPacket;
            }
            if (sSRCInfo.dstream != null) {
                sSRCInfo.dstream.setFormat(sSRCInfo.currentformat);
            }
        }
        if (sSRCInfo.currentformat == null) {
            System.err.println("No Format for PT= " + rTPPacket.payloadType);
            return rTPPacket;
        }
        if (sSRCInfo.dsource != null && (object2 = (Object)((RTPControlImpl)sSRCInfo.dsource.getControl(this.controlstr))) != null) {
            Format format;
            ((RTPControlImpl)object2).currentformat = format = this.cache.sm.formatinfo.get(rTPPacket.payloadType);
        }
        if (!this.initBC) {
            ((BufferControlImpl)this.cache.sm.buffercontrol).initBufferControl(sSRCInfo.currentformat);
            this.initBC = true;
        }
        if (!sSRCInfo.streamconnect) {
            object2 = (DataSource)this.cache.sm.dslist.get(sSRCInfo.ssrc);
            if (object2 == null) {
                DataSource dataSource = this.cache.sm.getDataSource(null);
                if (dataSource == null) {
                    object2 = this.cache.sm.createNewDS(null);
                    this.cache.sm.setDefaultDSassigned(sSRCInfo.ssrc);
                } else if (!this.cache.sm.isDefaultDSassigned()) {
                    object2 = dataSource;
                    this.cache.sm.setDefaultDSassigned(sSRCInfo.ssrc);
                } else {
                    object2 = this.cache.sm.createNewDS(sSRCInfo.ssrc);
                }
            }
            PushBufferStream[] pushBufferStreamArray = ((DataSource)object2).getStreams();
            sSRCInfo.dsource = object2;
            sSRCInfo.dstream = (RTPSourceStream)pushBufferStreamArray[0];
            sSRCInfo.dstream.setContentDescriptor(this.content);
            sSRCInfo.dstream.setFormat(sSRCInfo.currentformat);
            object = (RTPControlImpl)sSRCInfo.dsource.getControl(this.controlstr);
            if (object != null) {
                Format format;
                ((RTPControlImpl)object).currentformat = format = this.cache.sm.formatinfo.get(rTPPacket.payloadType);
                ((RTPControlImpl)object).stream = sSRCInfo;
            }
            sSRCInfo.streamconnect = true;
        }
        if (sSRCInfo.dsource != null) {
            sSRCInfo.active = true;
        }
        if (!sSRCInfo.newrecvstream) {
            object2 = new NewReceiveStreamEvent(this.cache.sm, (ReceiveStream)((Object)sSRCInfo));
            sSRCInfo.newrecvstream = true;
            this.cache.eventhandler.postEvent((RTPEvent)object2);
        }
        if (sSRCInfo.lastRTPReceiptTime != 0L && sSRCInfo.lastPayloadType == rTPPacket.payloadType) {
            long l2 = rTPPacket.receiptTime - sSRCInfo.lastRTPReceiptTime;
            long l3 = rTPPacket.timestamp - sSRCInfo.lasttimestamp;
            double d2 = (l2 = l2 * (long)this.cache.clockrate[sSRCInfo.payloadType] / 1000L) - l3;
            if (d2 < 0.0) {
                d2 = -d2;
            }
            sSRCInfo.jitter += 0.0625 * (d2 - sSRCInfo.jitter);
        }
        sSRCInfo.lastRTPReceiptTime = rTPPacket.receiptTime;
        sSRCInfo.lasttimestamp = rTPPacket.timestamp;
        sSRCInfo.payloadType = rTPPacket.payloadType;
        sSRCInfo.lastPayloadType = rTPPacket.payloadType;
        sSRCInfo.bytesreceived += rTPPacket.payloadlength;
        sSRCInfo.lastHeardFrom = rTPPacket.receiptTime;
        if (sSRCInfo.quiet) {
            sSRCInfo.quiet = false;
            ActiveReceiveStreamEvent activeReceiveStreamEvent = null;
            activeReceiveStreamEvent = sSRCInfo instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, (ReceiveStream)((Object)sSRCInfo)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, null);
            this.cache.eventhandler.postEvent(activeReceiveStreamEvent);
        }
        SourceRTPPacket sourceRTPPacket = new SourceRTPPacket(rTPPacket, sSRCInfo);
        if (sSRCInfo.dsource != null) {
            RTPPacket rTPPacket2;
            if (this.mismatchprinted) {
                this.mismatchprinted = false;
            }
            if (bl2 && (rTPPacket2 = (RTPPacket)this.probationList.remove(sSRCInfo.ssrc)) != null) {
                this.rtpdemultiplexer.demuxpayload(new SourceRTPPacket(rTPPacket2, sSRCInfo));
            }
            this.rtpdemultiplexer.demuxpayload(sourceRTPPacket);
        }
        return rTPPacket;
    }
}

