/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPPacket;
import com.sun.media.rtp.util.Packet;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class RTCPCompoundPacket
extends RTCPPacket {
    RTCPPacket[] packets;

    public RTCPCompoundPacket(Packet packet) {
        super(packet);
        this.type = -1;
    }

    public RTCPCompoundPacket(RTCPPacket[] rTCPPacketArray) {
        this.packets = rTCPPacketArray;
        this.type = -1;
        this.received = false;
    }

    public void assemble(int n2, boolean bl) {
        int n3;
        int n4;
        this.length = n2;
        this.offset = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            if (bl) {
                this.offset += 4;
            }
            n4 = this.offset;
            n3 = 0;
            while (n3 < this.packets.length) {
                n4 = byteArrayOutputStream.size();
                this.packets[n3].assemble(dataOutputStream);
                ++n3;
            }
        }
        catch (IOException iOException) {
            throw new NullPointerException("Impossible IO Exception");
        }
        n3 = byteArrayOutputStream.size();
        this.data = byteArrayOutputStream.toByteArray();
        if (n3 > n2) {
            throw new NullPointerException("RTCP Packet overflow");
        }
        if (n3 < n2) {
            if (this.data.length < n2) {
                this.data = new byte[n2];
                System.arraycopy(this.data, 0, this.data, 0, n3);
            }
            int n5 = n4;
            this.data[n5] = (byte)(this.data[n5] | 0x20);
            this.data[n2 - 1] = (byte)(n2 - n3);
            int n6 = (this.data[n4 + 3] & 0xFF) + (n2 - n3 >> 2);
            if (n6 >= 256) {
                int n7 = n4 + 2;
                this.data[n7] = (byte)(this.data[n7] + (n2 - n3 >> 10));
            }
            this.data[n4 + 3] = (byte)n6;
        }
    }

    void assemble(DataOutputStream dataOutputStream) throws IOException {
        throw new IllegalArgumentException("Recursive Compound Packet");
    }

    public int calcLength() {
        int n2 = 0;
        if (this.packets == null || this.packets.length < 1) {
            throw new IllegalArgumentException("Bad RTCP Compound Packet");
        }
        int n3 = 0;
        while (n3 < this.packets.length) {
            n2 += this.packets[n3].calcLength();
            ++n3;
        }
        return n2;
    }

    public String toString() {
        return "RTCP Packet with the following subpackets:\n" + this.toString(this.packets);
    }

    public String toString(RTCPPacket[] rTCPPacketArray) {
        String string = "";
        int n2 = 0;
        while (n2 < rTCPPacketArray.length) {
            string = String.valueOf(string) + rTCPPacketArray[n2];
            ++n2;
        }
        return string;
    }
}

