/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio;

import com.sun.media.BasicClock;
import com.sun.media.Log;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.renderer.audio.AudioRenderer;
import com.sun.media.renderer.audio.device.AudioOutput;
import com.sun.media.renderer.audio.device.SunAudioOutput;
import javax.media.ClockStoppedException;
import javax.media.Format;
import javax.media.IncompatibleTimeBaseException;
import javax.media.ResourceUnavailableException;
import javax.media.SystemTimeBase;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.format.AudioFormat;
import sun.audio.AudioPlayer;

public class SunAudioRenderer
extends AudioRenderer {
    static final String NAME = "SunAudio Renderer";
    private static String vendor = null;
    private static String version = null;
    private static boolean runningOnMacLocal = false;
    private static boolean useSystemTimeLocal = false;
    private BasicClock clock = null;
    private long startMediaTime = 0L;
    public static final boolean runningOnMac;
    public static final boolean useSystemTime;
    public static final long DEVICE_LATENCY;

    static {
        try {
            vendor = System.getProperty("java.vendor");
            version = System.getProperty("java.version");
            if (vendor != null && (vendor = vendor.toUpperCase()).startsWith("APPLE") && version.startsWith("1.1")) {
                runningOnMacLocal = true;
                useSystemTimeLocal = true;
            }
        }
        catch (Throwable throwable) {}
        runningOnMac = runningOnMacLocal;
        useSystemTime = useSystemTimeLocal;
        DEVICE_LATENCY = runningOnMac ? 7000000000L : 0L;
    }

    public SunAudioRenderer() {
        if (useSystemTime) {
            this.timeBase = new SystemTimeBase();
            this.clock = new BasicClock();
        }
        this.supportedFormats = new Format[1];
        this.supportedFormats[0] = new AudioFormat("ULAW", 8000.0, 8, 1, -1, -1);
        this.gainControl = new MCA(this);
    }

    public void close() {
        super.close();
    }

    protected AudioOutput createDevice(AudioFormat audioFormat) {
        return new SunAudioOutput();
    }

    public long getMediaNanoseconds() {
        if (useSystemTime) {
            long l2 = this.clock.getMediaNanoseconds();
            if (l2 - this.startMediaTime < DEVICE_LATENCY) {
                return this.startMediaTime;
            }
            return l2 - DEVICE_LATENCY;
        }
        return super.getMediaNanoseconds();
    }

    public Time getMediaTime() {
        return useSystemTime ? this.clock.getMediaTime() : super.getMediaTime();
    }

    public String getName() {
        return NAME;
    }

    public float getRate() {
        return useSystemTime ? this.clock.getRate() : super.getRate();
    }

    public Time getStopTime() {
        if (useSystemTime) {
            return this.clock.getStopTime();
        }
        return super.getStopTime();
    }

    public Time getSyncTime() {
        return useSystemTime ? this.clock.getSyncTime() : super.getSyncTime();
    }

    public TimeBase getTimeBase() {
        return useSystemTime ? this.clock.getTimeBase() : super.getTimeBase();
    }

    private static synchronized boolean grabDevice() {
        if (runningOnMac && !AudioPlayer.player.isAlive()) {
            System.out.println("Audio device is busy");
            return false;
        }
        return true;
    }

    public Time mapToTimeBase(Time time) throws ClockStoppedException {
        return useSystemTime ? this.clock.mapToTimeBase(time) : super.mapToTimeBase(time);
    }

    public void open() throws ResourceUnavailableException {
        if (!SunAudioRenderer.grabDevice()) {
            throw new ResourceUnavailableException("AudioRenderer: Failed to initialize audio device.");
        }
    }

    public void setMediaTime(Time time) {
        if (useSystemTime) {
            this.clock.setMediaTime(time);
            this.startMediaTime = time.getNanoseconds();
        } else {
            super.setMediaTime(time);
        }
    }

    public float setRate(float f2) {
        return super.setRate(1.0f);
    }

    public void setStopTime(Time time) {
        if (useSystemTime) {
            this.clock.setStopTime(time);
        } else {
            super.setStopTime(time);
        }
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        if (useSystemTime) {
            if (!(timeBase instanceof SystemTimeBase)) {
                Log.warning("AudioRenderer cannot be controlled by time bases other than its own: " + timeBase);
            }
            this.clock.setTimeBase(timeBase);
        } else {
            super.setTimeBase(timeBase);
        }
    }

    public void stop() {
        super.stop();
        if (useSystemTime) {
            this.clock.stop();
        }
    }

    public void syncStart(Time time) {
        super.syncStart(time);
        if (useSystemTime) {
            this.clock.syncStart(time);
        }
    }

    class MCA
    extends GainControlAdapter {
        AudioRenderer renderer;

        protected MCA(AudioRenderer audioRenderer) {
            super(false);
            this.renderer = audioRenderer;
        }

        public float getLevel() {
            return -1.0f;
        }

        public void setMute(boolean bl) {
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setMute(bl);
            }
            super.setMute(bl);
        }
    }
}

