/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.javasound;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.CircularBuffer;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.protocol.BasicSourceStream;
import com.sun.media.protocol.javasound.DataSource;
import com.sun.media.protocol.javasound.PushThread;
import com.sun.media.protocol.javasound.jdk12CreateThreadAction;
import com.sun.media.renderer.audio.device.JavaSoundOutput;
import com.sun.media.ui.AudioFormatChooser;
import com.sun.media.util.Arch;
import com.sun.media.util.jdk12;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.Control;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.Owned;
import javax.media.control.BufferControl;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;

public class JavaSoundSourceStream
extends BasicSourceStream
implements PushBufferStream {
    DataSource dsource;
    TargetDataLine dataLine = null;
    AudioFormat format;
    AudioFormat devFormat;
    boolean reconnect = false;
    int bufSize;
    BufferTransferHandler transferHandler;
    boolean started = false;
    AudioFormatChooser afc;
    BufferControl bc;
    CircularBuffer cb = new CircularBuffer(1);
    PushThread pushThread = null;
    static int DefRate = 44100;
    static int DefBits = 16;
    static int DefChannels = 2;
    static int DefSigned = 1;
    static int DefEndian = Arch.isBigEndian() ? 1 : 0;
    static int OtherEndian = Arch.isBigEndian() ? 1 : 0;
    static Format[] supported;
    protected static CaptureDeviceInfo[] deviceList;
    private static JMFSecurity jmfSecurity;
    private static boolean securityPrivelege;
    private Method[] mSecurity = new Method[1];
    private Class[] clSecurity = new Class[1];
    private Object[][] argsSecurity = new Object[1][0];
    static int DefaultMinBufferSize;
    static int DefaultMaxBufferSize;
    long bufLenReq = 125L;
    static /* synthetic */ Class class$com$sun$media$protocol$javasound$PushThread;
    static /* synthetic */ Class class$javax$sound$sampled$TargetDataLine;

    static {
        jmfSecurity = null;
        securityPrivelege = false;
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
        supported = new Format[]{new AudioFormat("LINEAR", 44100.0, 16, 2, DefEndian, DefSigned), new AudioFormat("LINEAR", 44100.0, 16, 1, DefEndian, DefSigned), new AudioFormat("LINEAR", 22050.0, 16, 2, DefEndian, DefSigned), new AudioFormat("LINEAR", 22050.0, 16, 1, DefEndian, DefSigned), new AudioFormat("LINEAR", 11025.0, 16, 2, DefEndian, DefSigned), new AudioFormat("LINEAR", 11025.0, 16, 1, DefEndian, DefSigned), new AudioFormat("LINEAR", 8000.0, 16, 2, DefEndian, DefSigned), new AudioFormat("LINEAR", 8000.0, 16, 1, DefEndian, DefSigned)};
        deviceList = new CaptureDeviceInfo[]{new CaptureDeviceInfo("JavaSound audio capture", new MediaLocator("javasound://44100"), supported)};
        DefaultMinBufferSize = 16;
        DefaultMaxBufferSize = 4000;
    }

    public JavaSoundSourceStream(DataSource dataSource) {
        super(new ContentDescriptor("raw"), -1L);
        this.dsource = dataSource;
        this.bc = new BC(this);
        this.controls = new Control[2];
        this.controls[0] = new FC(this);
        this.controls[1] = this.bc;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        if (JavaSoundOutput.isOpen()) {
            Log.warning("JavaSound is already opened for rendering.  Will capture at the default format.");
            this.format = null;
        }
        this.openDev();
        if (this.pushThread == null) {
            Object object;
            if (jmfSecurity != null) {
                object = null;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        object = "thread";
                        jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 16);
                        this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                        object = "thread group";
                        jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 32);
                        this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                    }
                }
                catch (Throwable throwable) {
                    securityPrivelege = false;
                }
            }
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                try {
                    object = jdk12CreateThreadAction.cons;
                    this.pushThread = (PushThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$protocol$javasound$PushThread != null ? class$com$sun$media$protocol$javasound$PushThread : (class$com$sun$media$protocol$javasound$PushThread = JavaSoundSourceStream.class$("com.sun.media.protocol.javasound.PushThread"))));
                }
                catch (Exception exception) {}
            } else {
                this.pushThread = new PushThread();
            }
            this.pushThread.setSourceStream(this);
        }
        if (this.reconnect) {
            Log.comment("Capture buffer size: " + this.bufSize);
        }
        this.devFormat = this.format;
        this.reconnect = false;
    }

    public void disconnect() {
        if (this.dataLine == null) {
            return;
        }
        this.dataLine.stop();
        this.dataLine.close();
        this.dataLine = null;
        this.devFormat = null;
        if (this.pushThread != null) {
            this.pushThread.kill();
            this.pushThread = null;
        }
    }

    public Object[] getControls() {
        return this.controls;
    }

    public Format getFormat() {
        return this.format;
    }

    public static Format[] getSupportedFormats() {
        return supported;
    }

    public boolean isConnected() {
        return this.devFormat != null;
    }

    public static CaptureDeviceInfo[] listCaptureDeviceInfo() {
        return deviceList;
    }

    void openDev() throws IOException {
        DataLine.Info info;
        javax.sound.sampled.AudioFormat audioFormat = null;
        if (this.format != null) {
            audioFormat = JavaSoundOutput.convertFormat(this.format);
            int n2 = this.format.getChannels() == -1 ? 1 : this.format.getChannels();
            int n3 = this.format.getSampleSizeInBits() == -1 ? 16 : this.format.getSampleSizeInBits();
            int n4 = n3 * n2 / 8;
            if (n4 == 0) {
                n4 = 1;
            }
            this.bufSize = (int)(this.format.getSampleRate() * (double)n4 * (double)this.bc.getBufferLength() / 1000.0);
            info = new DataLine.Info(class$javax$sound$sampled$TargetDataLine != null ? class$javax$sound$sampled$TargetDataLine : (class$javax$sound$sampled$TargetDataLine = JavaSoundSourceStream.class$("javax.sound.sampled.TargetDataLine")), audioFormat, this.bufSize);
        } else {
            info = new DataLine.Info(class$javax$sound$sampled$TargetDataLine != null ? class$javax$sound$sampled$TargetDataLine : (class$javax$sound$sampled$TargetDataLine = JavaSoundSourceStream.class$("javax.sound.sampled.TargetDataLine")), null, -1);
        }
        if (!AudioSystem.isLineSupported(info)) {
            Log.error("Audio not supported: " + info + "\n");
            throw new IOException("Cannot open audio device for input.");
        }
        try {
            this.dataLine = (TargetDataLine)AudioSystem.getLine(info);
            if (this.format != null) {
                this.dataLine.open(audioFormat, this.bufSize);
            } else {
                this.dataLine.open();
                this.format = JavaSoundOutput.convertFormat(this.dataLine.getFormat());
            }
            this.bufSize = this.dataLine.getBufferSize();
        }
        catch (Exception exception) {
            Log.error("Cannot open audio device for input: " + exception);
            throw new IOException(exception.getMessage());
        }
    }

    public static Format parseLocator(MediaLocator mediaLocator) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = mediaLocator.getRemainder();
        if (string6 != null && string6.length() > 0) {
            while (string6.length() > 1 && string6.charAt(0) == '/') {
                string6 = string6.substring(1);
            }
            int n2 = string6.indexOf(47);
            if (n2 == -1) {
                if (!string6.equals("")) {
                    string = string6;
                }
            } else {
                string = string6.substring(0, n2);
                if ((n2 = (string6 = string6.substring(n2 + 1)).indexOf(47)) == -1) {
                    if (!string6.equals("")) {
                        string2 = string6;
                    }
                } else {
                    string2 = string6.substring(0, n2);
                    if ((n2 = (string6 = string6.substring(n2 + 1)).indexOf(47)) == -1) {
                        if (!string6.equals("")) {
                            string3 = string6;
                        }
                    } else {
                        string3 = string6.substring(0, n2);
                        if ((n2 = (string6 = string6.substring(n2 + 1)).indexOf(47)) == -1) {
                            if (!string6.equals("")) {
                                string4 = string6;
                            }
                        } else {
                            string4 = string6.substring(0, n2);
                            if (!string6.equals("")) {
                                string5 = string6.substring(n2 + 1);
                            }
                        }
                    }
                }
            }
        }
        int n3 = DefRate;
        if (string != null) {
            try {
                Integer n4 = Integer.valueOf(string);
                if (n4 != null) {
                    n3 = n4;
                }
            }
            catch (Throwable throwable) {}
            if (n3 <= 0 || n3 > 96000) {
                Log.warning("JavaSound capture: unsupported sample rate: " + n3);
                n3 = DefRate;
                Log.warning("        defaults to: " + n3);
            }
        }
        int n5 = DefBits;
        if (string2 != null) {
            try {
                Integer n6 = Integer.valueOf(string2);
                if (n6 != null) {
                    n5 = n6;
                }
            }
            catch (Throwable throwable) {}
            if (n5 != 8 && n5 != 16) {
                Log.warning("JavaSound capture: unsupported sample size: " + n5);
                n5 = DefBits;
                Log.warning("        defaults to: " + n5);
            }
        }
        int n7 = DefChannels;
        if (string3 != null) {
            try {
                Integer n8 = Integer.valueOf(string3);
                if (n8 != null) {
                    n7 = n8;
                }
            }
            catch (Throwable throwable) {}
            if (n7 != 1 && n7 != 2) {
                Log.warning("JavaSound capture: unsupported # of channels: " + n7);
                n7 = DefChannels;
                Log.warning("        defaults to: " + n7);
            }
        }
        int n9 = DefEndian;
        if (string4 != null) {
            if (string4.equalsIgnoreCase("big")) {
                n9 = 1;
            } else if (string4.equalsIgnoreCase("little")) {
                n9 = 0;
            } else {
                Log.warning("JavaSound capture: unsupported endianess: " + string4);
                Log.warning("        defaults to: big endian");
            }
        }
        int n10 = DefSigned;
        if (string5 != null) {
            if (string5.equalsIgnoreCase("signed")) {
                n10 = 1;
            } else if (string5.equalsIgnoreCase("unsigned")) {
                n10 = 0;
            } else {
                Log.warning("JavaSound capture: unsupported signedness: " + string5);
                Log.warning("        defaults to: signed");
            }
        }
        AudioFormat audioFormat = new AudioFormat("LINEAR", n3, n5, n7, n9, n10);
        return audioFormat;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(Buffer buffer) {
        Buffer buffer2;
        CircularBuffer circularBuffer = this.cb;
        synchronized (circularBuffer) {
            while (true) {
                if (this.cb.canRead()) {
                    buffer2 = this.cb.read();
                    break;
                }
                try {
                    this.cb.wait();
                }
                catch (Exception exception) {}
            }
        }
        Object object = buffer.getData();
        buffer.copy(buffer2);
        buffer2.setData(object);
        circularBuffer = this.cb;
        synchronized (circularBuffer) {
            this.cb.readReport();
            this.cb.notify();
            return;
        }
    }

    public Format setFormat(Format format) {
        if (this.started) {
            Log.warning("Cannot change audio capture format after started.");
            return this.format;
        }
        if (format == null) {
            return this.format;
        }
        Format format2 = null;
        int n2 = 0;
        while (n2 < supported.length) {
            if (format.matches(supported[n2]) && (format2 = format.intersects(supported[n2])) != null) break;
            ++n2;
        }
        if (format2 == null) {
            return this.format;
        }
        try {
            if (this.devFormat != null) {
                if (!this.devFormat.matches(format2) && !JavaSoundOutput.isOpen()) {
                    this.format = (AudioFormat)format2;
                    this.disconnect();
                    this.connect();
                }
            } else {
                this.format = (AudioFormat)format2;
                this.connect();
            }
        }
        catch (IOException iOException) {
            return null;
        }
        if (this.afc != null) {
            this.afc.setCurrentFormat(this.format);
        }
        return this.format;
    }

    public void setTransferHandler(BufferTransferHandler bufferTransferHandler) {
        this.transferHandler = bufferTransferHandler;
    }

    public void start() throws IOException {
        Object object;
        if (this.dataLine == null) {
            throw new IOException("A JavaSound input channel cannot be opened.");
        }
        if (this.started) {
            return;
        }
        if (this.afc != null) {
            object = this.afc.getFormat();
            if (object != null && !((Format)object).matches(this.format)) {
                this.setFormat((Format)object);
            }
            this.afc.setEnabled(false);
        }
        if (this.reconnect) {
            this.disconnect();
        }
        if (!this.isConnected()) {
            this.connect();
        }
        object = this.cb;
        synchronized (object) {
            while (this.cb.canRead()) {
                this.cb.read();
                this.cb.readReport();
            }
            this.cb.notifyAll();
        }
        this.pushThread.start();
        this.dataLine.flush();
        this.dataLine.start();
        this.started = true;
    }

    public void stop() throws IOException {
        if (!this.started) {
            return;
        }
        this.pushThread.pause();
        if (this.dataLine != null) {
            this.dataLine.stop();
        }
        this.started = false;
        if (this.afc != null && !JavaSoundOutput.isOpen()) {
            this.afc.setEnabled(true);
        }
    }

    public boolean willReadBlock() {
        return this.started ^ true;
    }

    class FC
    implements FormatControl,
    Owned {
        JavaSoundSourceStream jsss;

        public FC(JavaSoundSourceStream javaSoundSourceStream2) {
            this.jsss = javaSoundSourceStream2;
        }

        public Component getControlComponent() {
            if (JavaSoundSourceStream.this.afc == null) {
                JavaSoundSourceStream.this.afc = new AudioFormatChooser(supported, JavaSoundSourceStream.this.format);
                JavaSoundSourceStream.this.afc.setName("JavaSound");
                if (JavaSoundSourceStream.this.started || JavaSoundSourceStream.this.dataLine == null || JavaSoundOutput.isOpen()) {
                    JavaSoundSourceStream.this.afc.setEnabled(false);
                }
            }
            return JavaSoundSourceStream.this.afc;
        }

        public Format getFormat() {
            return JavaSoundSourceStream.this.format;
        }

        public Object getOwner() {
            return JavaSoundSourceStream.this.dsource;
        }

        public Format[] getSupportedFormats() {
            return supported;
        }

        public boolean isEnabled() {
            return true;
        }

        public void setEnabled(boolean bl) {
        }

        public Format setFormat(Format format) {
            return this.jsss.setFormat(format);
        }
    }

    class BC
    implements BufferControl,
    Owned {
        JavaSoundSourceStream jsss;

        BC(JavaSoundSourceStream javaSoundSourceStream2) {
            this.jsss = javaSoundSourceStream2;
        }

        public long getBufferLength() {
            return JavaSoundSourceStream.this.bufLenReq;
        }

        public Component getControlComponent() {
            return null;
        }

        public boolean getEnabledThreshold() {
            return false;
        }

        public long getMinimumThreshold() {
            return 0L;
        }

        public Object getOwner() {
            return JavaSoundSourceStream.this.dsource;
        }

        public long setBufferLength(long l2) {
            JavaSoundSourceStream.this.bufLenReq = l2 < (long)DefaultMinBufferSize ? (long)DefaultMinBufferSize : (l2 > (long)DefaultMaxBufferSize ? (long)DefaultMaxBufferSize : l2);
            Log.comment("Capture buffer length set: " + JavaSoundSourceStream.this.bufLenReq);
            JavaSoundSourceStream.this.reconnect = true;
            return JavaSoundSourceStream.this.bufLenReq;
        }

        public void setEnabledThreshold(boolean bl) {
        }

        public long setMinimumThreshold(long l2) {
            return 0L;
        }
    }
}

