/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.datasink;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.DataSink;
import javax.media.IncompatibleSourceException;
import javax.media.MediaLocator;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.protocol.DataSource;

public abstract class BasicDataSink
implements DataSink {
    protected Vector listeners = new Vector(1);

    public void addDataSinkListener(DataSinkListener dataSinkListener) {
        if (dataSinkListener != null && !this.listeners.contains(dataSinkListener)) {
            this.listeners.addElement(dataSinkListener);
        }
    }

    public abstract void close();

    public abstract String getContentType();

    public abstract Object getControl(String var1);

    public abstract Object[] getControls();

    public abstract MediaLocator getOutputLocator();

    public abstract void open() throws IOException, SecurityException;

    protected void removeAllListeners() {
        this.listeners.removeAllElements();
    }

    public void removeDataSinkListener(DataSinkListener dataSinkListener) {
        if (dataSinkListener != null) {
            this.listeners.removeElement(dataSinkListener);
        }
    }

    protected final void sendDataSinkErrorEvent(String string) {
        this.sendEvent(new DataSinkErrorEvent(this, string));
    }

    protected final void sendEndofStreamEvent() {
        this.sendEvent(new EndOfStreamEvent(this));
    }

    protected void sendEvent(DataSinkEvent dataSinkEvent) {
        if (!this.listeners.isEmpty()) {
            Vector vector = this.listeners;
            synchronized (vector) {
                Enumeration enumeration = this.listeners.elements();
                while (enumeration.hasMoreElements()) {
                    DataSinkListener dataSinkListener = (DataSinkListener)enumeration.nextElement();
                    dataSinkListener.dataSinkUpdate(dataSinkEvent);
                }
            }
        }
    }

    public abstract void setOutputLocator(MediaLocator var1);

    public abstract void setSource(DataSource var1) throws IOException, IncompatibleSourceException;

    public abstract void start() throws IOException;

    public abstract void stop() throws IOException;
}

