/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import java.awt.Point;

final class Rect {
    public int xmin;
    public int ymin;
    public int xmax;
    public int ymax;
    static final int rectEmptyFlag = Integer.MIN_VALUE;

    Rect() {
        this.ymax = Integer.MIN_VALUE;
        this.xmax = Integer.MIN_VALUE;
        this.ymin = Integer.MIN_VALUE;
        this.xmin = Integer.MIN_VALUE;
    }

    Rect(int n2, int n3, int n4, int n5) {
        if (n2 < n4) {
            this.xmin = n2;
            this.xmax = n4;
        } else {
            this.xmin = n4;
            this.xmax = n2;
        }
        if (n3 < n5) {
            this.ymin = n3;
            this.ymax = n5;
        } else {
            this.ymin = n5;
            this.ymax = n3;
        }
    }

    Rect(Rect rect) {
        this.xmin = rect.xmin;
        this.ymin = rect.ymin;
        this.xmax = rect.xmax;
        this.ymax = rect.ymax;
    }

    final boolean isEmpty() {
        return this.xmin == Integer.MIN_VALUE;
    }

    final void offset(int n2, int n3) {
        if (!this.isEmpty()) {
            this.xmin += n2;
            this.xmax += n2;
            this.ymin += n3;
            this.ymax += n3;
        }
    }

    final boolean pointIn(Point point) {
        return this.xmin <= point.x && point.x <= this.xmax && this.ymin <= point.y && point.y <= this.ymax;
    }

    final void setEmpty() {
        this.ymax = Integer.MIN_VALUE;
        this.ymin = Integer.MIN_VALUE;
        this.xmax = Integer.MIN_VALUE;
        this.xmin = Integer.MIN_VALUE;
    }

    final boolean testIntersect(Rect rect) {
        return this.xmin <= rect.xmax && rect.xmin <= this.xmax && this.ymin <= rect.ymax && rect.ymin <= this.ymax;
    }

    final void union(Rect rect) {
        if (!rect.isEmpty()) {
            if (this.isEmpty()) {
                this.xmin = rect.xmin;
                this.xmax = rect.xmax;
                this.ymin = rect.ymin;
                this.ymax = rect.ymax;
            } else {
                this.xmin = Math.min(this.xmin, rect.xmin);
                this.xmax = Math.max(this.xmax, rect.xmax);
                this.ymin = Math.min(this.ymin, rect.ymin);
                this.ymax = Math.max(this.ymax, rect.ymax);
            }
        }
    }

    final void union(Point point) {
        if (this.isEmpty()) {
            this.xmin = this.xmax = point.x;
            this.ymin = this.ymax = point.y;
        } else {
            if (point.x < this.xmin) {
                this.xmin = point.x;
            } else if (point.x > this.xmax) {
                this.xmax = point.x;
            }
            if (point.y < this.ymin) {
                this.ymin = point.y;
            } else if (point.y > this.ymax) {
                this.ymax = point.y;
            }
        }
    }
}

