/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.BasicController;
import com.sun.media.BasicPlayer;
import com.sun.media.content.application.x_shockwave_flash.Flash;
import com.sun.media.content.application.x_shockwave_flash.FlashAudioPlayer;
import com.sun.media.content.application.x_shockwave_flash.FlashDefaultControlPanel;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import javax.media.IncompatibleSourceException;
import javax.media.NotRealizedError;
import javax.media.StopByRequestEvent;
import javax.media.SystemTimeBase;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;

public class Handler
extends BasicPlayer {
    private static int instanceCount = 0;
    private Flash flash = null;
    private Component visualComponent = null;
    private DataSource dsource;
    private Component controlComp;
    private Thread flashThread = null;
    private FlashController flashController = new FlashController();

    public Handler() {
        this.manageController(this.flashController);
        this.flash = new Flash();
        this.visualComponent = new VideoComponent();
        if (this.visualComponent == null || this.flash == null) {
            return;
        }
        this.flash.setComponent(this.visualComponent);
        AWTEventToEvent aWTEventToEvent = new AWTEventToEvent();
        this.visualComponent.addMouseListener(aWTEventToEvent);
        this.visualComponent.addMouseMotionListener(aWTEventToEvent);
        ++instanceCount;
    }

    protected boolean audioEnabled() {
        return true;
    }

    public Component getControlPanelComponent() {
        int n2 = this.getState();
        if (n2 < 300) {
            this.throwError(new NotRealizedError("Cannot get control panel component on an unrealized player"));
        }
        if (this.controlComp == null) {
            this.controlComp = new FlashDefaultControlPanel(this);
        }
        return this.controlComp;
    }

    protected TimeBase getMasterTimeBase() {
        return this.flashController.getMasterTimeBase();
    }

    public Component getVisualComponent() {
        super.getVisualComponent();
        return this.visualComponent;
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        super.setSource(dataSource);
        if (!(dataSource instanceof PullDataSource)) {
            throw new IncompatibleSourceException("Only PullDataSources are supported");
        }
        PullDataSource pullDataSource = (PullDataSource)dataSource;
        this.dsource = dataSource;
    }

    public void updateStats() {
    }

    protected boolean videoEnabled() {
        return true;
    }

    class FlashController
    extends BasicController {
        FlashController() {
        }

        protected void abortPrefetch() {
        }

        protected void abortRealize() {
        }

        protected void doClose() {
            if (Handler.this.flash != null) {
                Handler.this.flash.stop();
            }
            Handler.this.flashThread = null;
            instanceCount = instanceCount - 1;
            if (instanceCount == 0) {
                FlashAudioPlayer.player.closeMixedRenderer();
            }
        }

        protected boolean doPrefetch() {
            if (Handler.this.flashThread == null) {
                Handler.this.flashThread = Handler.this.flash.startNonApplet();
            }
            return true;
        }

        protected boolean doRealize() {
            PullDataSource pullDataSource = (PullDataSource)Handler.this.dsource;
            PullSourceStream[] pullSourceStreamArray = pullDataSource.getStreams();
            if (Handler.this.flash == null || pullSourceStreamArray == null) {
                return false;
            }
            return Handler.this.flash.loadScript(pullSourceStreamArray[0]);
        }

        protected float doSetRate(float f2) {
            return 1.0f;
        }

        protected void doStart() {
            if (Handler.this.flash != null) {
                Handler.this.flash.startPlay();
            }
        }

        public void doStop() {
            if (Handler.this.flash != null) {
                Handler.this.flash.stopPlay();
            }
            this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
        }

        protected TimeBase getMasterTimeBase() {
            return new SystemTimeBase();
        }

        protected boolean isConfigurable() {
            return false;
        }
    }

    class VideoComponent
    extends Canvas {
        VideoComponent() {
        }

        public synchronized Dimension getPreferredSize() {
            return new Dimension(600, 400);
        }

        public void paint(Graphics graphics) {
            Handler.this.flash.paint(graphics);
        }

        public void update(Graphics graphics) {
            Handler.this.flash.update(graphics);
        }
    }

    class AWTEventToEvent
    implements MouseListener,
    MouseMotionListener {
        AWTEventToEvent() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.sendEvent(501, mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.sendEvent(506, mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.sendEvent(504, mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.sendEvent(505, mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.sendEvent(503, mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.sendEvent(501, mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.sendEvent(502, mouseEvent);
        }

        private void sendEvent(int n2, MouseEvent mouseEvent) {
            Event event = new Event(null, n2, null);
            event.id = n2;
            event.x = mouseEvent.getX();
            event.y = mouseEvent.getY();
            event.clickCount = mouseEvent.getClickCount();
            if (Handler.this.flash != null) {
                Handler.this.flash.handleEvent(event);
            }
        }
    }
}

