/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.colorspace;

import com.sun.media.BasicCodec;
import com.sun.media.codec.video.colorspace.RGBConverter;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public abstract class RGBConverter
extends BasicCodec {
    private static final String PLUGIN_NAME = "RGB To RGB Converter";
    private FrameProcessingControl frameControl = null;
    private boolean dropFrame;

    public RGBConverter() {
        this.inputFormats = new Format[]{new RGBFormat()};
        this.outputFormats = new Format[]{new RGBFormat()};
        if (this.frameControl == null) {
            class FPC
            implements FrameProcessingControl {
                private final /* synthetic */ RGBConverter this$0;

                FPC(RGBConverter rGBConverter) {
                    this.this$0 = rGBConverter;
                }

                public Component getControlComponent() {
                    return null;
                }

                public int getFramesDropped() {
                    return 0;
                }

                public void setFramesBehind(float f2) {
                    if (f2 > 0.0f) {
                        RGBConverter.access$1(this.this$0, true);
                    } else {
                        RGBConverter.access$1(this.this$0, false);
                    }
                }

                public boolean setMinimalProcessing(boolean bl) {
                    RGBConverter.access$1(this.this$0, bl);
                    return RGBConverter.access$0(this.this$0);
                }
            }
            this.frameControl = new FPC(this);
            this.controls = new Control[1];
            this.controls[0] = this.frameControl;
        }
    }

    static /* synthetic */ boolean access$0(RGBConverter rGBConverter) {
        return rGBConverter.dropFrame;
    }

    static /* synthetic */ void access$1(RGBConverter rGBConverter, boolean bl) {
        rGBConverter.dropFrame = bl;
    }

    public void close() {
        super.close();
    }

    protected abstract void componentToComponent(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, int var9, Object var10, int var11, int var12, int var13, int var14, int var15, int var16, boolean var17, int var18, int var19, int var20, boolean var21);

    protected abstract void componentToSixteen(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, int var9, Object var10, int var11, int var12, int var13, int var14, int var15, int var16, boolean var17, int var18, int var19, int var20, boolean var21);

    public String getName() {
        return PLUGIN_NAME;
    }

    protected int getShift(int n2) {
        int n3 = 0;
        while ((n2 & 1) == 0) {
            n2 >>= 1;
            ++n3;
        }
        return n3;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (format instanceof RGBFormat) {
            RGBFormat rGBFormat = (RGBFormat)format;
            Dimension dimension = rGBFormat.getSize();
            float f2 = rGBFormat.getFrameRate();
            int n2 = rGBFormat.getBitsPerPixel();
            RGBFormat rGBFormat2 = new RGBFormat(dimension, dimension.width * dimension.height, Format.shortArray, f2, 16, -1, -1, -1, 1, dimension.width, -1, -1);
            RGBFormat rGBFormat3 = new RGBFormat(dimension, dimension.width * dimension.height * 2, Format.byteArray, f2, 16, -1, -1, -1, 2, dimension.width * 2, -1, -1);
            RGBFormat rGBFormat4 = new RGBFormat(null, -1, null, -1.0f, -1, 63488, 2016, 31, -1, -1, -1, -1);
            RGBFormat rGBFormat5 = new RGBFormat(null, -1, null, -1.0f, -1, 31744, 992, 31, -1, -1, -1, -1);
            RGBFormat rGBFormat6 = new RGBFormat(dimension, dimension.width * dimension.height * 3, Format.byteArray, f2, 24, -1, -1, -1, 3, dimension.width * 3, -1, -1);
            RGBFormat rGBFormat7 = new RGBFormat(null, -1, null, -1.0f, -1, 1, 2, 3, -1, -1, -1, -1);
            RGBFormat rGBFormat8 = new RGBFormat(null, -1, null, -1.0f, -1, 3, 2, 1, -1, -1, -1, -1);
            RGBFormat rGBFormat9 = new RGBFormat(dimension, dimension.width * dimension.height, Format.intArray, f2, 32, -1, -1, -1, 1, dimension.width, -1, -1);
            RGBFormat rGBFormat10 = new RGBFormat(dimension, dimension.width * dimension.height * 4, Format.byteArray, f2, 32, -1, -1, -1, 4, dimension.width * 4, -1, -1);
            RGBFormat rGBFormat11 = new RGBFormat(null, -1, null, -1.0f, -1, 2, 3, 4, -1, -1, -1, -1);
            RGBFormat rGBFormat12 = new RGBFormat(null, -1, null, -1.0f, -1, 4, 3, 2, -1, -1, -1, -1);
            RGBFormat rGBFormat13 = new RGBFormat(null, -1, null, -1.0f, -1, 1, 2, 3, -1, -1, -1, -1);
            RGBFormat rGBFormat14 = new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, 1, -1);
            RGBFormat rGBFormat15 = new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, 0, -1);
            RGBFormat rGBFormat16 = new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, -1, 0);
            RGBFormat rGBFormat17 = new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, -1, 1);
            RGBFormat rGBFormat18 = new RGBFormat(null, -1, null, -1.0f, -1, 3, 2, 1, -1, -1, -1, -1);
            RGBFormat rGBFormat19 = new RGBFormat(null, -1, null, -1.0f, -1, 0xFF0000, 65280, 255, -1, -1, -1, -1);
            RGBFormat rGBFormat20 = new RGBFormat(null, -1, null, -1.0f, -1, 255, 65280, 0xFF0000, -1, -1, -1, -1);
            Format[] formatArray = new Format[]{rGBFormat2.intersects(rGBFormat4).intersects(rGBFormat14), rGBFormat2.intersects(rGBFormat4).intersects(rGBFormat15), rGBFormat3.intersects(rGBFormat4).intersects(rGBFormat14).intersects(rGBFormat17), rGBFormat3.intersects(rGBFormat4).intersects(rGBFormat14).intersects(rGBFormat16), rGBFormat3.intersects(rGBFormat4).intersects(rGBFormat15).intersects(rGBFormat17), rGBFormat3.intersects(rGBFormat4).intersects(rGBFormat15).intersects(rGBFormat16), rGBFormat2.intersects(rGBFormat5).intersects(rGBFormat14), rGBFormat2.intersects(rGBFormat5).intersects(rGBFormat15), rGBFormat3.intersects(rGBFormat5).intersects(rGBFormat14).intersects(rGBFormat17), rGBFormat3.intersects(rGBFormat5).intersects(rGBFormat14).intersects(rGBFormat16), rGBFormat3.intersects(rGBFormat5).intersects(rGBFormat15).intersects(rGBFormat17), rGBFormat3.intersects(rGBFormat5).intersects(rGBFormat15).intersects(rGBFormat16), rGBFormat6.intersects(rGBFormat7).intersects(rGBFormat14), rGBFormat6.intersects(rGBFormat7).intersects(rGBFormat15), rGBFormat6.intersects(rGBFormat8).intersects(rGBFormat14), rGBFormat6.intersects(rGBFormat8).intersects(rGBFormat15), rGBFormat9.intersects(rGBFormat19).intersects(rGBFormat14), rGBFormat9.intersects(rGBFormat19).intersects(rGBFormat15), rGBFormat9.intersects(rGBFormat20).intersects(rGBFormat14), rGBFormat9.intersects(rGBFormat20).intersects(rGBFormat15), rGBFormat10.intersects(rGBFormat13).intersects(rGBFormat14), rGBFormat10.intersects(rGBFormat13).intersects(rGBFormat15), rGBFormat10.intersects(rGBFormat18).intersects(rGBFormat14), rGBFormat10.intersects(rGBFormat18).intersects(rGBFormat15), rGBFormat10.intersects(rGBFormat11).intersects(rGBFormat14), rGBFormat10.intersects(rGBFormat11).intersects(rGBFormat15), rGBFormat10.intersects(rGBFormat12).intersects(rGBFormat14), rGBFormat10.intersects(rGBFormat12).intersects(rGBFormat15)};
            return formatArray;
        }
        return null;
    }

    public void open() throws ResourceUnavailableException {
        super.open();
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        if (this.dropFrame) {
            buffer2.setFlags(buffer2.getFlags() | 2);
            return 0;
        }
        RGBFormat rGBFormat = (RGBFormat)this.inputFormat;
        RGBFormat rGBFormat2 = (RGBFormat)this.outputFormat;
        Object object = buffer.getData();
        Object object2 = buffer2.getData();
        if (object.getClass() != this.inputFormat.getDataType()) {
            return 1;
        }
        int n2 = rGBFormat2.getMaxDataLength();
        int n3 = 0;
        if (object2 != null) {
            if (object2.getClass() == Format.byteArray) {
                n3 = ((byte[])object2).length;
            } else if (object2.getClass() == Format.shortArray) {
                n3 = ((short[])object2).length;
            } else if (object2.getClass() == Format.intArray) {
                n3 = ((int[])object2).length;
            }
        }
        if (object2 == null || n3 < n2 || this.outputFormat != buffer2.getFormat() || !this.outputFormat.equals(buffer2.getFormat())) {
            Class clazz = this.outputFormat.getDataType();
            if (clazz == Format.byteArray) {
                object2 = new byte[rGBFormat2.getMaxDataLength()];
            } else if (clazz == Format.shortArray) {
                object2 = new short[rGBFormat2.getMaxDataLength()];
            } else if (clazz == Format.intArray) {
                object2 = new int[rGBFormat2.getMaxDataLength()];
            } else {
                return 1;
            }
            buffer2.setData(object2);
        }
        if (object2.getClass() != this.outputFormat.getDataType()) {
            return 1;
        }
        int n4 = rGBFormat.getBitsPerPixel();
        int n5 = rGBFormat2.getBitsPerPixel();
        boolean bl = rGBFormat.getDataType() != Format.byteArray;
        boolean bl2 = rGBFormat2.getDataType() != Format.byteArray;
        int n6 = rGBFormat.getPixelStride();
        int n7 = rGBFormat2.getPixelStride();
        int n8 = rGBFormat.getEndian();
        int n9 = rGBFormat2.getEndian();
        int n10 = rGBFormat.getRedMask();
        int n11 = rGBFormat.getGreenMask();
        int n12 = rGBFormat.getBlueMask();
        int n13 = rGBFormat2.getRedMask();
        int n14 = rGBFormat2.getGreenMask();
        int n15 = rGBFormat2.getBlueMask();
        int n16 = rGBFormat.getLineStride();
        int n17 = rGBFormat2.getLineStride();
        boolean bl3 = rGBFormat.getFlipped() != rGBFormat2.getFlipped();
        Dimension dimension = rGBFormat.getSize();
        int n18 = dimension.width;
        int n19 = dimension.height;
        if (n4 == 16 && n5 == 16) {
            this.sixteenToSixteen(object, n6, n16, n4, n10, n11, n12, bl, n8, object2, n7, n17, n5, n13, n14, n15, bl2, n9, n18, n19, bl3);
        } else if (n4 == 16 && n5 >= 24) {
            this.sixteenToComponent(object, n6, n16, n4, n10, n11, n12, bl, n8, object2, n7, n17, n5, n13, n14, n15, bl2, n9, n18, n19, bl3);
        } else if (n4 >= 24 && n5 == 16) {
            this.componentToSixteen(object, n6, n16, n4, n10, n11, n12, bl, n8, object2, n7, n17, n5, n13, n14, n15, bl2, n9, n18, n19, bl3);
        } else if (n4 >= 24 && n5 >= 24) {
            this.componentToComponent(object, n6, n16, n4, n10, n11, n12, bl, n8, object2, n7, n17, n5, n13, n14, n15, bl2, n9, n18, n19, bl3);
        }
        buffer2.setFormat(this.outputFormat);
        buffer2.setLength(rGBFormat2.getMaxDataLength());
        return 0;
    }

    public void reset() {
    }

    public Format setInputFormat(Format format) {
        Format format2 = super.setInputFormat(format);
        if (format2 == null) {
            return null;
        }
        if (((RGBFormat)format2).getBitsPerPixel() < 15) {
            return null;
        }
        Dimension dimension = ((VideoFormat)format).getSize();
        if (this.opened) {
            this.outputFormat = this.updateRGBFormat((VideoFormat)format, (RGBFormat)this.outputFormat);
        }
        return format2;
    }

    protected abstract void sixteenToComponent(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, int var9, Object var10, int var11, int var12, int var13, int var14, int var15, int var16, boolean var17, int var18, int var19, int var20, boolean var21);

    protected abstract void sixteenToSixteen(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, int var9, Object var10, int var11, int var12, int var13, int var14, int var15, int var16, boolean var17, int var18, int var19, int var20, boolean var21);
}

