/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.colorspace;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.codec.video.colorspace.JavaRGBToYUV;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.control.FrameProcessingControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class JavaRGBToYUV
extends BasicCodec {
    private static final String PLUGIN_NAME = "RGB To YUV";
    private FrameProcessingControl frameControl = null;
    private boolean dropFrame = false;

    public JavaRGBToYUV() {
        int n2 = -1;
        this.inputFormats = new Format[]{new RGBFormat(null, n2, Format.byteArray, n2, 24, n2, n2, n2, n2, n2, n2, n2), new RGBFormat(null, n2, Format.intArray, n2, 32, 0xFF0000, 65280, 255, 1, n2, n2, n2), new RGBFormat(null, n2, Format.intArray, n2, 32, 255, 65280, 0xFF0000, 1, n2, n2, n2)};
        this.outputFormats = new Format[]{new YUVFormat(2)};
        if (this.frameControl == null) {
            class FPC
            implements FrameProcessingControl {
                private final /* synthetic */ JavaRGBToYUV this$0;

                FPC(JavaRGBToYUV javaRGBToYUV) {
                    this.this$0 = javaRGBToYUV;
                }

                public Component getControlComponent() {
                    return null;
                }

                public int getFramesDropped() {
                    return 0;
                }

                public void setFramesBehind(float f2) {
                    if (f2 > 0.0f) {
                        JavaRGBToYUV.access$1(this.this$0, true);
                    } else {
                        JavaRGBToYUV.access$1(this.this$0, false);
                    }
                }

                public boolean setMinimalProcessing(boolean bl) {
                    JavaRGBToYUV.access$1(this.this$0, bl);
                    return JavaRGBToYUV.access$0(this.this$0);
                }
            }
            this.frameControl = new FPC(this);
            this.controls = new Control[1];
            this.controls[0] = this.frameControl;
        }
    }

    static /* synthetic */ boolean access$0(JavaRGBToYUV javaRGBToYUV) {
        return javaRGBToYUV.dropFrame;
    }

    static /* synthetic */ void access$1(JavaRGBToYUV javaRGBToYUV, boolean bl) {
        javaRGBToYUV.dropFrame = bl;
    }

    protected int convert24(Buffer buffer, Buffer buffer2) {
        RGBFormat rGBFormat = (RGBFormat)buffer.getFormat();
        YUVFormat yUVFormat = (YUVFormat)buffer2.getFormat();
        Dimension dimension = rGBFormat.getSize();
        byte[] byArray = (byte[])buffer2.getData();
        byte[] byArray2 = (byte[])buffer.getData();
        boolean bl = rGBFormat.getFlipped() == 1;
        int n2 = bl ? -1 : 1;
        int n3 = yUVFormat.getStrideY();
        int n4 = yUVFormat.getStrideUV();
        int n5 = yUVFormat.getOffsetY() + n3 * (bl ? dimension.height - 1 : 0);
        int n6 = yUVFormat.getOffsetU() + n4 * (bl ? dimension.height / 2 - 1 : 0);
        int n7 = yUVFormat.getOffsetV() + n4 * (bl ? dimension.height / 2 - 1 : 0);
        int n8 = 0;
        int n9 = rGBFormat.getLineStride();
        int n10 = rGBFormat.getPixelStride();
        int n11 = rGBFormat.getRedMask() - 1;
        int n12 = rGBFormat.getGreenMask() - 1;
        int n13 = rGBFormat.getBlueMask() - 1;
        int n14 = 0;
        while (n14 < dimension.height) {
            int n15 = 0;
            while (n15 < dimension.width) {
                int n16 = byArray2[n8 + n11] & 0xFF;
                int n17 = byArray2[n8 + n12] & 0xFF;
                int n18 = byArray2[n8 + n13] & 0xFF;
                int n19 = (n16 * 257 + n17 * 504 + n18 * 98) / 1000 + 16;
                int n20 = (-n16 * 148 - n17 * 291 + n18 * 439) / 1000 + 128;
                int n21 = (n16 * 439 - n17 * 368 - n18 * 71) / 1000 + 128;
                byArray[n5] = (byte)(n19 & 0xFF);
                n16 = byArray2[n8 + n11 + n10] & 0xFF;
                n17 = byArray2[n8 + n12 + n10] & 0xFF;
                n18 = byArray2[n8 + n13 + n10] & 0xFF;
                n19 = (n16 * 257 + n17 * 504 + n18 * 98) / 1000 + 16;
                n20 += (-n16 * 148 - n17 * 291 + n18 * 439) / 1000 + 128;
                n21 += (n16 * 439 - n17 * 368 - n18 * 71) / 1000 + 128;
                byArray[n5 + 1] = (byte)(n19 & 0xFF);
                n16 = byArray2[n8 + n11 + n9] & 0xFF;
                n17 = byArray2[n8 + n12 + n9] & 0xFF;
                n18 = byArray2[n8 + n13 + n9] & 0xFF;
                n19 = (n16 * 257 + n17 * 504 + n18 * 98) / 1000 + 16;
                n20 += (-n16 * 148 - n17 * 291 + n18 * 439) / 1000 + 128;
                n21 += (n16 * 439 - n17 * 368 - n18 * 71) / 1000 + 128;
                byArray[n5 + n2 * n3] = (byte)(n19 & 0xFF);
                n16 = byArray2[n8 + n11 + n9 + n10] & 0xFF;
                n17 = byArray2[n8 + n12 + n9 + n10] & 0xFF;
                n18 = byArray2[n8 + n13 + n9 + n10] & 0xFF;
                n19 = (n16 * 257 + n17 * 504 + n18 * 98) / 1000 + 16;
                byArray[n5 + n2 * n3 + 1] = (byte)(n19 & 0xFF);
                byArray[n6] = (byte)((n20 += (-n16 * 148 - n17 * 291 + n18 * 439) / 1000 + 128) >> 2 & 0xFF);
                byArray[n7] = (byte)((n21 += (n16 * 439 - n17 * 368 - n18 * 71) / 1000 + 128) >> 2 & 0xFF);
                n5 += 2;
                ++n6;
                ++n7;
                n8 += n10 * 2;
                n15 += 2;
            }
            n8 += n9 * 2 - dimension.width * n10;
            n5 += n2 * n3 * 2 - dimension.width;
            n6 += n2 * n4 - dimension.width / 2;
            n7 += n2 * n4 - dimension.width / 2;
            n14 += 2;
        }
        return 0;
    }

    protected int convertInt(Buffer buffer, Buffer buffer2) {
        RGBFormat rGBFormat = (RGBFormat)buffer.getFormat();
        YUVFormat yUVFormat = (YUVFormat)buffer2.getFormat();
        Dimension dimension = rGBFormat.getSize();
        byte[] byArray = (byte[])buffer2.getData();
        int[] nArray = (int[])buffer.getData();
        boolean bl = rGBFormat.getFlipped() == 1;
        int n2 = bl ? -1 : 1;
        int n3 = yUVFormat.getStrideY();
        int n4 = yUVFormat.getStrideUV();
        int n5 = yUVFormat.getOffsetY() + n3 * (bl ? dimension.height - 1 : 0);
        int n6 = yUVFormat.getOffsetU() + n4 * (bl ? dimension.height / 2 - 1 : 0);
        int n7 = yUVFormat.getOffsetV() + n4 * (bl ? dimension.height / 2 - 1 : 0);
        int n8 = 0;
        int n9 = rGBFormat.getLineStride();
        int n10 = 16;
        int n11 = 8;
        int n12 = 0;
        if (rGBFormat.getRedMask() == 255) {
            n10 = 0;
            n12 = 16;
        }
        int n13 = 0;
        while (n13 < dimension.height) {
            int n14 = 0;
            while (n14 < dimension.width) {
                int n15 = nArray[n8] >> n10 & 0xFF;
                int n16 = nArray[n8] >> n11 & 0xFF;
                int n17 = nArray[n8] >> n12 & 0xFF;
                int n18 = (n15 * 257 + n16 * 504 + n17 * 98) / 1000 + 16;
                int n19 = (-n15 * 148 - n16 * 291 + n17 * 439) / 1000 + 128;
                int n20 = (n15 * 439 - n16 * 368 - n17 * 71) / 1000 + 128;
                byArray[n5] = (byte)(n18 & 0xFF);
                n15 = nArray[n8 + 1] >> n10 & 0xFF;
                n16 = nArray[n8 + 1] >> n11 & 0xFF;
                n17 = nArray[n8 + 1] >> n12 & 0xFF;
                n18 = (n15 * 257 + n16 * 504 + n17 * 98) / 1000 + 16;
                n19 += (-n15 * 148 - n16 * 291 + n17 * 439) / 1000 + 128;
                n20 += (n15 * 439 - n16 * 368 - n17 * 71) / 1000 + 128;
                byArray[n5 + 1] = (byte)(n18 & 0xFF);
                n15 = nArray[n8 + n9] >> n10 & 0xFF;
                n16 = nArray[n8 + n9] >> n11 & 0xFF;
                n17 = nArray[n8 + n9] >> n12 & 0xFF;
                n18 = (n15 * 257 + n16 * 504 + n17 * 98) / 1000 + 16;
                n19 += (-n15 * 148 - n16 * 291 + n17 * 439) / 1000 + 128;
                n20 += (n15 * 439 - n16 * 368 - n17 * 71) / 1000 + 128;
                byArray[n5 + n2 * n3] = (byte)(n18 & 0xFF);
                n15 = nArray[n8 + n9 + 1] >> n10 & 0xFF;
                n16 = nArray[n8 + n9 + 1] >> n11 & 0xFF;
                n17 = nArray[n8 + n9 + 1] >> n12 & 0xFF;
                n18 = (n15 * 257 + n16 * 504 + n17 * 98) / 1000 + 16;
                byArray[n5 + n2 * n3 + 1] = (byte)(n18 & 0xFF);
                byArray[n6] = (byte)((n19 += (-n15 * 148 - n16 * 291 + n17 * 439) / 1000 + 128) >> 2 & 0xFF);
                byArray[n7] = (byte)((n20 += (n15 * 439 - n16 * 368 - n17 * 71) / 1000 + 128) >> 2 & 0xFF);
                n5 += 2;
                ++n6;
                ++n7;
                n8 += 2;
                n14 += 2;
            }
            n8 += n9 * 2 - dimension.width;
            n5 += n2 * n3 * 2 - dimension.width;
            n6 += n2 * n4 - dimension.width / 2;
            n7 += n2 * n4 - dimension.width / 2;
            n13 += 2;
        }
        return 0;
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (format instanceof RGBFormat && BasicPlugIn.matches(format, this.inputFormats) != null) {
            RGBFormat rGBFormat = (RGBFormat)format;
            Dimension dimension = rGBFormat.getSize();
            float f2 = rGBFormat.getFrameRate();
            int n2 = rGBFormat.getBitsPerPixel();
            int n3 = dimension.width + 1 & 0xFFFFFFFE;
            YUVFormat yUVFormat = new YUVFormat(dimension, n3 * dimension.height * 3 / 2, Format.byteArray, f2, 2, n3, n3 / 2, 0, n3 * dimension.height, n3 * dimension.height * 5 / 4);
            Format[] formatArray = new Format[]{yUVFormat};
            return formatArray;
        }
        return new Format[0];
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        if (this.dropFrame) {
            buffer2.setFlags(buffer2.getFlags() | 2);
            return 0;
        }
        Format format = buffer.getFormat();
        if (!(format instanceof RGBFormat) || buffer.getData() == null) {
            return 1;
        }
        Object object = buffer.getData();
        this.validateByteArraySize(buffer2, ((VideoFormat)this.outputFormat).getMaxDataLength());
        buffer2.setFormat(this.outputFormat);
        buffer2.setLength(((VideoFormat)this.outputFormat).getMaxDataLength());
        if (((RGBFormat)format).getBitsPerPixel() == 24) {
            return this.convert24(buffer, buffer2);
        }
        return this.convertInt(buffer, buffer2);
    }

    public void reset() {
    }

    public Format setInputFormat(Format format) {
        Format format2 = super.setInputFormat(format);
        if (this.opened) {
            this.outputFormat = this.getSupportedOutputFormats(format2)[0];
        }
        return format2;
    }
}

