/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.cinepak;

import com.ibm.media.codec.video.VideoCodec;
import com.sun.media.codec.video.cinepak.CineStore;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class JavaDecoder
extends VideoCodec {
    private static final int rMask = 255;
    private static final int gMask = 65280;
    private static final int bMask = 0xFF0000;
    private int[] refData = null;
    private CineStore fOurStore;

    public JavaDecoder() {
        this.supportedInputFormats = new VideoFormat[]{new VideoFormat("cvid")};
        this.defaultOutputFormats = new VideoFormat[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, 0, -1)};
        this.PLUGIN_NAME = "Cinepak Decoder";
    }

    public void close() {
        this.fOurStore = null;
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension dimension = videoFormat.getSize();
        int n2 = dimension.width + 3 & 0xFFFFFFFC;
        int n3 = dimension.height + 3 & 0xFFFFFFFC;
        this.supportedOutputFormats = new VideoFormat[]{new RGBFormat(new Dimension(dimension), n2 * n3, Format.intArray, videoFormat.getFrameRate(), 32, 255, 65280, 0xFF0000)};
        return this.supportedOutputFormats;
    }

    protected void initDecoder() {
        this.fOurStore = new CineStore();
    }

    public void open() throws ResourceUnavailableException {
        this.initDecoder();
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        VideoFormat videoFormat = (VideoFormat)buffer.getFormat();
        int n2 = buffer.getLength();
        int n3 = videoFormat.getMaxDataLength();
        int n4 = this.outputFormat.getMaxDataLength();
        byte[] byArray = (byte[])buffer.getData();
        int[] nArray = this.validateIntArraySize(buffer2, n4);
        if (this.refData == null) {
            this.refData = nArray;
            buffer2.setData(null);
            nArray = this.validateIntArraySize(buffer2, n4);
        }
        buffer2.setData(this.refData);
        buffer2.setFormat(this.outputFormat);
        this.fOurStore.DoFrame(buffer, buffer2, this.fOurStore);
        System.arraycopy(this.refData, 0, nArray, 0, n4);
        buffer2.setData(nArray);
        this.updateOutput(buffer2, this.outputFormat, n4, 0);
        return 0;
    }

    public void reset() {
    }

    protected void videoResized() {
        this.initDecoder();
    }
}

