/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.ulaw;

import com.ibm.media.codec.audio.AudioPacketizer;
import com.sun.media.codec.audio.ulaw.PacketSizeAdapter;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class Packetizer
extends AudioPacketizer {
    public Packetizer() {
        this.packetSize = 480;
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("ULAW", -1.0, 8, 1, -1, -1, 8, -1.0, Format.byteArray)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("ULAW/rtp", -1.0, 8, 1, -1, -1, 8, -1.0, Format.byteArray)};
        this.PLUGIN_NAME = "Mu-Law Packetizer";
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new PacketSizeAdapter(this, this.packetSize, true);
        }
        return this.controls;
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("ULAW/rtp", audioFormat.getSampleRate(), 8, 1, -1, -1, 8, -1.0, Format.byteArray)};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        this.setPacketSize(this.packetSize);
        this.reset();
    }

    public synchronized void setPacketSize(int n2) {
        this.sample_count = this.packetSize = n2;
        if (this.history == null) {
            this.history = new byte[this.packetSize];
            return;
        }
        if (this.packetSize > this.history.length) {
            byte[] byArray = new byte[this.packetSize];
            System.arraycopy(this.history, 0, byArray, 0, this.historyLength);
            this.history = byArray;
        }
    }
}

