/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.protocol;

import java.io.IOException;
import java.util.Vector;
import javax.media.Time;
import javax.media.protocol.DataSource;
import javax.media.protocol.SourceStream;

class MergingDataSource
extends DataSource {
    DataSource[] sources;
    SourceStream[] streams = null;
    Object[] controls = null;

    MergingDataSource(DataSource[] dataSourceArray) {
        this.sources = dataSourceArray;
    }

    public void connect() throws IOException {
        int n2 = 0;
        while (n2 < this.sources.length) {
            this.sources[n2].connect();
            ++n2;
        }
    }

    public void disconnect() {
        int n2 = 0;
        while (n2 < this.sources.length) {
            this.sources[n2].disconnect();
            ++n2;
        }
    }

    public String getContentType() {
        if (this.sources.length == 1) {
            return this.sources[0].getContentType();
        }
        boolean bl = true;
        int n2 = 0;
        while (n2 < this.sources.length) {
            if (!this.sources[n2].getContentType().equals("raw")) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            return "raw";
        }
        if (this.sources.length == 1) {
            return this.sources[0].getContentType();
        }
        return "application.mixed-data";
    }

    public Object getControl(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object[] objectArray = this.getControls();
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (clazz.isInstance(objectArray[n2])) {
                    return objectArray[n2];
                }
                ++n2;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object[] getControls() {
        if (this.controls == null) {
            Vector<Object> vector = new Vector<Object>(1);
            int n2 = 0;
            while (n2 < this.sources.length) {
                Object[] objectArray = this.sources[n2].getControls();
                if (objectArray.length > 0) {
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        vector.addElement(objectArray[n3]);
                        ++n3;
                    }
                }
                ++n2;
            }
            this.controls = new Object[vector.size()];
            int n4 = 0;
            while (n4 < vector.size()) {
                this.controls[n4] = vector.elementAt(n4);
                ++n4;
            }
        }
        return this.controls;
    }

    public Time getDuration() {
        Time time = new Time(0L);
        int n2 = 0;
        while (n2 < this.sources.length) {
            Time time2 = this.sources[n2].getDuration();
            if (time2.getSeconds() > time.getSeconds()) {
                time = time2;
            }
            ++n2;
        }
        return time;
    }

    public void start() throws IOException {
        int n2 = 0;
        while (n2 < this.sources.length) {
            this.sources[n2].start();
            ++n2;
        }
    }

    public void stop() throws IOException {
        int n2 = 0;
        while (n2 < this.sources.length) {
            this.sources[n2].stop();
            ++n2;
        }
    }
}

