/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.video.h263;

import com.ibm.media.codec.video.VideoCodec;
import com.ibm.media.codec.video.h263.FrameBuffer;
import com.ibm.media.codec.video.h263.H263Decoder;
import com.ibm.media.codec.video.h263.YCbCrToRGB;
import com.sun.media.BasicPlugIn;
import com.sun.media.JMFSecurityManager;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class JavaDecoder
extends VideoCodec {
    private static final int rMask = 255;
    private static final int gMask = 65280;
    private static final int bMask = 0xFF0000;
    private static final boolean DEBUG = false;
    private H263Decoder javaDecoder;
    private FrameBuffer outputFrame;
    public static final int[] widths;
    public static final int[] heights;
    private int videoWidth = 176;
    private int videoHeight = 144;
    private boolean FormatSizeInitFlag = false;
    private int payloadLength = 4;
    static boolean nativeAvail;
    static /* synthetic */ Class array$I;

    static {
        block2: {
            int[] nArray = new int[8];
            nArray[1] = 128;
            nArray[2] = 176;
            nArray[3] = 352;
            nArray[4] = 704;
            nArray[5] = 1408;
            widths = nArray;
            int[] nArray2 = new int[8];
            nArray2[1] = 96;
            nArray2[2] = 144;
            nArray2[3] = 288;
            nArray2[4] = 576;
            nArray2[5] = 1152;
            heights = nArray2;
            nativeAvail = false;
            if (!BasicPlugIn.plugInExists("com.sun.media.codec.video.vh263.NativeDecoder", 2)) break block2;
            try {
                JMFSecurityManager.loadLibrary("jmutil");
                JMFSecurityManager.loadLibrary("jmvh263");
                nativeAvail = true;
            }
            catch (Throwable throwable) {}
        }
    }

    public JavaDecoder() {
        this.supportedInputFormats = new VideoFormat[]{new VideoFormat("h263"), new VideoFormat("h263/rtp")};
        this.defaultOutputFormats = new VideoFormat[]{new RGBFormat()};
        this.PLUGIN_NAME = "H.263 Decoder";
    }

    public boolean checkFormat(Format format) {
        if (format.getEncoding().equals("h263/rtp")) {
            return true;
        }
        return super.checkFormat(format);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() {
        this.javaDecoder = null;
    }

    boolean decodeData(Buffer buffer, int n2, Buffer buffer2, boolean bl) {
        int n3;
        int[] nArray = (int[])buffer2.getData();
        byte[] byArray = (byte[])buffer.getData();
        if (n2 <= 0) {
            return false;
        }
        this.javaDecoder.initBitstream();
        int n4 = buffer.getOffset();
        if (bl) {
            n3 = this.javaDecoder.DecodeRtpPacket(byArray, n4 + this.payloadLength, n2, byArray, n4, buffer.getTimeStamp());
            if (n3 == 3) {
                return false;
            }
        } else {
            n3 = this.javaDecoder.DecodePicture(byArray, n4, true);
        }
        if (n3 == 2) {
            throw new RuntimeException("Currently this picture format is not supported!");
        }
        if (n3 == 1) {
            int n5 = this.outputFormat.getSize().width;
            int n6 = this.outputFormat.getSize().height;
            this.outputFrame = this.javaDecoder.CurrentFrame;
            YCbCrToRGB.convert(this.outputFrame.Y, this.outputFrame.Cb, this.outputFrame.Cr, nArray, this.outputFrame.width, this.outputFrame.height, n5, n6, 255, 4);
            return true;
        }
        return false;
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension dimension = videoFormat.getSize();
        int n2 = videoFormat.getMaxDataLength();
        this.supportedOutputFormats = videoFormat.getEncoding().equals("h263/rtp") ? new VideoFormat[]{new RGBFormat(new Dimension(this.videoWidth, this.videoHeight), this.videoWidth * this.videoHeight, array$I != null ? array$I : (array$I = JavaDecoder.class$("[I")), videoFormat.getFrameRate(), 32, 255, 65280, 0xFF0000, 1, this.videoWidth, 0, -1)} : new VideoFormat[]{new RGBFormat(new Dimension(dimension), dimension.width * dimension.height, array$I != null ? array$I : (array$I = JavaDecoder.class$("[I")), videoFormat.getFrameRate(), 32, 255, 65280, 0xFF0000, 1, dimension.width, 0, -1)};
        return this.supportedOutputFormats;
    }

    public static int getPayloadHeaderLength(byte[] byArray, int n2) {
        int n3 = 0;
        byte by = byArray[n2];
        n3 = (by & 0x80) != 0 ? ((by & 0x40) != 0 ? 12 : 8) : 4;
        return n3;
    }

    protected void initDecoder() {
        this.javaDecoder = new H263Decoder(true);
    }

    public void open() throws ResourceUnavailableException {
        this.initDecoder();
    }

    public int process(Buffer buffer, Buffer buffer2) {
        int n2;
        boolean bl = false;
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        VideoFormat videoFormat = (VideoFormat)buffer.getFormat();
        int n3 = buffer.getLength();
        int n4 = videoFormat.getMaxDataLength();
        int n5 = this.outputFormat.getMaxDataLength();
        int n6 = buffer.getOffset();
        byte[] byArray = (byte[])buffer.getData();
        if (videoFormat.getEncoding().equals("h263/rtp")) {
            bl = true;
            this.payloadLength = JavaDecoder.getPayloadHeaderLength(byArray, n6);
            if (byArray[n6 + this.payloadLength] == 0 && byArray[n6 + this.payloadLength + 1] == 0 && (byArray[n6 + this.payloadLength + 2] & 0xFC) == 128) {
                int n7 = byArray[n6 + this.payloadLength + 4] >> 2 & 7;
                if (this.videoWidth != widths[n7] || this.videoHeight != heights[n7]) {
                    this.videoWidth = widths[n7];
                    this.videoHeight = heights[n7];
                    this.outputFormat = new RGBFormat(new Dimension(this.videoWidth, this.videoHeight), this.videoWidth * this.videoHeight, array$I != null ? array$I : (array$I = JavaDecoder.class$("[I")), videoFormat.getFrameRate(), 32, 255, 65280, 0xFF0000, 1, this.videoWidth, 0, -1);
                    n5 = this.videoWidth * this.videoHeight;
                    if (this.FormatSizeInitFlag) {
                        this.videoResized();
                    }
                }
                this.FormatSizeInitFlag = true;
            }
            if (!this.FormatSizeInitFlag) {
                return 1;
            }
        }
        int[] nArray = this.validateIntArraySize(buffer2, n5);
        if (n3 + 8 + n6 > byArray.length) {
            n2 = n3 > n4 ? n3 : n4;
            byte[] byArray2 = new byte[n6 + n2 + 8];
            System.arraycopy(byArray, 0, byArray2, 0, n3 + n6);
            byArray = byArray2;
            buffer.setData(byArray2);
        }
        byArray[n6 + n3] = 0;
        byArray[n6 + n3 + 1] = 0;
        byArray[n6 + n3 + 2] = -4;
        buffer.setLength(n3 += 3);
        if (bl) {
            n3 -= this.payloadLength;
        }
        if ((n2 = (int)(this.decodeData(buffer, n3, buffer2, bl) ? 1 : 0)) != 0) {
            this.updateOutput(buffer2, this.outputFormat, n5, 0);
            return 0;
        }
        return 4;
    }

    public void reset() {
        this.initDecoder();
    }

    public Format setInputFormat(Format format) {
        if (nativeAvail) {
            return null;
        }
        if (super.setInputFormat(format) != null) {
            this.reset();
            return format;
        }
        return null;
    }

    protected void videoResized() {
        this.initDecoder();
    }
}

