/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.rc;

import com.ibm.media.codec.audio.AudioCodec;
import com.ibm.media.codec.audio.rc.RateConversion;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class RCModule
extends AudioCodec {
    private RateConversion rateConversion = null;
    private Format lastInputFormat = null;
    private Format lastOutputFormat = null;
    private static boolean DEBUG = false;

    public RCModule() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", -1.0, 16, 2, -1, -1), new AudioFormat("LINEAR", -1.0, 16, 1, -1, -1), new AudioFormat("LINEAR", -1.0, 8, 2, -1, -1), new AudioFormat("LINEAR", -1.0, 8, 1, -1, -1)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", 8000.0, 16, 2, 0, 1), new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1)};
        this.PLUGIN_NAME = "Rate Conversion";
    }

    public void close() {
        if (this.rateConversion != null) {
            this.rateConversion.close();
        }
        this.rateConversion = null;
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        if (!this.isSampleRateSupported(format)) {
            return new Format[0];
        }
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1), new AudioFormat("LINEAR", 8000.0, 16, 2, 0, 1)};
        return this.supportedOutputFormats;
    }

    private boolean initConverter(AudioFormat audioFormat, AudioFormat audioFormat2, int n2) {
        this.lastInputFormat = audioFormat;
        this.lastOutputFormat = audioFormat2;
        boolean bl = false;
        int n3 = audioFormat.getChannels();
        int n4 = audioFormat2.getChannels();
        int n5 = audioFormat.getSampleSizeInBits();
        int n6 = (int)audioFormat.getSampleRate();
        boolean bl2 = false;
        if (n6 == 8000) {
            return false;
        }
        int n7 = 1;
        if (audioFormat.getEndian() == 1) {
            n7 = 0;
        }
        if (n5 == 8) {
            n7 = 2;
        }
        if (audioFormat.getSigned() == 1) {
            bl = true;
        }
        if (this.rateConversion != null) {
            this.close();
        }
        if (audioFormat2.getEncoding() == "ULAW") {
            bl2 = true;
        }
        this.rateConversion = new RateConversion();
        if (this.rateConversion.init(n2, n6, 8000, n3, n4, n7, bl, bl2) != -1) {
            this.rateConversion = null;
            return false;
        }
        return true;
    }

    private boolean isSampleRateSupported(Format format) {
        try {
            int n2 = (int)((AudioFormat)format).getSampleRate();
            if (n2 != 11025 && n2 != 11127 && n2 != 16000 && n2 != 22050 && n2 != 22254 && n2 != 22255 && n2 != 32000 && n2 != 44100 && n2 != 48000) {
                if (DEBUG) {
                    System.out.println("RCModule - input format sampling rate isn't supported");
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public void open() throws ResourceUnavailableException {
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        int n2 = buffer.getLength();
        if (!(this.lastInputFormat == this.inputFormat && this.lastOutputFormat == this.outputFormat && this.rateConversion != null || this.initConverter(this.inputFormat, this.outputFormat, n2))) {
            return 1;
        }
        int n3 = this.rateConversion.getMaxOutputLength(n2);
        byte[] byArray = (byte[])buffer.getData();
        byte[] byArray2 = this.validateByteArraySize(buffer2, n3);
        int n4 = this.rateConversion.process(byArray, buffer.getOffset(), n2, byArray2, buffer2.getOffset());
        this.updateOutput(buffer2, this.outputFormat, n4, buffer2.getOffset());
        return 0;
    }

    public void reset() {
        if (this.rateConversion != null) {
            this.rateConversion.reset();
        }
    }

    public Format setInputFormat(Format format) {
        if (!this.isSampleRateSupported(format)) {
            return null;
        }
        return super.setInputFormat(format);
    }
}

