/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.ima4;

import com.ibm.media.codec.audio.AudioCodec;
import com.ibm.media.codec.audio.ima4.IMA4;
import com.ibm.media.codec.audio.ima4.IMA4State;
import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class JavaDecoder_ms
extends AudioCodec {
    private IMA4State ima4state;

    public JavaDecoder_ms() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("ima4/ms")};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR")};
        this.PLUGIN_NAME = "IMA4 MS Decoder";
    }

    public void close() {
        this.ima4state = null;
    }

    private int decodeJavaMSIMA4(byte[] byArray, byte[] byArray2, int n2, int n3, int n4, int n5) {
        switch (n4) {
            case 1: {
                return this.decodeMSIMA4mono(byArray, byArray2, n2, n3, n5);
            }
            case 2: {
                return this.decodeMSIMA4stereo(byArray, byArray2, n2, n3, n5);
            }
        }
        throw new RuntimeException("MSIMA4: Can only handle 1 or 2 channels\n");
    }

    private int decodeMSIMA4mono(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        n2 = n2 / n4 * n4;
        while (n5 < n2) {
            int n7;
            int n8 = byArray[n5++] & 0xFF;
            n8 |= byArray[n5++] << 8;
            if ((n7 = byArray[n5++] & 0xFF) > 88) {
                n7 = 88;
            }
            byArray2[n6++] = (byte)(n8 >> 8);
            byArray2[n6++] = (byte)n8;
            this.ima4state.valprev = n8;
            this.ima4state.index = n7;
            IMA4.decode(byArray, ++n5, byArray2, n6, n4 - 4 << 1, this.ima4state, 0);
            n5 += n4 - 4;
            n6 += n4 - 4 << 2;
        }
        return n6;
    }

    private int decodeMSIMA4stereo(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        n2 = n2 / n4 * n4;
        int n7 = 0;
        while (n7 < byArray2.length) {
            byArray2[n7] = 0;
            ++n7;
        }
        while (n5 < n2) {
            int n8;
            int n9;
            int n10 = n5;
            int n11 = n6;
            int n12 = byArray[n5++] & 0xFF;
            n12 |= byArray[n5++] << 8;
            if ((n9 = byArray[n5++] & 0xFF) > 88) {
                n9 = 88;
            }
            ++n5;
            byArray2[n6++] = (byte)(n12 >> 8);
            byArray2[n6++] = (byte)n12;
            n6 += 2;
            n5 += 4;
            this.ima4state.valprev = n12;
            this.ima4state.index = n9;
            int n13 = n4 - 8;
            while (n13 > 0) {
                IMA4.decode(byArray, n5, byArray2, n6, 8, this.ima4state, 2);
                n5 += 8;
                n6 += 32;
                n13 -= 8;
            }
            n5 = n10 + 4;
            n6 = n11 + 2;
            int n14 = byArray[n5++] & 0xFF;
            n14 |= byArray[n5++] << 8;
            if ((n8 = byArray[n5++] & 0xFF) > 88) {
                n8 = 88;
            }
            ++n5;
            byArray2[n6++] = (byte)(n14 >> 8);
            byArray2[n6++] = (byte)n14;
            this.ima4state.valprev = n14;
            this.ima4state.index = n8;
            n6 += 2;
            n5 += 4;
            int n15 = n4 - 8;
            while (n15 > 0) {
                IMA4.decode(byArray, n5, byArray2, n6, 8, this.ima4state, 2);
                n5 += 8;
                n6 += 32;
                n15 -= 8;
            }
            n5 = n10 + n4;
            n6 = n11 + (n4 - 8 << 2) + 4;
        }
        return n6;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new SilenceSuppressionAdapter(this, false, false);
        }
        return this.controls;
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        int n2;
        AudioFormat audioFormat = (AudioFormat)format;
        int n3 = audioFormat.getFrameSizeInBits();
        if (n3 % (32 * (n2 = audioFormat.getChannels())) != 0) {
            return new Format[0];
        }
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, audioFormat.getChannels(), 1, 1)};
        return this.supportedOutputFormats;
    }

    public void open() {
        this.ima4state = new IMA4State();
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        int n2 = this.outputFormat.getChannels();
        byte[] byArray = (byte[])buffer.getData();
        byte[] byArray2 = this.validateByteArraySize(buffer2, byArray.length * 4);
        int n3 = this.inputFormat.getFrameSizeInBits() >> 3;
        int n4 = this.decodeJavaMSIMA4(byArray, byArray2, buffer.getLength(), byArray2.length, n2, n3);
        this.updateOutput(buffer2, this.outputFormat, n4, 0);
        return 0;
    }
}

