/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio;

import com.ibm.media.codec.audio.AudioCodec;
import javax.media.Buffer;

public abstract class BufferedEncoder
extends AudioCodec {
    protected int[] readBytes = new int[1];
    protected int[] writeBytes = new int[1];
    protected int[] frameNumber = new int[1];
    protected Buffer history = new Buffer();
    protected int[] regions;
    protected int[] regionsTypes;
    protected int pendingFrames;
    protected int packetSize = -1;
    protected int historySize;

    protected abstract int calculateFramesNumber(int var1);

    protected abstract int calculateOutputSize(int var1);

    protected abstract boolean codecProcess(byte[] var1, int var2, byte[] var3, int var4, int var5, int[] var6, int[] var7, int[] var8, int[] var9, int[] var10);

    protected abstract void codecReset();

    public int getPacketSize() {
        return this.packetSize;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (this.pendingFrames > 0) {
            return 0;
        }
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        int n2 = buffer.getOffset();
        int n3 = buffer.getLength();
        int n4 = 0;
        int n5 = 0;
        byte[] byArray = (byte[])buffer.getData();
        byte[] byArray2 = this.validateByteArraySize(buffer2, this.calculateOutputSize(byArray.length + this.historySize));
        int n6 = this.history.getLength();
        byte[] byArray3 = this.validateByteArraySize(this.history, this.historySize);
        int n7 = this.calculateFramesNumber(byArray.length + this.historySize);
        if (this.regions == null || this.regions.length < n7 + 1) {
            this.regions = new int[n7 + 1];
        }
        if (this.regionsTypes == null || this.regionsTypes.length < n7) {
            this.regionsTypes = new int[n7];
        }
        if (n6 != 0) {
            int n8 = byArray3.length - n6;
            if (n8 > n3) {
                n8 = n3;
            }
            System.arraycopy(byArray, n2, byArray3, n6, n8);
            this.codecProcess(byArray3, 0, byArray2, n5, n6 + n8, this.readBytes, this.writeBytes, this.frameNumber, this.regions, this.regionsTypes);
            if (this.readBytes[0] <= 0) {
                if (this.writeBytes[0] <= 0) {
                    return 4;
                }
                this.updateOutput(buffer2, this.outputFormat, this.writeBytes[0], 0);
                return 0;
            }
            n5 += this.writeBytes[0];
            n4 += this.writeBytes[0];
            n2 += this.readBytes[0] - n6;
            n3 += n6 - this.readBytes[0];
        }
        this.codecProcess(byArray, n2, byArray2, n5, n3, this.readBytes, this.writeBytes, this.frameNumber, this.regions, this.regionsTypes);
        System.arraycopy(byArray, n2 += this.readBytes[0], byArray3, 0, n3 -= this.readBytes[0]);
        this.history.setLength(n3);
        this.updateOutput(buffer2, this.outputFormat, n4 += this.writeBytes[0], 0);
        return 0;
    }

    public void reset() {
        this.history.setLength(0);
        this.codecReset();
    }

    public int setPacketSize(int n2) {
        this.packetSize = n2;
        return this.packetSize;
    }
}

