<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>
<%@ page import="java.net.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.session.*" %>
<%@ page import="com.workroll.app.mail.*" %>
<%@ page import="com.workroll.app.WorkRollConstants" %>
 
<% PageUtils.setRequiredLoginStatus("none",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ISSUES_POPUP,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%
int idToReturnToDialog=-1;
boolean success=false;
try
{

	ArrayList issues=(ArrayList)session.getAttribute("issuesForImport");
	if (issues==null)
	{
		throw new WorkRollException("Session expired from inactivity. Please attempt import again.");
	}
	
	for (int i=0; i<issues.size(); i++)
	{
		AbstractIssue issue=(AbstractIssue)issues.get(i);
		issue.setLastModifiedDate(new Date());
		// reset these:
		issue.setApproachingDeadlineReminderSent(false);
		issue.setMissedDeadlineReminderSent(false);
		if (issue.getStatus()==AbstractIssue.STATUS_CLOSED)
		{
			ClosedIssue newIssue=issue.getClosedCopy();
			Manager.insertClosedIssue(newIssue);
		}
		else
		{
			NonClosedIssue newIssue=issue.getNonClosedCopy();
			Manager.insertNonClosedIssue(newIssue);
		}
	}
	session.removeAttribute("issuesForImport");
	success=true;
}
catch (Throwable t)
{
	Printer.pe("doing insert",t);
	t.printStackTrace();
}
if (success)
{
	%>
	<script>
	location.replace("importSuccess.jsp");
	</script>
	<%
	response.flushBuffer();
}
else
{
	%>
	<script>
	location.replace("importFailure.jsp");
	</script>
	<%
	response.flushBuffer();
}
%>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>
