<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
  
<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setRequiredRequestMethod("POST",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%

String successParam;
try
{
	int numUsers=controller.getParamAsInt("numUsers");
	for (int i=0; i<numUsers; i++)
	{
		if (controller.getParam("username"+i).trim().length()>0)
		{
			// then this is a user to add (not a blank row):
			User user=new User();
			user.setUsername(controller.getParam("username"+i));
			user.setFullname(controller.getParam("fullname"+i));
			user.setEmailAddress(controller.getParam("emailAddress"+i));
			user.setPassword(controller.getParam("password"+i));
			user.setActive(controller.getParamAsBoolean("active"+i));
			user.setSuperUser(controller.getParamAsBoolean("superUser"+i));
			// it's possible (not likely given JS validationj) that a user
			// goes to the add-users page, enters new users, submits the form,
			// then uses the back button, makes changes, and submits
			// again.  This would result in duplicate usernames being inserted,
			// so check first for existence of user, then update instead of insert
			// if needed:
			User testUser=Manager.selectUserByUsername(controller.getParam("username"+i));
			Printer.p("testUser="+testUser+"");
			if (testUser==null)
			{
				Printer.p("inserting");
				Manager.insertUser(user);
			}
			else
			{
				// else (see above) user already exists:
				Printer.p("updating");
				Manager.updateUser(user);
			}
		}
	}
	successParam="true";
}
catch (Exception e)
{
	Printer.pe("storing new User(s)",e);
	successParam="false";
}

controller.redirect("showUserChanges.jsp?mode=add&success="+successParam);
%>

<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>





<% PageUtils.jspEnd(request); %>

