/*
 * Decompiled with CFR 0.152.
 */
package com.others;

import com.others.ImageCodec;
import com.others.ImageDecodeParam;
import com.others.ImageDecoder;
import com.others.ImageEncodeParam;
import com.others.ImageEncoder;
import com.others.PNGDecodeParam;
import com.others.PNGEncodeParam;
import com.others.PNGImageDecoder;
import com.others.PNGImageEncoder;
import com.others.SeekableStream;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class PNGCodec
extends ImageCodec {
    public String getFormatName() {
        return "png";
    }

    public Class getEncodeParamClass() {
        return Class.forName("com.others.PNGEncodeParam");
    }

    public Class getDecodeParamClass() {
        return Class.forName("com.others.PNGDecodeParam");
    }

    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        int n;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n2 = sampleModel.getTransferType();
        if (n2 == 4 || n2 == 5) {
            return false;
        }
        int[] nArray = sampleModel.getSampleSize();
        int n3 = nArray[0];
        for (n = 1; n < nArray.length; ++n) {
            if (nArray[n] == n3) continue;
            return false;
        }
        if (n3 < 1 || n3 > 16) {
            return false;
        }
        n = sampleModel.getNumBands();
        if (n < 1 || n > 4) {
            return false;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel && (n != 1 || n3 > 8)) {
            return false;
        }
        if (imageEncodeParam != null) {
            if (imageEncodeParam instanceof PNGEncodeParam) {
                if (colorModel instanceof IndexColorModel ? !(imageEncodeParam instanceof PNGEncodeParam.Palette) : (n < 3 ? !(imageEncodeParam instanceof PNGEncodeParam.Gray) : !(imageEncodeParam instanceof PNGEncodeParam.RGB))) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        PNGEncodeParam pNGEncodeParam = null;
        if (imageEncodeParam != null) {
            pNGEncodeParam = (PNGEncodeParam)imageEncodeParam;
        }
        return new PNGImageEncoder(outputStream, pNGEncodeParam);
    }

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        PNGDecodeParam pNGDecodeParam = null;
        if (imageDecodeParam != null) {
            pNGDecodeParam = (PNGDecodeParam)imageDecodeParam;
        }
        return new PNGImageDecoder(inputStream, pNGDecodeParam);
    }

    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        PNGDecodeParam pNGDecodeParam = null;
        if (imageDecodeParam != null) {
            pNGDecodeParam = (PNGDecodeParam)imageDecodeParam;
        }
        return new PNGImageDecoder((InputStream)new FileInputStream(file), pNGDecodeParam);
    }

    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        PNGDecodeParam pNGDecodeParam = null;
        if (imageDecodeParam != null) {
            pNGDecodeParam = (PNGDecodeParam)imageDecodeParam;
        }
        return new PNGImageDecoder((InputStream)seekableStream, pNGDecodeParam);
    }

    public int getNumHeaderBytes() {
        return 8;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == -119 && byArray[1] == 80 && byArray[2] == 78 && byArray[3] == 71 && byArray[4] == 13 && byArray[5] == 10 && byArray[6] == 26 && byArray[7] == 10;
    }
}

