/*
 * Decompiled with CFR 0.152.
 */
package com.others;

import com.others.BMPEncodeParam;
import com.others.ImageEncodeParam;
import com.others.ImageEncoderImpl;
import com.others.dlKhlHz;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;

public class BMPImageEncoder
extends ImageEncoderImpl {
    private OutputStream LTht;
    private int ltHt;
    private boolean LtHt;
    private boolean lTHt;
    private int LTHt;
    private int lthT;

    public BMPImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        this.LTht = outputStream;
        BMPEncodeParam bMPEncodeParam = imageEncodeParam == null ? new BMPEncodeParam() : (BMPEncodeParam)imageEncodeParam;
        this.ltHt = bMPEncodeParam.getVersion();
        this.LtHt = bMPEncodeParam.isCompressed();
        this.lTHt = bMPEncodeParam.isTopDown();
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = renderedImage.getMinX();
        int n5 = renderedImage.getMinY();
        this.LTHt = renderedImage.getWidth();
        this.lthT = renderedImage.getHeight();
        int n6 = 24;
        boolean bl = false;
        int n7 = 0;
        IndexColorModel indexColorModel = null;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n8 = sampleModel.getNumBands();
        ColorModel colorModel = renderedImage.getColorModel();
        if (n8 != 1 && n8 != 3) {
            throw new IllegalArgumentException(dlKhlHz.getString("BMPImageEncoder1"));
        }
        int[] nArray = sampleModel.getSampleSize();
        if (nArray[0] > 8) {
            throw new RuntimeException(dlKhlHz.getString("BMPImageEncoder2"));
        }
        for (n3 = 1; n3 < nArray.length; ++n3) {
            if (nArray[n3] == nArray[0]) continue;
            throw new RuntimeException(dlKhlHz.getString("BMPImageEncoder3"));
        }
        n3 = sampleModel.getTransferType();
        if (n3 == 1 || n3 == 2 || n3 == 3 || n3 == 4 || n3 == 5) {
            throw new RuntimeException(dlKhlHz.getString("BMPImageEncoder0"));
        }
        int n9 = this.LTHt * n8;
        int n10 = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (colorModel instanceof IndexColorModel) {
            bl = true;
            indexColorModel = (IndexColorModel)colorModel;
            n7 = indexColorModel.getMapSize();
            if (n7 <= 2) {
                n6 = 1;
                n9 = (int)Math.ceil((double)this.LTHt / 8.0);
            } else if (n7 <= 16) {
                n6 = 4;
                n9 = (int)Math.ceil((double)this.LTHt / 2.0);
            } else if (n7 <= 256) {
                n6 = 8;
            } else {
                n6 = 24;
                bl = false;
                n7 = 0;
                n9 = this.LTHt * 3;
            }
            if (bl) {
                byArray = new byte[n7];
                byArray2 = new byte[n7];
                byArray3 = new byte[n7];
                byArray4 = new byte[n7];
                indexColorModel.getAlphas(byArray4);
                indexColorModel.getReds(byArray);
                indexColorModel.getGreens(byArray2);
                indexColorModel.getBlues(byArray3);
            }
        } else if (n8 == 1) {
            bl = true;
            n7 = 256;
            n6 = nArray[0];
            n9 = (int)Math.ceil((double)(this.LTHt * n6) / 8.0);
            byArray = new byte[256];
            byArray2 = new byte[256];
            byArray3 = new byte[256];
            byArray4 = new byte[256];
            for (n2 = 0; n2 < 256; ++n2) {
                byArray[n2] = (byte)n2;
                byArray2[n2] = (byte)n2;
                byArray3[n2] = (byte)n2;
                byArray4[n2] = (byte)n2;
            }
        }
        n2 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = n7;
        int n18 = 0;
        int n19 = n9 % 4;
        if (n19 != 0) {
            n18 = 4 - n19;
        }
        switch (this.ltHt) {
            case 0: {
                n11 = 26 + n7 * 3;
                n12 = 12;
                n13 = (n9 + n18) * this.lthT;
                n2 = n13 + n11;
                throw new RuntimeException(dlKhlHz.getString("BMPImageEncoder5"));
            }
            case 1: {
                n11 = 54 + n7 * 4;
                n13 = (n9 + n18) * this.lthT;
                n2 = n13 + n11;
                n12 = 40;
                break;
            }
            case 2: {
                n12 = 108;
                throw new RuntimeException(dlKhlHz.getString("BMPImageEncoder5"));
            }
        }
        this.Ltht(n2, n11);
        this.lTht(n12, n6);
        this.writeDWord(n10);
        this.writeDWord(n13);
        this.writeDWord(n14);
        this.writeDWord(n15);
        this.writeDWord(n16);
        this.writeDWord(n17);
        if (bl) {
            switch (this.ltHt) {
                case 0: {
                    for (n = 0; n < n7; ++n) {
                        this.LTht.write(byArray3[n]);
                        this.LTht.write(byArray2[n]);
                        this.LTht.write(byArray[n]);
                    }
                    break;
                }
                default: {
                    for (n = 0; n < n7; ++n) {
                        this.LTht.write(byArray3[n]);
                        this.LTht.write(byArray2[n]);
                        this.LTht.write(byArray[n]);
                        this.LTht.write(byArray4[n]);
                    }
                }
            }
        }
        n = this.LTHt * n8;
        int[] nArray2 = new int[8 * n];
        byte[] byArray5 = new byte[n9];
        if (!this.lTHt) {
            int n20 = n5 + this.lthT;
            for (int i = n20 - 1; i >= n5; i -= 8) {
                int n21 = Math.min(8, i - n5 + 1);
                Raster raster = renderedImage.getData(new Rectangle(n4, i - n21 + 1, this.LTHt, n21));
                raster.getPixels(n4, i - n21 + 1, this.LTHt, n21, nArray2);
                int n22 = 0;
                int n23 = n * n21 - 1;
                for (int j = 0; j < n21; ++j) {
                    n22 = n23 - (j + 1) * n + 1;
                    this.ltht(n22, n, n6, nArray2, byArray5, n18, n8, indexColorModel);
                }
            }
        } else {
            int n24 = n5 + this.lthT;
            for (int i = n5; i < n24; i += 8) {
                int n25 = Math.min(8, n24 - i);
                Raster raster = renderedImage.getData(new Rectangle(n4, i, this.LTHt, n25));
                raster.getPixels(n4, i, this.LTHt, n25, nArray2);
                int n26 = 0;
                for (int j = 0; j < n25; ++j) {
                    this.ltht(n26, n, n6, nArray2, byArray5, n18, n8, indexColorModel);
                }
            }
        }
    }

    private void ltht(int n, int n2, int n3, int[] nArray, byte[] byArray, int n4, int n5, IndexColorModel indexColorModel) throws IOException {
        int n6 = 0;
        int n7 = 0;
        switch (n3) {
            case 1: {
                int n8;
                for (n8 = 0; n8 < n2 / 8; ++n8) {
                    byArray[n7++] = (byte)(nArray[n++] << 7 | nArray[n++] << 6 | nArray[n++] << 5 | nArray[n++] << 4 | nArray[n++] << 3 | nArray[n++] << 2 | nArray[n++] << 1 | nArray[n++]);
                }
                if (n2 % 8 > 0) {
                    n6 = 0;
                    for (n8 = 0; n8 < n2 % 8; ++n8) {
                        n6 |= nArray[n++] << 7 - n8;
                    }
                    byArray[n7++] = (byte)n6;
                }
                this.LTht.write(byArray, 0, (n2 + 7) / 8);
                break;
            }
            case 4: {
                int n8;
                for (n8 = 0; n8 < n2 / 2; ++n8) {
                    n6 = nArray[n++] << 4 | nArray[n++];
                    byArray[n7++] = (byte)n6;
                }
                if (n2 % 2 == 1) {
                    n6 = nArray[n] << 4;
                    byArray[n7++] = (byte)n6;
                }
                this.LTht.write(byArray, 0, (n2 + 1) / 2);
                break;
            }
            case 8: {
                int n8;
                for (n8 = 0; n8 < n2; ++n8) {
                    byArray[n8] = (byte)nArray[n++];
                }
                this.LTht.write(byArray, 0, n2);
                break;
            }
            case 24: {
                int n8;
                if (n5 == 3) {
                    for (n8 = 0; n8 < n2; n8 += 3) {
                        byArray[n7++] = (byte)nArray[n + 2];
                        byArray[n7++] = (byte)nArray[n + 1];
                        byArray[n7++] = (byte)nArray[n];
                        n += 3;
                    }
                    this.LTht.write(byArray, 0, n2);
                    break;
                }
                n8 = indexColorModel.getMapSize();
                byte[] byArray2 = new byte[n8];
                byte[] byArray3 = new byte[n8];
                byte[] byArray4 = new byte[n8];
                indexColorModel.getReds(byArray2);
                indexColorModel.getGreens(byArray3);
                indexColorModel.getBlues(byArray4);
                for (int i = 0; i < n2; ++i) {
                    int n9 = nArray[n];
                    byArray[n7++] = byArray4[n9];
                    byArray[n7++] = byArray3[n9];
                    byArray[n7++] = byArray4[n9];
                    ++n;
                }
                this.LTht.write(byArray, 0, n2 * 3);
            }
        }
        for (n7 = 0; n7 < n4; ++n7) {
            this.LTht.write(0);
        }
    }

    private void Ltht(int n, int n2) throws IOException {
        this.LTht.write(66);
        this.LTht.write(77);
        this.writeDWord(n);
        this.LTht.write(0);
        this.LTht.write(0);
        this.LTht.write(0);
        this.LTht.write(0);
        this.writeDWord(n2);
    }

    private void lTht(int n, int n2) throws IOException {
        this.writeDWord(n);
        this.writeDWord(this.LTHt);
        this.writeDWord(this.lthT);
        this.writeWord(1);
        this.writeWord(n2);
    }

    public void writeWord(int n) throws IOException {
        this.LTht.write(n & 0xFF);
        this.LTht.write((n & 0xFF00) >> 8);
    }

    public void writeDWord(int n) throws IOException {
        this.LTht.write(n & 0xFF);
        this.LTht.write((n & 0xFF00) >> 8);
        this.LTht.write((n & 0xFF0000) >> 16);
        this.LTht.write((n & 0xFF000000) >> 24);
    }
}

