import javax.microedition.rms.*;
import javax.microedition.io.*;
class DataStore{
    ServerSocket seso;
    Index index;
    Search search;
    Download down;
    String server;
    public DataStore(String server){
        this.server=server;
        seso=new ServerSocket(this);
        index=new Index(this);
        search=new Search(this);
        down=new Download(this);
    }
    public String[] getFileNames(){
        return RecordStore.listRecordStores();
    }
    public DiskInputStream getInputStream(String file){
        return new DiskInputStream(file);
    }
    public DiskOutputStream getOutputStream(String file){
        return new DiskOutputStream(file);
    }
    public void delete(String file){
        try{
            RecordStore.deleteRecordStore(file);
        }
        catch(Exception e){
            System.out.println("delete"+e);
        }
    }
    public Result[] search(String find){
        return search.search(find);
    }
    public boolean download(Result r){
        boolean b=false;
        if(down.sendRequest(r)){
            if(down.getDownload(r)){
                b=true;
            }
        }
        return b;
    }
}
class DiskInputStream{
    String file;
    RecordStore fil;
    int pointer=0;
    int filepointer=0;
    int recordpointer=0;
    int recordsize=0;
    int currentrecord=1;
    byte[]lastrec;
    byte[]rec;
    boolean newrecord=true;
    public DiskInputStream(String file){
        this.file=file;
        try{
            fil=RecordStore.openRecordStore(file,true);
        }
        catch(Exception e){
            System.out.println("dis"+e);
        }
    }
    public byte[] readBytes(int length){
        pointer=0;
        byte[]b=new byte[length];
        try{
        rec=fil.getRecord(currentrecord);
        recordsize=fil.getRecordSize(currentrecord);
        while(pointer<length){
            b[pointer]=rec[recordpointer];
            filepointer++;
            recordpointer++;
            pointer++;
            if(recordpointer==recordsize){
                currentrecord++;
                recordpointer=0;
                recordsize=fil.getRecordSize(currentrecord);
                rec=fil.getRecord(currentrecord);
            }
        }
        }
        catch(Exception e){};
        return b;
    }
    public int getSizeb(){
        int u=0;
        try{
            u=fil.getSize();
        }
        catch(Exception e){
            System.out.println("abc"+e);
        }
        return u;
    }
    public int getSize(){
        int u=0;
        try{
            for(int i=1;i<fil.getNextRecordID();i++){
                u=u+fil.getRecordSize(i);
            }
        }
        catch(Exception e){
            System.out.println("abc"+e);
        }
        return u;
    }
    public void close(){
        try{
            fil.closeRecordStore();
        }
        catch(Exception e){
            System.out.println("ass"+e);
        }
    }
}
class DiskOutputStream{
    RecordStore fil;
    public DiskOutputStream(String file){
        try{
            fil=RecordStore.openRecordStore(file,true);
        }
        catch(Exception e){
            System.out.println("wss"+e);
        }
    }
    public void writeBytes(byte[]b){
        try{
            int i=fil.addRecord(b,0,b.length);
        }
        catch(Exception e){
            System.out.println("uzt"+e);
        }
    }
    public void close(){
        try{
            fil.closeRecordStore();
        }
        catch(Exception e){
            System.out.println("xxx"+e);
        }
    }
}
class ServerSocket implements Runnable{
    DatagramConnection dc;
    Datagram dg;
    Thread t;
    DataStore ds;
    public ServerSocket(DataStore ds){
        try{
            dc=(DatagramConnection)Connector.open("datagram://:80");
            dg=dc.newDatagram(1024);
            dg.setAddress("datagram://:80");
        }
        catch(Exception e){
            System.out.println("ServerSocket init"+e);
        }
        this.ds=ds;
        t=new Thread(this);
        t.start();
    }
    public void run(){
        while(true){
            try{
                dg=dc.newDatagram(1024);
                dc.receive(dg);
                byte[]b=dg.getData();
                boolean keins=true;
                for(int i=0;i<b.length;i++){
                    if(b[i]!=0)keins=false;
                }
                if(!keins){
                    String gets=readLine(b);
                    if(gets.equals("index"))listFiles();
                    else sendFile(gets,dg.getAddress());
                }
            }
            catch(Exception e){
                System.out.println("upload"+e);
            }
        }
    }
    public static String readLine(byte[]b){
        String ret="";
        for(int i=0;i<b.length;i++){
            if(b[i]==-1||b[i]==11)break;
            char c=(char)b[i];
            ret=ret+new Character(c).toString();
        }
        int l=ret.indexOf("/");
        int r=ret.indexOf(" ",l);
        if((l-r)==1)return "index";
        else return ret.substring(l+1,r);
    }
    public void listFiles(){
        String[]files=ds.getFileNames();
        int gesamtlength=0;
        for(int i=0;i<files.length;i++){
            gesamtlength=gesamtlength+files[i].length();
            gesamtlength++;
            gesamtlength=gesamtlength+ds.getInputStream(files[i]).getSize();
            gesamtlength++;
        }
        byte[]listbytes=new byte[gesamtlength];
        int counter=0;
        for(int i=0;i<files.length;i++){
            for(int j=0;j<files[i].length();j++){
                listbytes[counter]=(byte)files[i].charAt(j);
                counter++;
            }
            listbytes[counter]=11;
            counter++;
            String f=""+ds.getInputStream(files[i]).getSize();
            for(int j=0;j<f.length();j++){
                listbytes[counter]=(byte)f.charAt(j);
                counter++;
            }
            listbytes[counter]=11;
            counter++;
        }
        try{
            dg=dc.newDatagram(1024);
            byte[]be=new byte[1024];
            String st=""+listbytes.length;
            for(int i=0;i<st.length();i++){
                be[i]=(byte)st.charAt(i);
            }
            be[st.length()]=12;
            dg.setData(be,0,1024);
            dg=dc.newDatagram(listbytes.length);
            dg.setData(listbytes,0,listbytes.length);
            dc.send(dg);
        }
        catch(Exception e){
            System.out.println("listbytes"+e);
        }
    }
    public void sendFile(String gets,String adr){
        DiskInputStream dis=ds.getInputStream(gets);
        int i=dis.getSize();
        byte[]fdata=new byte[i];
        fdata=dis.readBytes(i);
        try{
            byte[]byt=new byte[1024];
            dg=dc.newDatagram(1024);
            dg.setAddress(adr);
            int le=0;
            String str=""+fdata.length;
            le=str.length();
            for(int j=0;j<le;j++){
                byt[j]=(byte)Character.digit(str.charAt(j),10);
            }
            byt[le]=11;
            dg.setData(byt,0,byt.length);
            dc.send(dg);
            dg=dc.newDatagram(fdata.length);
            dg.setAddress(adr);
            dg.setData(fdata,0,fdata.length);
            dc.send(dg);
        }
        catch(Exception e){
            System.out.println("sendfile"+e);
        }
    }
}
class Index implements Runnable{
    DataStore ds;
    Thread t;
    Datagram dg;
    DatagramConnection dc;
    public Index(DataStore ds){
        this.ds=ds;
        t=new Thread(this);
        String[]files=ds.getFileNames();
        try{
            dc=(DatagramConnection)Connector.open(ds.server+":1024");
            dg=dc.newDatagram(1024);
        }
        catch(Exception e){
            System.out.println("indexcons"+e);
        }
        int blength=0;
        if(files!=null){
        for(int i=0;i<files.length;i++){
            blength=blength+files[i].length()+1;
            DiskInputStream dis=ds.getInputStream(files[i]);
            int size=dis.getSize();
            blength=blength+(""+size).length()+1;
        }
        byte[]data=new byte[blength];
        int pointer=0;
        for(int i=0;i<files.length;i++){
            for(int j=0;j<files[i].length();j++){
                data[pointer]=(byte)files[i].charAt(j);
                pointer++;
            }
            data[pointer]=11;
            pointer++;
            DiskInputStream dis=ds.getInputStream(files[i]);
            int size=dis.getSize();
            String ble=(""+size);
            int blen=ble.length();
            for(int j=0;j<blen;j++){
                data[pointer]=(byte)ble.charAt(j);
                pointer++;
            }
            data[pointer]=11;
            pointer++;
        }
        try{
            dc=(DatagramConnection)Connector.open(ds.server+":1024");
            dg=dc.newDatagram(1024);
            dg.setAddress(ds.server+":1024");
            byte[]be=new byte[1024];
            String st=""+data.length;
            for(int i=0;i<st.length();i++){
                be[i]=(byte)st.charAt(i);
            }
            be[st.length()]=12;
            dg.setData(be,0,1024);
            dc.send(dg);
            dg=dc.newDatagram(data.length);
            dg.setAddress(ds.server+":1024");
            dg.setData(data,0,data.length);
            dc.send(dg);
        }
        catch(Exception e){
            System.out.println("tre"+e);
        }
        t.start();
        }
    }
    public void run(){
        while(true){
            try{
                Thread.sleep(20000);
                dc=(DatagramConnection)Connector.open(ds.server+":1025");
                dg=dc.newDatagram(1024);
                dg.setAddress(ds.server+":1025");
                dg.setData(new byte[0],0,0);
                dc.send(dg);
            }
            catch(Exception e){
                System.out.println("weo"+e);
            }
        }
    }
}
class Search{
    DataStore ds;
    Datagram dg;
    DatagramConnection dc;
    public Search(DataStore ds){
        this.ds=ds;
        try{
            dc=(DatagramConnection)Connector.open("datagram://:81");
            dg=dc.newDatagram(1024);
            dg.setAddress(ds.server+":1026");
        }
        catch(Exception e){
            System.out.println("searchinit"+e);
        }
    }
    public Result[] search(String find){
        int bl=find.length();
        byte[]b=new byte[1024];
        for(int i=0;i<bl;i++){
            b[i]=(byte)find.charAt(i);
        }
        b[bl]=11;
        byte[]result=new byte[0];
        try{
            dg=dc.newDatagram(1024);
            dg.setAddress(ds.server+":1026");
            dg.setData(b,0,1024);
            dc.send(dg);
            dg=dc.newDatagram(1024);
            dg.setData(new byte[1024],0,1024);
            dc.receive(dg);
            while(testdata(dg.getData())){
                dc.receive(dg);
            }
            int size=getNumber(dg.getData());
            dg=dc.newDatagram(size);
            dc.receive(dg);
            while(testdata(dg.getData())){
                dc.receive(dg);
            }
            result=dg.getData();
        }
        catch(Exception e){
            System.out.println("search"+e);
        }
        Pusher p=new Pusher(result);
        int rc=p.getResultCount();
        Result[]r=new Result[rc];
        for(int i=0;i<rc;i++){
            r[i]=p.getNextResult();
        }
        return r;
    }
    public static boolean testdata(byte[]b){
        boolean ret=true;
        for(int i=0;i<b.length;i++){
            if(b[i]!=0)ret=false;
        }
        return ret;
    }
    public static int getNumber(byte[]b){
        int nco=0;
        for(int i=0;i<b.length;i++){
            int temp=b[i];
            if(temp>=0&&temp<=9){
                nco=nco+temp;
                nco=nco*10;
            }
            else break;
        }
        nco=nco/10;
        return nco;
    }
}

class Download{
    DataStore ds;
    Datagram dg;
    DatagramConnection dc;
    public Download(DataStore ds){
        this.ds=ds;
    }
    public boolean sendRequest(Result rs){
        boolean correct=true;
        String ustr=rs.url+":80";
        int ui=ustr.indexOf("/");
        ustr="datagram://"+ustr.substring(ui+1);
        try{
            dc=(DatagramConnection)Connector.open(ustr);
            dg=dc.newDatagram(1024);
            dg.setAddress(ustr);
        }
        catch(Exception e){
            System.out.println("request"+e);
            correct=false;
        }
        byte[]b=new byte[1024];
        String send="/"+rs.filename+" ";
        for(int i=0;i<send.length();i++){
            b[i]=(byte)send.charAt(i);
        }
        try{
            dg.setData(b,0,1024);
            dg.setAddress(ustr);
            dc.send(dg);
        }
        catch(Exception e){
            System.out.println("request2"+e);
            correct=false;
        }
        return correct;
    }
    public boolean getDownload(Result rs){
        boolean correct=true;
        byte[]result=new byte[0];
        try{
            dg=dc.newDatagram(1024);
            dc.receive(dg);
            while(Search.testdata(dg.getData())){
                dc.receive(dg);
            }
            int size=Search.getNumber(dg.getData());
            dg=dc.newDatagram(size);
            dc.receive(dg);
            while(Search.testdata(dg.getData())){
                dc.receive(dg);
            }
            result=dg.getData();
        }
        catch(Exception e){
            System.out.println("gdownload"+e);
            correct=false;
        }
        DiskOutputStream diso=ds.getOutputStream(rs.filename);
        diso.writeBytes(result);
        return correct;
    }
}

class Pusher{
    byte[]b;
    int pointer=0;
    public Pusher(byte[]b){
        this.b=b;
    }
    public int getResultCount(){
        int coun=0;
        for(int i=0;i<b.length;i++){
            if(b[i]==11)coun++;
        }
        return coun/3;
    }
    public Result getNextResult(){
        String filename=getNextString();
        String url=getNextString();
        String size=getNextString();
        return new Result(filename,url,size);
    }
    public String getNextString(){
        String nstring="";
        while(pointer<b.length&&b[pointer]!=11){
            nstring=nstring+new Character((char)b[pointer]).toString();
            pointer++;
        }
        pointer++;
        return nstring;
    }
}
class Result{
    String filename;
    String url;
    String size;
    public Result(String a,String b,String c){
        filename=a;
        url=b;
        size=c;
    }
}
