program WaterMark;
{$APPTYPE CONSOLE}
uses
  SysUtils,
  PDF,
  Graphics;

var
  MyPDF: TPDFDocument;
  MF: TMetafile;
  I, J: Integer;
begin                   
  try
    MyPDF := TPDFDocument.Create(nil);
    try
      MyPDF.AutoLaunch := True;
      MyPDF.Compression := ctFlate;
      MyPDF.FileName := 'Data\PDFFiles\waterMark.pdf';
      MyPDF.DocumentInfo.Title := 'llPDFLib 2 Demo [WaterMark]';
      MyPDF.OnePass := True;
      MyPDF.BeginDoc;
      J := MyPDF.CreateWaterMark;
      MF := TMetafile.Create;
      try
        MyPDF.WaterMark[J].Width := 376;
        MyPDF.WaterMark[J].Height := 373;
        MF.LoadFromFile('Data\Images\logo.emf');
        MyPDF.WaterMark[J].PlayMetaFile(MF);
      finally
        MF.Free;
      end;
      try
        for I := 1 to 100 do
        begin
          if I <> 1 then MyPDF.NewPage;
          MyPDF.CurrentPage.Width := 376;
          MyPDF.CurrentPage.Height := 373;
          MyPDF.CurrentPage.WaterMark := J;
        end;
        MyPDF.EndDoc;
      except
        on Exception do
        begin
          MyPDF.Abort;
          raise;
        end;
      end;
    finally
      MyPDF.Free;
    end;
  except
    on E: Exception do
      Writeln(E.message);
  end;
end.

