////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// PropEditDlg.cpp : implementation file
//

#include "stdafx.h"
#include "cutecontrols.h"
#include "PropEditDlg.h"
#include "BarPropPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

HBITMAP  _CopyBitmap(HBITMAP hBmpSrc);
int _EditPicture(HWND Parent, HBITMAP hBmp, int cx, int cy, HBITMAP& hNewBmp);

/////////////////////////////////////////////////////////////////////////////
// CPropEditDlg dialog


CPropEditDlg::CPropEditDlg(CWnd* pParent)
	: CDialog(CPropEditDlg::IDD, pParent)
{
    m_pItemProp = NULL;
    m_bLoaded = FALSE;
	//{{AFX_DATA_INIT(CPropEditDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
    Create(IDD_EDITPROP_DLG, pParent);
}

CPropEditDlg::~CPropEditDlg()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    DestroyWindow();
}



BEGIN_MESSAGE_MAP(CPropEditDlg, CDialog)
	//{{AFX_MSG_MAP(CPropEditDlg)
	ON_BN_CLICKED(IDC_BTN_PICTURE, OnBtnPicture)
	ON_EN_CHANGE(IDC_EDIT_NAME, OnChange)
	ON_CBN_SELCHANGE(IDC_COMBO_ALIGN, OnSelchangeComboAlign)
	ON_EN_CHANGE(IDC_EDIT_TOP, OnChange)
	ON_EN_CHANGE(IDC_EDIT_WIDTH, OnChange)
	ON_EN_CHANGE(IDC_EDIT_LEFT, OnChange)
	ON_EN_CHANGE(IDC_EDIT_ID, OnChange)
	ON_EN_CHANGE(IDC_EDIT_HEIGHT, OnChange)
	ON_EN_CHANGE(IDC_EDIT_ED_PSWD, OnChange)
	ON_EN_CHANGE(IDC_EDIT_ED_TEXT, OnChange)
	ON_BN_CLICKED(IDC_CHECK_VISIBLE, OnChange)
	ON_BN_CLICKED(IDC_CHECK_EDIT_RO, OnChange)
	ON_BN_CLICKED(IDC_CHECK_EDIT_BORDER, OnChange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPropEditDlg message handlers

BOOL CPropEditDlg::ReadProp(IItem* pItem, EDIT_PROPERTIES* pEProp)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CComPtr<IItem> spItem = pItem;

    m_bLoaded = FALSE;  // Prop page SetDirty update protection

    ASSERT(spItem);

    CComBSTR Name;
    if(FAILED(spItem->get_Name(&Name)))
        return FALSE;
    pEProp->Name = Name;

    long ID = -1;
    if(FAILED(spItem->get_ID(&ID)))
        return FALSE;
    pEProp->Id = ID;

    VARIANT_BOOL bVisible; 
    if(FAILED(spItem->get_Visible(&bVisible)))
        return FALSE;
    pEProp->Visible = bVisible ? TRUE: FALSE;

    //  Width
    long width = 0;
    if(FAILED(spItem->get_ControlWidth(&width)))
        return FALSE;
    pEProp->width = width;

    long top = 0;
    if(FAILED(spItem->get_ControlTop(&top)))
        return FALSE;
    pEProp->top = top;

    long left = 0;
    if(FAILED(spItem->get_ControlLeft(&left)))
        return FALSE;
    pEProp->left = left;

    long height = 0;
    if(FAILED(spItem->get_ControlHeight(&height)))
        return FALSE;
    pEProp->height = height;

    // Set Prop Align
   enAlignment nSelect =(enAlignment)ccALeft;
   if(FAILED(spItem->get_Alignment(&nSelect)))
        return FALSE;
    pEProp->Alignment =(int)nSelect; 

    // Get Edit Object interface
    CComPtr<IEdit> spEdit;
    if(FAILED(spItem->get_Edit(&spEdit)))
        return FALSE;

    // Set ReadOnly
    VARIANT_BOOL bRO = VARIANT_FALSE;
    if(FAILED(spEdit->get_ReadOnly(&bRO)))
        return FALSE;
    pEProp->ReadOnly = bRO ? VARIANT_TRUE : VARIANT_FALSE; 

    // Set Border
    VARIANT_BOOL bBorder = VARIANT_FALSE;
    if(FAILED(spEdit->get_Border(&bBorder)))
        return FALSE;
    pEProp->Boder = bBorder ? VARIANT_TRUE : VARIANT_FALSE;
    
     // Set Text
    long nMax = 120;
    if(FAILED(spEdit->get_MaxLength(&nMax)))
        return FALSE;
    pEProp->MaxLenght =(int)nMax; 

    CComBSTR bstr;
    if(FAILED(spEdit->get_Text(&bstr)))
        return FALSE;
    CString str(bstr);
    pEProp->Text = str; 

     // Set Password Char
    CComBSTR bstr1;
    if(FAILED(spEdit->get_PasswordChar(&bstr1)))
        return FALSE;
    CString PassChar(bstr1);
    pEProp->PassChar = PassChar; 

    // Set Picture
    CComPtr<IPictureDisp> pPic;
    HBITMAP hBmp = NULL;
    if (SUCCEEDED(spItem->get_Image(&pPic)))
    {
       CComQIPtr<IPicture,&IID_IPicture> spPic(pPic);
        if (spPic)
            spPic->get_Handle((UINT*)&hBmp);
    }
    pEProp->hPic = hBmp;

    return TRUE;
}

BOOL CPropEditDlg::SetProp(IItem* pItem, EDIT_PROPERTIES* pEProp)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    CComPtr<IItem> spItem = pItem;

    CComBSTR Name = pEProp->Name.AllocSysString();
    if(FAILED(spItem->put_Name(Name)))
        return FALSE;

    long ID = pEProp->Id;
    if(FAILED(spItem->put_ID(ID)))
        return FALSE;

    VARIANT_BOOL bVisible = pEProp->Visible ? VARIANT_TRUE:VARIANT_FALSE;
    if(FAILED(spItem->put_Visible(bVisible)))
        return FALSE;

    enItemType type = (enItemType) pEProp->Type;
    if(FAILED(spItem->put_Type(type)))
        return FALSE;

    long width = pEProp->width;
    if(FAILED(spItem->put_ControlWidth(width)))
        return FALSE;

    long top = pEProp->top;
    if(FAILED(spItem->put_ControlTop(top)))
        return FALSE;

    long left = pEProp->left;
    if(FAILED(spItem->put_ControlLeft(left)))
        return FALSE;

    long height = pEProp->height;
    if(FAILED(spItem->put_ControlHeight(height)))
        return FALSE;

    enAlignment nSelect =(enAlignment)pEProp->Alignment;
    if(FAILED(spItem->put_Alignment(nSelect)))
        return FALSE;

    // Get Edit Object interface
    CComPtr<IEdit> spEdit;
    if(FAILED(spItem->get_Edit(&spEdit)))
        return FALSE;

    // Set ReadOnly
    VARIANT_BOOL bRO = pEProp->ReadOnly ? VARIANT_TRUE : VARIANT_FALSE;
    if(FAILED(spEdit->put_ReadOnly(bRO)))
        return FALSE;

    // Set Border
    VARIANT_BOOL bBorder = pEProp->Boder ? VARIANT_TRUE : VARIANT_FALSE;
    if(FAILED(spEdit->put_Border(bBorder)))
        return FALSE;

    // Set Text
    long nMax = pEProp->MaxLenght;
    if(FAILED(spEdit->put_MaxLength(nMax)))
        return FALSE;

    CComBSTR bstr(pEProp->Text);
    if(FAILED(spEdit->put_Text(bstr)))
        return FALSE;

     // Set Password Char
    CComBSTR bstr1(pEProp->PassChar);
    if(FAILED(spEdit->put_PasswordChar(bstr1)))
        return FALSE;

    // Set Picture
//    if (pEProp->Pic.bDirty)
    {
        CPictureHolder* pPicHolder = new CPictureHolder;
        pPicHolder->CreateFromBitmap(pEProp->hPic);  
        if (FAILED(spItem->put_Image(pPicHolder->GetPictureDispatch())))
            return FALSE;
    }

    return TRUE;
}

void CPropEditDlg::OnBtnPicture() 
{
    BAR_PROPRETIES*  pBarProp = m_pItemProp->pBar;
    
    int cx = pBarProp->ImageWidth;
    int cy = pBarProp->ImageHeight;

    HBITMAP hBmp = NULL;
    if (_EditPicture(m_hWnd, m_pItemProp->hPic, cx, cy,hBmp) == IDCANCEL)    
        return;

    m_pItemProp->hPic = hBmp;
    OnChange();
    // Set Picture
    CButton PicPreView;
    PicPreView.Attach(::GetDlgItem(m_hWnd, IDC_IMAGE_PREVIEW));
    PicPreView.SetBitmap(NULL);
//    if (m_pItemProp->Pic.hPic)
        PicPreView.SetBitmap(m_pItemProp->hPic);
    PicPreView.Detach();
}

void CPropEditDlg::OnChange() 
{
   if (m_pItemProp && m_bLoaded)
   {
        m_pItemProp->bDirty = TRUE;	
        Update(m_pItemProp);
        // Notify Propery page to turn on "Apply" button
       ::PostMessage(::GetParent(m_hWnd),WM_MODIFIED, NULL, NULL); 
   }
}

BOOL CPropEditDlg::Update(EDIT_PROPERTIES *pProp)
{
   if (!pProp || !pProp->bDirty) return FALSE;

   int ID = GetDlgItemInt(IDC_EDIT_ID);
   pProp->Id = ID;

   TCHAR buffer[256];
   GetDlgItemText(IDC_EDIT_NAME,buffer,sizeof(buffer));
   pProp->Name = buffer; // CSting copy

   BOOL bChk = IsDlgButtonChecked(IDC_CHECK_VISIBLE ) == BST_CHECKED;
   pProp->Visible = bChk;

   bChk = IsDlgButtonChecked(IDC_CHECK_ENABLED) == BST_CHECKED;
   pProp->Enabled = bChk;

   CString str;
    GetDlgItemText(IDC_EDIT_ED_TEXT,str.GetBuffer(1024),1024);
    pProp->Text = str;

    CString psw_ch;
    GetDlgItemText(IDC_EDIT_ED_PSWD,psw_ch.GetBuffer(2),2);
    pProp->PassChar = psw_ch;

    bChk = IsDlgButtonChecked(IDC_CHECK_EDIT_BORDER) == BST_CHECKED;
    pProp->Boder = bChk;

    bChk = IsDlgButtonChecked(IDC_CHECK_EDIT_RO) == BST_CHECKED;
    pProp->ReadOnly = bChk;

    //======= Common with Combo & Label
     int height = GetDlgItemInt(IDC_EDIT_HEIGHT);
     pProp->height = height;

     int width = GetDlgItemInt(IDC_EDIT_WIDTH);
     pProp->width = width;

     int top = GetDlgItemInt(IDC_EDIT_TOP);
     pProp->top = top;

     int left = GetDlgItemInt(IDC_EDIT_LEFT);
     pProp->left = left;
     //===============================================

    // Aligment
    CComboBox ComboBox;
    ComboBox.Attach(::GetDlgItem(m_hWnd, IDC_COMBO_ALIGN));
    enAlignment nSelect =(enAlignment)ccALeft;
    nSelect = (enAlignment)ComboBox.GetCurSel();
    ComboBox.Detach();
    pProp->Alignment = nSelect;

    return TRUE;
}

void CPropEditDlg::OnSelchangeComboAlign() 
{
    OnChange();
}

BOOL CPropEditDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
    CComboBox ComboBox;
    ComboBox.Attach(::GetDlgItem(m_hWnd, IDC_COMBO_ALIGN));
    int i  = 0;
    ComboBox.InsertString(i++,_T("ccALeft"));
    ComboBox.InsertString(i++,_T("ccACenter"));
    ComboBox.InsertString(i++,_T("ccARight"));
    ComboBox.Detach();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPropEditDlg::ShowData(EDIT_PROPERTIES *pEProp)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    m_pItemProp = pEProp;
    m_bLoaded = FALSE;  // Prop page SetDirty update protection


    SetDlgItemText(IDC_EDIT_NAME, pEProp->Name);

    // Set ID
    SetDlgItemInt(IDC_EDIT_ID, pEProp->Id);

    // Set Visible
    CheckDlgButton(IDC_CHECK_VISIBLE,           // Set the check box
                  pEProp->Visible ? BST_CHECKED : BST_UNCHECKED);
    // Set Enabled
    CheckDlgButton(IDC_CHECK_ENABLED,           
                  pEProp->Enabled ? BST_CHECKED : BST_UNCHECKED);

    //  Width
    SetDlgItemInt(IDC_EDIT_WIDTH,pEProp->width,FALSE);

    SetDlgItemInt(IDC_EDIT_TOP,pEProp->top,FALSE);

    SetDlgItemInt(IDC_EDIT_LEFT,pEProp->left,FALSE);

    SetDlgItemInt(IDC_EDIT_HEIGHT,pEProp->height,FALSE);

    // Set Prop Align
    CComboBox ComboBox;
    ComboBox.Attach(::GetDlgItem(m_hWnd,IDC_COMBO_ALIGN));    
    ComboBox.SetCurSel(pEProp->Alignment);
    ComboBox.Detach();

    // Set ReadOnly
    CheckDlgButton(IDC_CHECK_EDIT_RO,           
                  pEProp->ReadOnly ? BST_CHECKED : BST_UNCHECKED);
    // Set Border
    CheckDlgButton(IDC_CHECK_EDIT_BORDER,           
                   pEProp->Boder ? BST_CHECKED : BST_UNCHECKED);    
     // Set Text
    CEdit editText;
    editText.Attach(::GetDlgItem(m_hWnd, IDC_EDIT_ED_TEXT));
    editText.SetLimitText(pEProp->MaxLenght);

    SetDlgItemText(IDC_EDIT_ED_TEXT,pEProp->Text);
    editText.Detach();

     // Set Password Char
    CEdit edit;
    edit.Attach(::GetDlgItem(m_hWnd, IDC_EDIT_ED_PSWD));
    edit.SetLimitText(1);
    SetDlgItemText(IDC_EDIT_ED_PSWD,pEProp->PassChar);
    edit.Detach();

    // Set Picture
    CButton PicPreView;
    PicPreView.Attach(::GetDlgItem(m_hWnd, IDC_IMAGE_PREVIEW));
    PicPreView.SetBitmap(NULL);
    if (pEProp->hPic)
        PicPreView.SetBitmap(pEProp->hPic);
    PicPreView.Detach();

    m_bLoaded = TRUE;
    return TRUE;
}
