////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// ItemCollection.h : Declaration of the CIItemCollection

#ifndef __ITEMCOLLECTION_H_
#define __ITEMCOLLECTION_H_

#include "resource.h"       // main symbols
#include <vector>
#include "Item.h"
#include "Reuse\VCUE_Copy.h"
#include "VCU_ItemCopy.h"

namespace ItemColl
{
	// Store our data in a vector of std::strings
    typedef CComObject<CIItem>* ContObj;
    typedef std::vector< ContObj >		            ContainerType;

	// Use IEnumVARIANT as the enumerator for VB compatibility
	typedef VARIANT									EnumeratorExposedType;
	typedef IEnumVARIANT							EnumeratorInterface;

	// Our collection interface exposes the data as BSTRs
	typedef IItem*    	    				        CollectionExposedType;
	typedef IItemCollection							CollectionInterface;

	// Typedef the copy classes using existing typedefs
	typedef VCUE::GenericCopy<EnumeratorExposedType, ContainerType::value_type>		EnumeratorCopyType;
	typedef VCUE::GenericCopy<CollectionExposedType, ContainerType::value_type>		CollectionCopyType;

	// Now we have all the information we need to fill in the template arguments on the implementation classes
	typedef CComEnumOnSTL< EnumeratorInterface, &__uuidof(EnumeratorInterface), EnumeratorExposedType,
							EnumeratorCopyType, ContainerType > EnumeratorType;

	typedef ICollectionOnSTLImpl< CollectionInterface, ContainerType, CollectionExposedType,
							CollectionCopyType, EnumeratorType > CollectionType;

}; // namespace ItemColl;

/////////////////////////////////////////////////////////////////////////////
// CIItemCollection
class ATL_NO_VTABLE CIItemCollection : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CIItemCollection, &CLSID_ItemCollection>,
	public ISupportErrorInfo,
   	public IPersistStreamInitImpl<CIItemCollection>,
    public IPersistStorageImpl<CIItemCollection>,
    public IDispatchImpl<ItemColl::CollectionType, &IID_IItemCollection, &LIBID_CuteControlsLib>
{
public:
	CIItemCollection();
	~CIItemCollection();

DECLARE_REGISTRY_RESOURCEID(IDR_ITEMCOLLECTION)

DECLARE_ONLY_AGGREGATABLE(CIItemCollection)

DECLARE_PROTECT_FINAL_CONSTRUCT()

DECLARE_GET_CONTROLLING_UNKNOWN()

BEGIN_COM_MAP(CIItemCollection)
	COM_INTERFACE_ENTRY(IItemCollection)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersistStream, IPersistStreamInit)
END_COM_MAP()

BEGIN_PROP_MAP(CIItemCollection)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
//	 PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// IItemCollection
public:
    CICuteBar* m_pMainControl;
    unsigned  m_bRequiresSave:1;

// IPersistStream
public:
	STDMETHOD(Clear)();
	STDMETHOD(Remove)(/*[in]*/ VARIANT* Index);
	STDMETHOD(Add)(/*[in]*/ long ID,  /*[in, optional]*/ enItemType Type,/*[out, retval]*/ IItem** pVal);
	STDMETHOD(Insert)(/*[in]*/ VARIANT *ItemAfter,  /*[in]*/VARIANT *ItemMove);
    void RemoveAll();
    HRESULT IPersistStreamInit_Load(LPSTREAM pStm, ATL_PROPMAP_ENTRY* pMap);
    HRESULT IPersistStreamInit_Save(LPSTREAM pStm, BOOL fClearDirty, ATL_PROPMAP_ENTRY* pMap);

public:
	void SetMainControl(CICuteBar* pControl);
	STDMETHOD(get_Item)(/*[in]*/VARIANT* Index, /*[out, retval]*/ IItem** pVal);

protected:
	HRESULT CreateObject(ItemColl::ContObj* pObj,IUnknown** ppItem);
	BOOL RestoreObjects(LPSTREAM pStm);
	BOOL SaveObjects(LPSTREAM pStm, BOOL fClearDirty);

};

#endif //__ITEMCOLLECTION_H_
