/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.util.collections;

import com.softaspects.framework.galileo.support.util.collections.ContainedListProvider;
import com.softaspects.framework.galileo.support.util.collections.ContainerListener;
import com.softaspects.framework.galileo.support.util.collections.ListProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class BoundList
extends ListProxy {
    public static final long serialVersionUID = 3392510652753377744L;
    private transient List fListeners = new ArrayList(2);
    protected Object fEventSource = this;
    protected Object fLock = this;
    public static final int INITIAL_LISTENERS_COUNT = 2;

    public BoundList(List aList) {
        super(aList);
    }

    public BoundList(ContainedListProvider aProvider) {
        super(aProvider);
    }

    public BoundList() {
    }

    public void setLock(Object aLock) {
        if (this.fLock != this) {
            throw new IllegalArgumentException("Lock is already specified");
        }
        this.fLock = aLock;
    }

    public void setEventSource(Object aSource) {
        this.fEventSource = aSource;
    }

    public void add(int anIndex, Object anElement) {
        Object object = this.fLock;
        synchronized (object) {
            this.beforeAddElement(anElement);
            this.getContainedList().add(anIndex, anElement);
            this.fireAddElement(anElement);
        }
    }

    public boolean retainAll(Collection anElements) {
        boolean result = false;
        Object object = this.fLock;
        synchronized (object) {
            ArrayList elementsToRemove = new ArrayList();
            Iterator iter = anElements.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (this.getContainedList().contains(element)) continue;
                elementsToRemove.add(element);
            }
            this.beforeRemoveElements(anElements);
            result = this.getContainedList().retainAll(anElements);
            if (result) {
                this.fireRemoveElements(elementsToRemove);
            }
        }
        return result;
    }

    public Object set(int anIndex, Object anElement) {
        Object object = this.fLock;
        synchronized (object) {
            Object result = this.getContainedList().get(anIndex);
            this.beforeRemoveElement(result);
            this.beforeAddElement(anElement);
            this.getContainedList().set(anIndex, anElement);
            this.fireRemoveElement(result);
            this.fireAddElement(anElement);
            return result;
        }
    }

    public boolean add(Object anElement) {
        boolean result = false;
        Object object = this.fLock;
        synchronized (object) {
            this.beforeAddElement(anElement);
            result = this.getContainedList().add(anElement);
            if (result) {
                this.fireAddElement(anElement);
            }
        }
        return result;
    }

    public boolean addAll(Collection anElements) {
        boolean result = false;
        Object object = this.fLock;
        synchronized (object) {
            this.beforeAddElement(anElements);
            result = this.getContainedList().addAll(anElements);
            if (result) {
                this.fireAddElements(anElements);
            }
        }
        return result;
    }

    public boolean moveToTail(Object aObject) {
        Object object = this.fLock;
        synchronized (object) {
            int index = this.getContainedList().indexOf(aObject);
            if (index != -1) {
                this.getContainedList().remove(index);
                this.getContainedList().add(aObject);
                return true;
            }
        }
        return false;
    }

    public boolean moveToHead(Object aObject) {
        Object object = this.fLock;
        synchronized (object) {
            List containedList = this.getContainedList();
            int index = containedList.indexOf(aObject);
            if (index != -1) {
                containedList.remove(index);
                containedList.add(0, aObject);
                return true;
            }
        }
        return false;
    }

    public boolean removeAll(Collection anElements) {
        boolean result = false;
        Object object = this.fLock;
        synchronized (object) {
            this.beforeRemoveElements(anElements);
            result = this.getContainedList().removeAll(anElements);
            if (result) {
                this.fireRemoveElements(anElements);
            }
        }
        return result;
    }

    public void clear() {
        this.removeAll((Collection)new ArrayList(this.getContainedList()));
    }

    public boolean addAll(int anIndex, Collection anElements) {
        boolean result = false;
        Object object = this.fLock;
        synchronized (object) {
            this.beforeAddElements(anElements);
            result = this.getContainedList().addAll(anElements);
            if (result) {
                this.fireAddElements(anElements);
            }
        }
        return result;
    }

    public boolean remove(Object anElement) {
        boolean result = false;
        Object object = this.fLock;
        synchronized (object) {
            this.beforeRemoveElement(anElement);
            result = this.getContainedList().remove(anElement);
            if (result) {
                this.fireRemoveElement(anElement);
            }
        }
        return result;
    }

    public Object remove(int anIndex) {
        Object result = null;
        Object object = this.fLock;
        synchronized (object) {
            this.beforeRemoveElement(this.getContainedList().get(anIndex));
            result = this.getContainedList().remove(anIndex);
            this.fireRemoveElement(result);
        }
        return result;
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator() {
        return new BoundListIterator(this, 0);
    }

    public ListIterator listIterator(int parm1) {
        return new BoundListIterator(this, parm1);
    }

    protected void beforeAddElement(Object anElement) {
    }

    protected void beforeRemoveElement(Object anElement) {
    }

    protected void beforeAddElements(Collection anElements) {
    }

    protected void beforeRemoveElements(Collection anElements) {
    }

    public synchronized void addContainerListener(ContainerListener aListener) {
        if (this.fListeners == null) {
            this.fListeners = new ArrayList(2);
        }
        this.fListeners.add(aListener);
    }

    public synchronized void removeContainerListener(ContainerListener aListener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove(aListener);
    }

    protected void fireAddElement(Object aElement) {
        if (this.fListeners == null) {
            return;
        }
        int listenersSize = this.fListeners.size();
        int i = 0;
        while (i < listenersSize) {
            ContainerListener listener = (ContainerListener)this.fListeners.get(i);
            if (listener != null) {
                listener.elementAdded(aElement, this.fEventSource);
            }
            ++i;
        }
    }

    protected void fireRemoveElement(Object aElement) {
        if (this.fListeners == null) {
            return;
        }
        int listenersSize = this.fListeners.size();
        int i = 0;
        while (i < listenersSize) {
            ContainerListener listener = (ContainerListener)this.fListeners.get(i);
            if (listener != null) {
                listener.elementRemoved(aElement, this.fEventSource);
            }
            ++i;
        }
    }

    protected void fireAddElements(Collection anElements) {
        if (this.fListeners == null) {
            return;
        }
        int listenersSize = this.fListeners.size();
        int i = 0;
        while (i < listenersSize) {
            ContainerListener listener = (ContainerListener)this.fListeners.get(i);
            if (listener != null) {
                listener.elementsAdded(anElements, this.fEventSource);
            }
            ++i;
        }
    }

    protected void fireRemoveElements(Collection anElements) {
        if (this.fListeners == null) {
            return;
        }
        int listenersSize = this.fListeners.size();
        int i = 0;
        while (i < listenersSize) {
            ContainerListener listener = (ContainerListener)this.fListeners.get(i);
            if (listener != null) {
                listener.elementsRemoved(anElements, this.fEventSource);
            }
            ++i;
        }
    }

    class BoundListIterator
    implements ListIterator {
        private int fIndex = 0;
        private BoundList fList = null;

        public BoundListIterator(BoundList aList, int aInitialIndex) {
            this.fIndex = aInitialIndex;
            this.fList = aList;
        }

        public void add(Object obj) {
            this.fList.add(obj);
        }

        public boolean hasNext() {
            return this.fIndex <= this.fList.size() - 1;
        }

        public boolean hasPrevious() {
            return this.fIndex > 0;
        }

        public Object next() {
            Object result = this.fList.get(this.fIndex);
            ++this.fIndex;
            return result;
        }

        public int nextIndex() {
            if (this.fIndex == this.fList.size()) {
                return this.fIndex;
            }
            return this.fIndex + 1;
        }

        public Object previous() {
            --this.fIndex;
            Object result = this.fList.get(this.fIndex);
            return result;
        }

        public int previousIndex() {
            int result = this.fIndex - 1;
            if (result < 0) {
                result = -1;
            }
            return result;
        }

        public void remove() {
            this.fList.remove(this.fIndex);
        }

        public void set(Object obj) {
            this.fList.set(this.fIndex, obj);
        }
    }
}

