/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class PriorityHashMap
extends TreeMap {
    private HashMap fKeyPriorityMap = new HashMap();

    public PriorityHashMap() {
        super(new CompareByPriority());
    }

    public Object put(Object aKey, Object aValue, int aPriority) {
        PriorityHashMap.validateKey(aKey);
        this.fKeyPriorityMap.put(aKey, new Integer(aPriority));
        return this.put(new PriorityKey(aKey, aPriority), aValue);
    }

    public Object put(Object aKey, Object aValue) {
        PriorityHashMap.validateKey(aKey);
        if (!(aKey instanceof PriorityKey)) {
            System.out.println("PriorityHashMap: Type not supported: " + aKey.getClass().getName());
        }
        return super.put(aKey, aValue);
    }

    public Object get(Object aKey, int aPriority) {
        PriorityHashMap.validateKey(aKey);
        return super.get(new PriorityKey(aKey, aPriority));
    }

    public Object get(Object aKey) {
        PriorityHashMap.validateKey(aKey);
        if (aKey instanceof PriorityKey) {
            return super.get(aKey);
        }
        Integer priority = (Integer)this.fKeyPriorityMap.get(aKey);
        return priority == null ? null : super.get(new PriorityKey(aKey, priority));
    }

    public Object remove(Object aKey) {
        PriorityHashMap.validateKey(aKey);
        Integer priority = (Integer)this.fKeyPriorityMap.get(aKey);
        return priority == null ? null : super.remove(new PriorityKey(aKey, priority));
    }

    public void clear() {
        this.fKeyPriorityMap.clear();
        super.clear();
    }

    public Iterator getKeyIterator() {
        return new KeyValuesIterator(super.keySet().iterator());
    }

    public Object findValue(Object aKey) {
        PriorityHashMap.validateKey(aKey);
        Object result = null;
        Iterator keys = this.getKeyIterator();
        boolean getValue = false;
        while (keys.hasNext()) {
            Object key = keys.next();
            if (key.equals(aKey)) {
                getValue = true;
            }
            if (getValue && (result = this.get(aKey)) != null) break;
        }
        return result;
    }

    private static void validateKey(Object aKey) {
        if (aKey == null) {
            throw new IllegalArgumentException("PriorityHashMap: Key can't be null.");
        }
    }

    private class PriorityKey {
        int fPriority;
        Object fKey;

        public PriorityKey(Object aKey, int aPriority) {
            this.fPriority = aPriority;
            this.fKey = aKey;
        }

        public PriorityKey(Object aKey, Integer aPriority) {
            this(aKey, (int)aPriority);
        }

        public int getPriority() {
            return this.fPriority;
        }

        public Object getKey() {
            return this.fKey;
        }

        public boolean equals(Object aObject) {
            PriorityKey priorityKey;
            if (aObject != null && aObject instanceof PriorityKey && (priorityKey = (PriorityKey)aObject).getPriority() == this.getPriority()) {
                return priorityKey.getKey().equals(this.getKey());
            }
            return false;
        }
    }

    private static class CompareByPriority
    implements Comparator {
        CompareByPriority() {
        }

        public boolean equals(Object aObject) {
            return false;
        }

        public int compare(Object aObject1, Object aObject2) {
            if (aObject1 instanceof PriorityKey && aObject2 instanceof PriorityKey) {
                int priority2;
                int priority1 = ((PriorityKey)aObject1).getPriority();
                return priority1 < (priority2 = ((PriorityKey)aObject2).getPriority()) ? 1 : (aObject1.equals(aObject2) ? 0 : -1);
            }
            throw new IllegalArgumentException("PriorityHashMap: Comparator type not supported." + aObject1.getClass().getName() + " - " + aObject2.getClass().getName());
        }
    }

    private class KeyValuesIterator
    implements Iterator {
        private Iterator fPriorityKeyIterator;

        public KeyValuesIterator(Iterator aPriorityKeyIterator) {
            this.fPriorityKeyIterator = aPriorityKeyIterator;
        }

        public boolean hasNext() {
            return this.fPriorityKeyIterator.hasNext();
        }

        public Object next() {
            PriorityKey priorityKey = (PriorityKey)this.fPriorityKeyIterator.next();
            return priorityKey.getKey();
        }

        public void remove() {
            this.fPriorityKeyIterator.remove();
        }
    }
}

