/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.listmodel;

import com.softaspects.framework.galileo.components.base.Interval;
import com.softaspects.framework.galileo.support.components.listmodel.ListSelectionModel;
import java.util.ArrayList;
import java.util.BitSet;

public class ListSelectionModelImpl
implements ListSelectionModel {
    private static final int MAX_VALUE = Integer.MAX_VALUE;
    private static final int MIN_VALUE = Integer.MIN_VALUE;
    protected int fType = 1;
    protected BitSet fSelect = new BitSet(32);
    protected int fMinIndex = Integer.MAX_VALUE;
    protected int fMaxIndex = Integer.MIN_VALUE;
    protected boolean fSelectionChanged = false;

    public ListSelectionModelImpl() {
        if (this.getSelectionType() == 1) {
            this.setSelectionInterval(new Interval(0));
        }
    }

    public void setSelectionType(int aType) {
        if (aType < 1 || aType > 3) {
            throw new IllegalArgumentException("ListSelectionModel: Type is not supported.");
        }
        this.fType = aType;
    }

    public int getSelectionType() {
        return this.fType;
    }

    public boolean isSelectionChanged() {
        return this.fSelectionChanged;
    }

    public void setSelectionChangedNotify() {
        this.fSelectionChanged = false;
    }

    public void setSelectionInterval(Interval aInterval) {
        int top = aInterval.getTop();
        int bottom = aInterval.getBottom();
        if (top < 0 || bottom < 0) {
            ListSelectionModelImpl.generateExceptionIfInvalidInterval();
        }
        if (this.fType == 1) {
            top = bottom;
        }
        int clearMin = this.fMinIndex;
        int clearMax = this.fMaxIndex;
        int setMin = Math.min(top, bottom);
        int setMax = Math.max(top, bottom);
        this.changeSelection(clearMin, clearMax, setMin, setMax);
    }

    public void addSelectionInterval(Interval aInterval) {
        int top = aInterval.getTop();
        int bottom = aInterval.getBottom();
        if (top < 0 || bottom < 0) {
            ListSelectionModelImpl.generateExceptionIfInvalidInterval();
        }
        if (this.fType != 3) {
            this.setSelectionInterval(new Interval(top, bottom));
        } else {
            int clearMin = Integer.MAX_VALUE;
            int clearMax = Integer.MIN_VALUE;
            int setMin = Math.min(top, bottom);
            int setMax = Math.max(top, bottom);
            this.changeSelection(clearMin, clearMax, setMin, setMax);
        }
    }

    public void select(int aIndex) {
        this.addSelectionInterval(new Interval(aIndex));
    }

    public void deselect(int aIndex) {
        this.removeSelectionInterval(new Interval(aIndex));
    }

    public void removeSelectionInterval(Interval aInterval) {
        int top = aInterval.getTop();
        int bottom = aInterval.getBottom();
        if (top < 0 || bottom < 0) {
            ListSelectionModelImpl.generateExceptionIfInvalidInterval();
        }
        int clearMin = Math.min(top, bottom);
        int clearMax = Math.max(top, bottom);
        int setMin = Integer.MAX_VALUE;
        int setMax = Integer.MIN_VALUE;
        if (this.fType != 3 && clearMin > this.fMinIndex && clearMax < this.fMaxIndex) {
            clearMax = this.fMaxIndex;
        }
        this.changeSelection(clearMin, clearMax, setMin, setMax);
    }

    public Interval[] getSelectionIntervals() {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        int top = Integer.MAX_VALUE;
        int i = this.fMinIndex;
        while (i <= this.fMaxIndex) {
            if (top == Integer.MAX_VALUE && this.fSelect.get(i)) {
                top = i;
            } else if (top != Integer.MAX_VALUE && !this.fSelect.get(i)) {
                intervals.add(new Interval(top, i - 1));
                top = Integer.MAX_VALUE;
            }
            ++i;
        }
        if (top != Integer.MAX_VALUE) {
            intervals.add(new Interval(top, this.fMaxIndex));
        }
        Interval[] result = new Interval[intervals.size()];
        intervals.toArray(result);
        return result;
    }

    public int getSelectionCount() {
        int result = 0;
        if (!this.isEmpty()) {
            int i = this.fMinIndex;
            while (i <= this.fMaxIndex) {
                if (this.fSelect.get(i)) {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }

    public int[] getSelectionIndexes() {
        int[] result = new int[this.getSelectionCount()];
        int i = this.fMinIndex;
        int j = 0;
        while (i <= this.fMaxIndex) {
            if (this.fSelect.get(i)) {
                result[j++] = i;
            }
            ++i;
        }
        return result;
    }

    public int getFirstSelection() {
        return this.isEmpty() ? -1 : this.fMinIndex;
    }

    public int getLastSelection() {
        return this.isEmpty() ? -1 : this.fMaxIndex;
    }

    public boolean isSelected(int aIndex) {
        return this.contains(this.fMinIndex, this.fMaxIndex, aIndex) ? this.fSelect.get(aIndex) : false;
    }

    public void clear() {
        this.removeSelectionInterval(new Interval(this.fMinIndex, this.fMaxIndex));
    }

    public boolean isEmpty() {
        return this.fMinIndex > this.fMaxIndex;
    }

    private void setSelected(int aIndex) {
        if (!this.isSelected(aIndex)) {
            this.fSelectionChanged = true;
            this.fSelect.set(aIndex);
            this.fMinIndex = Math.min(this.fMinIndex, aIndex);
            this.fMaxIndex = Math.max(this.fMaxIndex, aIndex);
        }
    }

    private void clearSelection(int aIndex) {
        if (!this.fSelect.get(aIndex)) {
            return;
        }
        this.fSelect.clear(aIndex);
        this.fSelectionChanged = true;
        if (aIndex == this.fMinIndex) {
            ++this.fMinIndex;
            while (this.fMinIndex <= this.fMaxIndex) {
                if (this.fSelect.get(this.fMinIndex)) break;
                ++this.fMinIndex;
            }
        }
        if (aIndex == this.fMaxIndex) {
            --this.fMaxIndex;
            while (this.fMinIndex <= this.fMaxIndex) {
                if (this.fSelect.get(this.fMaxIndex)) break;
                --this.fMaxIndex;
            }
        }
    }

    private boolean contains(int aTop, int aBottom, int aIndex) {
        return aIndex >= aTop && aIndex <= aBottom;
    }

    private void changeSelection(int aClearMin, int aClearMax, int aSetMin, int aSetMax) {
        int i = Math.min(aSetMin, aClearMin);
        while (i <= Math.max(aSetMax, aClearMax)) {
            boolean shouldClear = this.contains(aClearMin, aClearMax, i);
            boolean shouldSet = this.contains(aSetMin, aSetMax, i);
            if (shouldSet) {
                this.setSelected(i);
            } else if (shouldClear) {
                this.clearSelection(i);
            }
            ++i;
        }
    }

    private static void generateExceptionIfInvalidInterval() {
        throw new IllegalArgumentException("ListSelectionModel: Invalid selection interval.");
    }
}

